/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.actions;

import com.alibaba.fastjson.JSONObject;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.actiondispatcher.ActionUtil;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.dc.utils.MCDBUtil;
import kd.bos.dc.utils.SQLUtils;
import kd.bos.dlock.DLock;
import kd.bos.encrypt.Encrypters;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.exception.LoginErrorCode;
import kd.bos.lang.Lang;
import kd.bos.license.service.LicenseServiceImpl;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.CacheLoginData;
import kd.bos.login.LoginClientEnum;
import kd.bos.login.VerifyCode;
import kd.bos.login.actions.dto.ActiveUserService;
import kd.bos.login.actions.dto.MsgChannel;
import kd.bos.login.lang.LoginLangUtils;
import kd.bos.login.model.Language;
import kd.bos.login.service.DispatchServiceHelper;
import kd.bos.login.service.dto.LoginUserDTO;
import kd.bos.login.service.session.dto.SessionParams;
import kd.bos.login.thirdauth.UserProperType;
import kd.bos.login.user.DefaultParameterService;
import kd.bos.login.user.LicenseService;
import kd.bos.login.user.LoginUserService;
import kd.bos.login.user.PrivacyPolicyService;
import kd.bos.login.user.PswStrategyService;
import kd.bos.login.user.SmsService;
import kd.bos.login.util.GlobalDeployUtils;
import kd.bos.login.utils.AdminUtils;
import kd.bos.login.utils.AgentUtil;
import kd.bos.login.utils.ErrorCodeUtils;
import kd.bos.login.utils.JSONUtils;
import kd.bos.login.utils.LocalCacheUtils;
import kd.bos.login.utils.LoginUtils;
import kd.bos.login.utils.MessageUtils;
import kd.bos.login.utils.ParametersUtils;
import kd.bos.login.utils.PswStrategyUtils;
import kd.bos.login.utils.SecurityUtils;
import kd.bos.login.utils.StrategeUtils;
import kd.bos.login.utils.TransferUtil;
import kd.bos.login.utils.ValidationUtils;
import kd.bos.login.utils.account.LoginAccount;
import kd.bos.login.utils.account.LoginAccountFactory;
import kd.bos.login.utils.log.AppLogParams;
import kd.bos.login.utils.log.LoginLogUtils;
import kd.bos.login.utils.sms.LoginMessageUtils;
import kd.bos.login.utils.sms.impl.KDSMSSender;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.util.HttpClientUtils;
import kd.bos.util.NetAddressUtils;
import kd.bos.util.PasswordEncryptUtil;
import kd.bos.util.RevProxyUtil;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class ResetPasswordAction {
    private static final String RANDOM_CODE = "randomCode";
    private static final String MSG = "msg";
    private static final String PASSWORD_WARNING = "passwordWarning";
    private static final String OVER_TIME = "overTime";
    private static final String FIND_PSW_BY_EMAIL_KEY = "findPswByEmail_";
    private static final String DESCRIPTION_CN = "description_cn";
    private static final String ERRCODE = "errcode";
    private static final String SIGNITURE_STR = "&signiture=";
    private static final String TIMESTAMP_STR = "&timestamp=";
    private static final String PROD_INST_CODE_STR = "&prod_inst_code=";
    private static final String UTF_8 = "UTF-8";
    private static final String CLIENT_ID2 = "?client_id=";
    private static final String UID_STR = "&uid=";
    private static final String PROD_INST_CODE = "prod_inst_code";
    private static final String NUMBER = "number";
    private static final String ERROR_TIME = "errorTime";
    private static final String P_CODE = "pCode";
    private static final String ERROR = "error";
    private static final String RESET_PASSWORD_ACTION_7 = "ResetPasswordAction_7";
    private static final String ACCOUNT_ID = "accountId";
    private static final String TOTAL_TIME = "totalTime";
    private static final String E_MAIL = "eMail";
    private static final String LEVEL = "level";
    private static final String SUCCESS = "success";
    private static final String BOS_LOGIN = "bos-login";
    private static final String V_CODE_TIME = "vCodeTime";
    private static final String V_CODE = "vCode";
    private static final String REFRESH_CODE = "refreshCode";
    private static final String EMAIL = "email";
    private static Log logger = LogFactory.getLog(ResetPasswordAction.class);
    public static final String CLIENT_ID = "client_id";
    public static final String CLIENT_SECRET = "client_secret";
    public static final String PHONE = "phone";
    public static final String SMSCODE = "smscode";
    public static final String CONTENT = "content";
    public static final String SIGNATURE = "signature";
    public static final String COUNTRY_CODE = "country_code";
    private static final int HTTP_STATUS_OK = 200;
    private static final int VERIFYCODE_TIMEOUT = 60;
    private static final int VERIFYCODE_LONGTIME = 300;
    private static final String RESETPWD = "resetpwd";
    private static final String ACTIVEPWD = "activepwd";
    private static final String VALUE_0 = "0";
    private static final String VALUE_1 = "1";

    public void getVerifyCode(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            Lang lang = LoginLangUtils.getLoginLanguage(request);
            LoginLangUtils.setLang(lang);
            VerifyCode vc = new VerifyCode();
            BufferedImage bim = vc.getImage();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bim, "JPEG", out);
            String content = Base64.encodeBase64String((byte[])out.toByteArray());
            response.setCharacterEncoding(UTF_8);
            response.setContentType("text/json;charset=UTF-8");
            String verifycode = vc.getText();
            String vCodeToken = UUID.randomUUID().toString();
            String phone = request.getParameter(PHONE);
            CacheLoginData.setAttribute((String)RESETPWD, (String)(phone + vCodeToken), (String)verifycode, (int)60);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(CONTENT, "data:image/jpeg;base64," + content);
            map.put(V_CODE, vCodeToken);
            map.put(V_CODE_TIME, String.valueOf(60000));
            DLock.create((String)vCodeToken);
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)JSONUtils.toString(map));
        }
        catch (Exception e) {
            logger.error("getVerifyCode", (Throwable)e);
            String resp = LoginUtils.getLoginResponse(VALUE_1, ResManager.loadKDString((String)"\u7cfb\u7edf\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"LoginAction_0", (String)BOS_LOGIN, (Object[])new Object[0]));
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)resp);
        }
    }

    public void verifyCode(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Lang lang = LoginLangUtils.getLoginLanguage(request);
        LoginLangUtils.setLang(lang);
        String token = request.getParameter("token");
        String vCode = request.getParameter(V_CODE);
        String phone = request.getParameter(PHONE);
        String vCodeCache = CacheLoginData.getAttribute((String)RESETPWD, (String)(phone + token));
        HashMap<String, Object> mpData = new HashMap<String, Object>();
        if (vCodeCache == null) {
            mpData.put(SUCCESS, false);
            mpData.put(MSG, ResManager.loadKDString((String)"\u9a8c\u8bc1\u7801\u8d85\u65f6\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u65b0\u8f93\u5165\u3002", (String)"ResetPasswordAction_1", (String)BOS_LOGIN, (Object[])new Object[0]));
            String result = JSONUtils.toString(mpData);
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)result);
            return;
        }
        boolean isSame = vCodeCache.equalsIgnoreCase(vCode);
        if (isSame) {
            CacheLoginData.setAttribute((String)RESETPWD, (String)(phone + token), (String)"true", (int)300);
            mpData.put(SUCCESS, true);
        } else {
            CacheLoginData.setAttribute((String)RESETPWD, (String)(phone + token), (String)"verifyCodeFalse", (int)300);
            mpData.put(SUCCESS, false);
            mpData.put(MSG, ResManager.loadKDString((String)"\u8f93\u5165\u56fe\u5f62\u9a8c\u8bc1\u7801\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"ResetPasswordAction_2", (String)BOS_LOGIN, (Object[])new Object[0]));
        }
        String result = JSONUtils.toString(mpData);
        ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void verifyPhone(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException {
        Lang lang = LoginLangUtils.getLoginLanguage(servletRequest);
        LoginLangUtils.setLang(lang);
        String phone = servletRequest.getParameter(PHONE);
        Account currentCenter = LoginAccountFactory.createInstanceByHttpRequest(servletRequest, Optional.empty()).getAccount();
        int msgTimeout = LoginMessageUtils.getMsgTimeout(currentCenter);
        Map<String, Object> mpData = new HashMap<String, Object>(8);
        String vCodeToken = servletRequest.getParameter(V_CODE);
        String vCodeTokenValue = CacheLoginData.getAttribute((String)RESETPWD, (String)(phone + vCodeToken));
        if (!"true".equals(vCodeTokenValue)) {
            mpData.put(SUCCESS, false);
            mpData.put(REFRESH_CODE, true);
            mpData.put(LEVEL, 2);
            mpData.put(MSG, ResManager.loadKDString((String)"\u56fe\u7247\u9a8c\u8bc1\u7801\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"ResetPasswordAction_4", (String)BOS_LOGIN, (Object[])new Object[0]));
            String result = JSONUtils.toString(mpData);
            ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)result);
            return;
        }
        if (!ValidationUtils.isPhone(phone) && !AdminUtils.getAdminList().contains(phone)) {
            mpData.put(SUCCESS, false);
            mpData.put(LEVEL, 2);
            mpData.put("customMsg", true);
            mpData.put(MSG, ResManager.loadKDString((String)"\u624b\u673a\u53f7\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"ResetPasswordAction_81", (String)BOS_LOGIN, (Object[])new Object[0]));
            String result = JSONUtils.toString(mpData);
            ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)result);
            return;
        }
        if ((mpData = this.getCheckSendResult(phone, mpData, msgTimeout)) != null && "false".equals(String.valueOf(mpData.get(SUCCESS)))) {
            String result = JSONUtils.toString(mpData);
            ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)result);
            return;
        }
        DLock lock = null;
        Map<String, Object> map = null;
        try {
            lock = DLock.create((String)(currentCenter.getAccountId() + phone));
            if (lock.tryLock(3000L)) {
                map = this.prepareAndSendMsg(servletRequest, servletResponse, phone, mpData);
            }
        }
        catch (Exception ex) {
            logger.error("resetPassword\u5f02\u5e38", (Throwable)ex);
            CacheLoginData.remove((String)RESETPWD, (String)(phone + vCodeToken));
            return;
        }
        finally {
            if (lock != null) {
                lock.unlock();
            }
        }
        this.setMapTime(map, msgTimeout);
        CacheLoginData.remove((String)RESETPWD, (String)(phone + vCodeToken));
        String result = JSONUtils.toString(map);
        ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)result);
    }

    private void setMapTime(Map<String, Object> map, int msgTimeout) {
        if (null != map) {
            boolean timeFlag;
            boolean bl = timeFlag = null != map.get(SUCCESS) && (Boolean)map.get(SUCCESS) != false && null == map.get(V_CODE_TIME);
            if (timeFlag) {
                map.put(V_CODE_TIME, msgTimeout * 1000);
            }
        }
    }

    public void verifyEmail(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException {
        Account currentCenter = LoginAccountFactory.createInstanceByHttpRequest(servletRequest, Optional.empty()).getAccount();
        Lang lang = LoginLangUtils.getLoginLanguage(servletRequest);
        LoginLangUtils.setLang(lang);
        HashMap<String, Object> mpData = new HashMap<String, Object>();
        String email = servletRequest.getParameter(EMAIL);
        String vCodeToken = servletRequest.getParameter(V_CODE);
        String vCodeTokenValue = CacheLoginData.getAttribute((String)RESETPWD, (String)(email + vCodeToken));
        boolean isAdmin = AdminUtils.getAdminList().contains(email);
        if (!ValidationUtils.isEmail(email) && !isAdmin) {
            mpData.put(SUCCESS, false);
            boolean isGlobalDeploy = GlobalDeployUtils.isGlobalDeploy((String)RevProxyUtil.getTenantId((HttpServletRequest)servletRequest));
            if (!isGlobalDeploy) {
                mpData.put(LEVEL, 2);
                mpData.put("customMsg", true);
            }
            mpData.put(MSG, ResManager.loadKDString((String)"\u90ae\u7bb1\u683c\u5f0f\u9519\u8bef\u3002", (String)"ResetPasswordAction_94", (String)BOS_LOGIN, (Object[])new Object[0]));
            String result = JSONUtils.toString(mpData);
            ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)result);
            return;
        }
        if (!"true".equals(vCodeTokenValue)) {
            mpData.put(SUCCESS, false);
            mpData.put(REFRESH_CODE, true);
            mpData.put(LEVEL, 2);
            mpData.put(MSG, ResManager.loadKDString((String)"\u56fe\u7247\u9a8c\u8bc1\u7801\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"ResetPasswordAction_4", (String)BOS_LOGIN, (Object[])new Object[0]));
            String result = JSONUtils.toString(mpData);
            ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)result);
            return;
        }
        CacheLoginData.setAttribute((String)RESETPWD, (String)(email + vCodeToken), (String)"", (int)0);
        String attribute = CacheLoginData.getAttribute((String)RESETPWD, (String)email);
        if (attribute != null && attribute.trim().length() != 0) {
            mpData.put(SUCCESS, false);
            mpData.put(MSG, ResManager.loadKDString((String)"\u90ae\u4ef6\u5df2\u53d1\u9001\uff0c\u6709\u6548\u671f5\u5206\u949f\u3002", (String)"ResetPasswordAction_5", (String)BOS_LOGIN, (Object[])new Object[0]));
            String result = JSONUtils.toString(mpData);
            ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)result);
            return;
        }
        String total = CacheLoginData.getAttribute((String)RESETPWD, (String)(email + TOTAL_TIME));
        int totalCount = 0;
        if (total != null && (totalCount = Integer.parseInt(total)) >= 10) {
            mpData.put(SUCCESS, false);
            mpData.put(MSG, ResManager.loadKDString((String)"\u4eca\u65e5\u90ae\u7bb1\u53d1\u9001\u6b21\u6570\u5df2\u8fbe10\u6b21\u4e0a\u9650\u3002", (String)"ResetPasswordAction_6", (String)BOS_LOGIN, (Object[])new Object[0]));
            String result = JSONUtils.toString(mpData);
            ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)result);
            return;
        }
        ++totalCount;
        Map<String, Object> map = this.sendEmail(servletRequest, currentCenter, email);
        AppLogParams appLogParams = LoginLogUtils.initParams(servletRequest, currentCenter, email, EMAIL);
        appLogParams.setOpName(ResManager.loadKDString((String)"\u627e\u56de\u5bc6\u7801", (String)"ResetPasswordAction_89", (String)BOS_LOGIN, (Object[])new Object[0]));
        if (map.get(SUCCESS) instanceof Boolean && ((Boolean)map.get(SUCCESS)).booleanValue()) {
            if (VALUE_0.equals(map.get("user"))) {
                appLogParams.setResult(false);
            } else {
                CacheLoginData.setAttribute((String)RESETPWD, (String)(email + TOTAL_TIME), (String)String.valueOf(totalCount), (int)this.getSecondsNextDay());
                CacheLoginData.setAttribute((String)RESETPWD, (String)email, (String)"send", (int)300);
            }
            mpData.put(SUCCESS, true);
            mpData.put(MSG, ResManager.loadKDString((String)"\u90ae\u4ef6\u5df2\u53d1\u9001!", (String)"ResetPasswordAction_8", (String)BOS_LOGIN, (Object[])new Object[0]));
        } else {
            appLogParams.setResult(false);
            mpData.put(SUCCESS, false);
            mpData.put(MSG, map.get(MSG));
        }
        appLogParams.setAdmin(isAdmin);
        LoginLogUtils.addAppLog(appLogParams);
        String result = JSONUtils.toString(mpData);
        ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)result);
    }

    public int getSecondsNextDay() {
        Calendar cal = Calendar.getInstance();
        cal.add(6, 1);
        cal.set(11, 0);
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(14, 0);
        Long seconds = (cal.getTimeInMillis() - System.currentTimeMillis()) / 1000L;
        return seconds.intValue();
    }

    private Map<String, Object> prepareAndSendMsg(HttpServletRequest servletRequest, HttpServletResponse servletResponse, String phone, Map<String, Object> mpData) throws IOException {
        Account currentCenter = LoginAccountFactory.createInstanceByHttpRequest(servletRequest, Optional.empty()).getAccount();
        int msgTimeout = LoginMessageUtils.getMsgTimeout(currentCenter);
        if ((mpData = this.getCheckSendResult(phone, mpData, msgTimeout)) != null && "false".equals(String.valueOf(mpData.get(SUCCESS)))) {
            return mpData;
        }
        boolean isAdmin = AdminUtils.getAdminList().contains(phone);
        if (!isAdmin && (mpData = this.checkUserStatus(phone, mpData)).get(SUCCESS) != null && !((Boolean)mpData.get(SUCCESS)).booleanValue()) {
            if (mpData.get(PHONE) != null) {
                mpData.put(SUCCESS, true);
                mpData.put(V_CODE_TIME, msgTimeout * 1000);
                mpData.remove(PHONE);
            }
            return mpData;
        }
        SecureRandom random = new SecureRandom();
        int pCode = random.nextInt(1000000);
        String pCodeStr = "00000" + pCode;
        pCodeStr = pCodeStr.substring(pCodeStr.length() - 6);
        pCodeStr = this.modifyPhoneCode(pCodeStr);
        CacheLoginData.setAttribute((String)RESETPWD, (String)(phone + P_CODE), (String)pCodeStr, (int)300);
        String message = String.format(ResManager.loadKDString((String)"\u9a8c\u8bc1\u7801\uff1a%1s\uff0c\u6765\u81ea\u624b\u673a\u627e\u56de\u5bc6\u7801\uff0c5\u5206\u949f\u5185\u6709\u6548\u3002", (String)"ResetPasswordAction_11", (String)BOS_LOGIN, (Object[])new Object[0]), pCodeStr);
        String signature = this.parseSmsConfig(SmsService.getSmsConfig(currentCenter));
        if (StringUtils.isBlank((String)signature)) {
            signature = ResManager.loadKDString((String)"\u91d1\u8776\u4e91", (String)"ResetPasswordAction_12", (String)BOS_LOGIN, (Object[])new Object[0]);
        }
        String countryCode = "86";
        boolean sendMessage = false;
        String total = CacheLoginData.getAttribute((String)RESETPWD, (String)(phone + TOTAL_TIME + RevProxyUtil.getTenantId((HttpServletRequest)servletRequest)));
        int totalCount = 0;
        if (total != null && (totalCount = Integer.parseInt(total)) >= 10) {
            mpData = new HashMap<String, Object>(4);
            mpData.put(SUCCESS, false);
            mpData.put(MSG, ErrorCodeUtils.getSMSOverTimesError());
            return mpData;
        }
        ++totalCount;
        if (isAdmin) {
            String adminPhone = this.getAdminPhone(currentCenter, phone);
            if (StringUtils.isEmpty((String)adminPhone)) {
                mpData.put(SUCCESS, true);
                mpData.put(MSG, ResManager.loadKDString((String)"\u8d26\u53f7\u672a\u7ed1\u5b9a\u624b\u673a\u53f7\u3002", (String)"ResetPasswordAction_92", (String)BOS_LOGIN, (Object[])new Object[0]));
                return mpData;
            }
            sendMessage = MessageUtils.sendMessage(adminPhone, pCodeStr, message, signature, Lang.get());
            if (!sendMessage) {
                KDSMSSender smsSender = new KDSMSSender();
                sendMessage = smsSender.sendMessage(adminPhone, message, signature);
            }
        } else {
            sendMessage = MessageUtils.sendMessage(phone, pCodeStr, message, signature, Lang.get());
        }
        AppLogParams logParams = LoginLogUtils.initParams(servletRequest, currentCenter, phone, PHONE);
        logParams.setOpName(ResManager.loadKDString((String)"\u627e\u56de\u5bc6\u7801", (String)"ResetPasswordAction_89", (String)BOS_LOGIN, (Object[])new Object[0]));
        logParams.setAdmin(isAdmin);
        if (sendMessage) {
            CacheLoginData.setAttribute((String)RESETPWD, (String)phone, (String)pCodeStr, (int)msgTimeout);
            mpData = new HashMap<String, Object>();
            mpData.put(SUCCESS, true);
            mpData.put(V_CODE_TIME, msgTimeout * 1000);
            CacheLoginData.setAttribute((String)RESETPWD, (String)(phone + TOTAL_TIME + RevProxyUtil.getTenantId((HttpServletRequest)servletRequest)), (String)String.valueOf(totalCount), (int)this.getSecondsNextDay());
        } else {
            mpData = new HashMap<String, Object>();
            mpData.put(SUCCESS, false);
            logParams.setResult(false);
            mpData.put(MSG, ResManager.loadKDString((String)"\u9a8c\u8bc1\u7801\u53d1\u9001\u5931\u8d25\u3002", (String)"ResetPasswordAction_13", (String)BOS_LOGIN, (Object[])new Object[0]));
        }
        LoginLogUtils.addAppLog(logParams);
        return mpData;
    }

    private String parseSmsConfig(String smsConfig) {
        String signature = null;
        if (StringUtils.isBlank((String)smsConfig)) {
            return null;
        }
        try {
            Map smsConfigMap = (Map)JSONObject.parseObject((String)smsConfig, Map.class);
            String signatureMultiLang = smsConfigMap.get(SIGNATURE).toString();
            Map signatureMap = (Map)JSONObject.parseObject((String)signatureMultiLang, Map.class);
            signature = signatureMap.get(LoginLangUtils.getLang().name()).toString();
        }
        catch (Exception e) {
            logger.error("ResetPasswordAction--parseSmsConfig error", (Throwable)e);
        }
        return signature;
    }

    private boolean isEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }

    private String getAdminPhone(Account currentAccount, String phone) {
        DynamicObject[] userArray = LoginUserService.getUserList(phone, UserProperType.UserName, true);
        if (userArray != null && userArray.length > 0) {
            DynamicObject user = userArray[0];
            return user.getString(PHONE);
        }
        return null;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean getErpUserInfo(Account currentAccount, String account) {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        boolean isExist = false;
        try {
            Properties dataBaseProperties = AccountUtils.getTenantDBInfo((Account)currentAccount);
            if (dataBaseProperties == null) {
                throw new KDException(BosErrorCode.configNotFound, new Object[]{ErrorCodeUtils.getDBGetError()});
            }
            conn = MCDBUtil.getConnection((Account)currentAccount, (Properties)dataBaseProperties);
            String sql = ValidationUtils.isEmail(account) ? "SELECT b.fid from t_sec_user a LEFT JOIN t_sec_user_u b on a.fid = b.fid where a.femail = ? and a.fenable = '1'  and a.fnumber not in(" + AdminUtils.getAdminStr() + ") " : "SELECT b.fid from t_sec_user a LEFT JOIN t_sec_user_u b on a.fid = b.fid where a.fphone = ? and a.fenable = '1'  and a.fnumber not in(" + AdminUtils.getAdminStr() + ") ";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, account);
            rs = stmt.executeQuery();
            if (rs.next()) {
                isExist = true;
            }
        }
        catch (SQLException e) {
            try {
                throw new KDException((Throwable)e, BosErrorCode.sQLConnection, new Object[]{ErrorCodeUtils.getDBIntralError() + LoginUtils.SPLIT_SIGN + e.getMessage()});
                catch (Exception e2) {
                    throw new KDException((Throwable)e2, BosErrorCode.sQLConnection, new Object[]{ErrorCodeUtils.getDBIntralError() + LoginUtils.SPLIT_SIGN + e2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return isExist;
    }

    public void verifyPhoneCode(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException {
        Map<String, Object> mpData = this.verifyPhoneCode(servletRequest);
        String result = JSONUtils.toString(mpData);
        ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)result);
    }

    private Map<String, Object> verifyPhoneCode(HttpServletRequest servletRequest) {
        Lang lang = LoginLangUtils.getLoginLanguage(servletRequest);
        LoginLangUtils.setLang(lang);
        String phone = servletRequest.getParameter(PHONE);
        String code = servletRequest.getParameter("code");
        String phoneVCode = CacheLoginData.getAttribute((String)RESETPWD, (String)(phone + P_CODE));
        HashMap<String, Object> mpData = new HashMap<String, Object>(8);
        String randomCode = UUID.randomUUID().toString();
        if (phoneVCode == null) {
            String status = CacheLoginData.getAttribute((String)RESETPWD, (String)(phone + "_sendStatus"));
            String msg = "false".equals(status) ? ResManager.loadKDString((String)"\u77ed\u4fe1\u9a8c\u8bc1\u7801\u8f93\u5165\u6709\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"ResetPasswordAction_15", (String)BOS_LOGIN, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u77ed\u4fe1\u9a8c\u8bc1\u7801\u8d85\u65f6\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6\u9a8c\u8bc1\u7801\u3002", (String)"ResetPasswordAction_14", (String)BOS_LOGIN, (Object[])new Object[0]);
            mpData.put(SUCCESS, false);
            mpData.put(MSG, msg);
        } else {
            mpData.put(SUCCESS, true);
            if (!phoneVCode.equals(code)) {
                mpData.put(SUCCESS, false);
                mpData.put(MSG, ResManager.loadKDString((String)"\u77ed\u4fe1\u9a8c\u8bc1\u7801\u8f93\u5165\u6709\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"ResetPasswordAction_15", (String)BOS_LOGIN, (Object[])new Object[0]));
                String errorTime = CacheLoginData.getAttribute((String)RESETPWD, (String)(phone + ERROR_TIME));
                int errorCount = 0;
                if (errorTime != null && errorTime.trim().length() != 0 && (errorCount = Integer.parseInt(errorTime)) >= 2) {
                    mpData = new HashMap();
                    mpData.put(SUCCESS, false);
                    mpData.put(MSG, ResManager.loadKDString((String)"\u9a8c\u8bc1\u5931\u8d25\uff0c\u5df2\u8d85\u8fc7\u9a8c\u8bc1\u6b21\u6570\uff0c\u8bf7\u91cd\u65b0\u53d1\u9001\u77ed\u4fe1\u9a8c\u8bc1\u7801\u3002", (String)"ResetPasswordAction_16", (String)BOS_LOGIN, (Object[])new Object[0]));
                    mpData.put(REFRESH_CODE, true);
                    CacheLoginData.setAttribute((String)RESETPWD, (String)(phone + ERROR_TIME), (String)"");
                    CacheLoginData.setAttribute((String)RESETPWD, (String)(phone + P_CODE), (String)"");
                    CacheLoginData.setAttribute((String)RESETPWD, (String)phone, (String)"");
                    return mpData;
                }
                CacheLoginData.setAttribute((String)RESETPWD, (String)(phone + ERROR_TIME), (String)String.valueOf(++errorCount));
            } else {
                CacheLoginData.setAttribute((String)RESETPWD, (String)(phone + ERROR_TIME), (String)String.valueOf(0));
                CacheLoginData.setAttribute((String)RESETPWD, (String)(phone + NUMBER), (String)"true", (int)300);
                CacheLoginData.setAttribute((String)RESETPWD, (String)(phone + RANDOM_CODE), (String)randomCode, (int)300);
            }
        }
        mpData.put(RANDOM_CODE, randomCode);
        return mpData;
    }

    public void getCloudPhoneCode(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException {
        boolean isGlobalDeploy;
        Lang lang = LoginLangUtils.getLoginLanguage(servletRequest);
        LoginLangUtils.setLang(lang);
        String account = servletRequest.getParameter(PHONE);
        if (StringUtils.isEmpty((String)account)) {
            account = servletRequest.getParameter(E_MAIL);
        }
        Map<Object, Object> mpData = new HashMap<String, Object>(8);
        boolean isEmail = ValidationUtils.isEmail(account);
        if (!isEmail && (isGlobalDeploy = GlobalDeployUtils.isGlobalDeploy((String)RevProxyUtil.getTenantId((HttpServletRequest)servletRequest)))) {
            mpData.put(SUCCESS, false);
            mpData.put(ERROR, ResManager.loadKDString((String)"\u90ae\u7bb1\u683c\u5f0f\u9519\u8bef\u3002", (String)"ResetPasswordAction_94", (String)BOS_LOGIN, (Object[])new Object[0]));
            String result = JSONUtils.toString(mpData);
            ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)result);
            return;
        }
        String token = servletRequest.getParameter("token");
        String vCode = servletRequest.getParameter(V_CODE);
        String vCodeCache = CacheLoginData.getAttribute((String)RESETPWD, (String)(account + token));
        if (vCodeCache == null) {
            mpData.put(SUCCESS, false);
            mpData.put(LEVEL, 2);
            mpData.put(ERROR, ResManager.loadKDString((String)"\u9a8c\u8bc1\u7801\u8d85\u65f6\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u65b0\u8f93\u5165\u3002", (String)"ResetPasswordAction_1", (String)BOS_LOGIN, (Object[])new Object[0]));
            String result = JSONUtils.toString(mpData);
            ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)result);
            return;
        }
        boolean isSame = vCodeCache.equalsIgnoreCase(vCode);
        if (!isSame) {
            CacheLoginData.setAttribute((String)ACTIVEPWD, (String)(account + token), (String)"verifyCodeFalse", (int)300);
            mpData.put(SUCCESS, false);
            mpData.put(LEVEL, 2);
            mpData.put(ERROR, ResManager.loadKDString((String)"\u8f93\u5165\u56fe\u5f62\u9a8c\u8bc1\u7801\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"ResetPasswordAction_2", (String)BOS_LOGIN, (Object[])new Object[0]));
            String result = JSONUtils.toString(mpData);
            ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)result);
            return;
        }
        CacheLoginData.setAttribute((String)ACTIVEPWD, (String)(account + token), (String)"true", (int)300);
        mpData.put(SUCCESS, true);
        String attribute = CacheLoginData.getAttribute((String)ACTIVEPWD, (String)account);
        if (attribute != null && attribute.trim().length() != 0) {
            mpData.put(SUCCESS, false);
            mpData.put(LEVEL, 2);
            mpData.put(ERROR, String.format(ResManager.loadKDString((String)"%s\u79d2\u5185\u4ec5\u80fd\u83b7\u53d6\u4e00\u6b21\u624b\u673a\u9a8c\u8bc1\u7801\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"ResetPasswordAction_79", (String)BOS_LOGIN, (Object[])new Object[0]), 60));
            String result = JSONUtils.toString(mpData);
            ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)result);
            return;
        }
        String tenantNo = RevProxyUtil.getTenantCode((HttpServletRequest)servletRequest);
        Account currentCenter = LoginAccountFactory.createInstanceByHttpRequest(servletRequest, Optional.empty()).getAccount();
        if (AdminUtils.getAdminList().contains(account)) {
            mpData.put(SUCCESS, false);
            mpData.put(ERROR, ResManager.loadKDString((String)"\u7ba1\u7406\u5458\u65e0\u9700\u6fc0\u6d3b\u3002", (String)"ResetPasswordAction_17", (String)BOS_LOGIN, (Object[])new Object[0]));
            String result = JSONUtils.toString(mpData);
            ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)result);
            return;
        }
        mpData = this.getActiveCode(currentCenter, account);
        AppLogParams logParams = LoginLogUtils.initParams(servletRequest, currentCenter, account, isEmail ? EMAIL : PHONE);
        logParams.setOpName(ResManager.loadKDString((String)"\u7528\u6237\u6fc0\u6d3b", (String)"ResetPasswordAction_90", (String)BOS_LOGIN, (Object[])new Object[0]));
        LoginLogUtils.addAppLog(logParams);
        this.hasChangedPwd(servletRequest, mpData, account, currentCenter.getTenantId());
        String result = JSONUtils.toString(mpData);
        ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)result);
    }

    private void hasChangedPwd(HttpServletRequest servletRequest, Map<String, Object> mpData, String account, String tenantId) {
        if ("active".equals(servletRequest.getParameter("page"))) {
            DynamicObject dynamicObject = this.getUserInfo(ValidationUtils.isPhone(account), account, "id,truename,password");
            if (dynamicObject == null || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)dynamicObject.getString("id"))) {
                mpData.put(SUCCESS, false);
                mpData.put(ERROR, ResManager.loadKDString((String)"\u9a8c\u8bc1\u7801\u53d1\u9001\u5931\u8d25\u3002", (String)"ResetPasswordAction_13", (String)BOS_LOGIN, (Object[])new Object[0]));
                return;
            }
            String userDefaultPsw = PswStrategyUtils.getUserDefaultPsw(tenantId);
            if (!this.checkDefaultPwd(dynamicObject, userDefaultPsw)) {
                mpData.put("hasChangedPwd", true);
            }
        }
    }

    private DynamicObject getUserInfo(boolean phone, String account, String selectProperties) {
        DynamicObject[] userList;
        if (phone && (userList = LoginUserService.getUserList(account, UserProperType.Mobile, selectProperties, false)) != null) {
            return userList[0];
        }
        userList = LoginUserService.getUserList(account, UserProperType.Email, selectProperties, false);
        if (userList != null) {
            return userList[0];
        }
        return null;
    }

    private boolean checkDefaultPwd(DynamicObject user, String defaultPsw) {
        boolean password = PasswordEncryptUtil.checkPasswordWithSalt((String)LoginUtils.getCorrectUserIDSalt(user.getString("id")), (String)defaultPsw, (String)user.getString("password"));
        return password;
    }

    private Map<String, Object> getActiveCode(Account currentCenter, String account) {
        HashMap<String, Object> obj = new HashMap<String, Object>(8);
        boolean success = false;
        StringBuilder url = new StringBuilder(ResetPasswordAction.getBaseUrl()).append("clouderp/account/vcode");
        int reSendTime = LoginMessageUtils.getMsgTimeout(currentCenter);
        String randomCode = UUID.randomUUID().toString();
        try {
            long t1 = System.currentTimeMillis();
            Map<String, String> paramMap = LoginUserService.getUserInfo(currentCenter, account);
            if (paramMap == null || paramMap.isEmpty()) {
                obj.put(SUCCESS, false);
                obj.put(ERROR, ResManager.loadKDString((String)"\u53d1\u9001\u9a8c\u8bc1\u7801\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ResetPasswordAction_93", (String)BOS_LOGIN, (Object[])new Object[0]));
                return obj;
            }
            String isactived = paramMap.get("isactived");
            if (VALUE_1.equals(isactived)) {
                obj.put(SUCCESS, false);
                obj.put(ERROR, ResManager.loadKDString((String)"\u7528\u6237\u5df2\u6fc0\u6d3b\u3002", (String)"ResetPasswordAction_58", (String)BOS_LOGIN, (Object[])new Object[0]));
                return obj;
            }
            List<Map<String, Object>> productList = LicenseService.getProductList(currentCenter);
            if (productList.isEmpty()) {
                obj.put(SUCCESS, false);
                obj.put(ERROR, ResManager.loadKDString((String)"\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u9519\u8bef\u3002", (String)"ResetPasswordAction_18", (String)BOS_LOGIN, (Object[])new Object[0]));
                return obj;
            }
            String uid = VALUE_0;
            String usertype = paramMap.get("usertype");
            String is_remove_network = null;
            is_remove_network = kd.bos.util.StringUtils.isEmpty((String)usertype) || usertype.equals(VALUE_1) || usertype.equals("7") ? VALUE_0 : VALUE_1;
            Map<String, Object> product = productList.get(0);
            StringBuilder s = new StringBuilder();
            Object clientId = product.get("clientId");
            Object clientSecret = product.get("clientSecret");
            Object prodInstId = product.get(PROD_INST_CODE);
            if (ObjectUtils.isEmpty((Object)clientId)) {
                clientId = ResetPasswordAction.getCloudClientId();
            }
            if (ObjectUtils.isEmpty((Object)clientSecret)) {
                clientSecret = ResetPasswordAction.getClientSecret();
            }
            s.append(clientId).append(clientSecret).append(uid).append(prodInstId).append(account).append(t1);
            String signiture = TransferUtil.sha1(s.toString());
            boolean isEmail = ValidationUtils.isEmail(account);
            String erp_account = paramMap.get("username");
            String name = paramMap.get("truename");
            if (kd.bos.util.StringUtils.isEmpty((String)name)) {
                name = account;
            }
            if (kd.bos.util.StringUtils.isEmpty((String)erp_account)) {
                erp_account = account;
            }
            if (isEmail) {
                url.append(CLIENT_ID2).append(clientId).append(UID_STR).append(uid).append("&erp_account=").append(URLEncoder.encode(erp_account, "utf-8")).append("&name=").append(URLEncoder.encode(name, "utf-8")).append(PROD_INST_CODE_STR).append(prodInstId).append(TIMESTAMP_STR).append(t1).append("&email=").append(account).append("&is_remove_network=").append(is_remove_network).append(SIGNITURE_STR).append(signiture);
            } else {
                url.append(CLIENT_ID2).append(clientId).append(UID_STR).append(uid).append("&erp_account=").append(URLEncoder.encode(erp_account, "utf-8")).append("&name=").append(URLEncoder.encode(name, "utf-8")).append(PROD_INST_CODE_STR).append(prodInstId).append(TIMESTAMP_STR).append(t1).append("&phone=").append(account).append("&is_remove_network=").append(is_remove_network).append(SIGNITURE_STR).append(signiture);
            }
            String returnValue = HttpClientUtils.get((String)url.toString());
            if (returnValue != null && returnValue.length() > 0) {
                Map map = (Map)JSONObject.parseObject((String)returnValue, Map.class);
                if (map.get(ERRCODE) != null && VALUE_0.equals(String.valueOf(map.get(ERRCODE)))) {
                    Map data;
                    success = true;
                    Map map2 = data = null != map.get("data") ? (Map)map.get("data") : null;
                    if (null != data) {
                        reSendTime = null != data.get("resend_in") ? Integer.parseInt(String.valueOf(data.get("resend_in"))) : reSendTime;
                        CacheLoginData.setAttribute((String)ACTIVEPWD, (String)account, (String)account, (int)reSendTime);
                        CacheLoginData.setAttribute((String)ACTIVEPWD, (String)(account + RANDOM_CODE), (String)randomCode, (int)300);
                    }
                } else if (map.get(ERRCODE) != null && "4006".equals(String.valueOf(map.get(ERRCODE)))) {
                    obj.put(ERROR, ResManager.loadKDString((String)"\u7cfb\u7edf\u672a\u6ce8\u518c\uff0c\u8bf7\u5148\u8054\u7cfb\u7ba1\u7406\u5458\u540c\u6b65\u8bb8\u53ef\u3002", (String)"ResetPasswordAction_80", (String)BOS_LOGIN, (Object[])new Object[0]));
                    obj.put("errorCode", map.get(ERRCODE));
                } else if (map.get(ERRCODE) != null && "1022".equals(String.valueOf(map.get(ERRCODE)))) {
                    obj.put(ERROR, ResManager.loadKDString((String)"\u7b7e\u540d\u4e0d\u4e00\u81f4\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u540c\u6b65\u8bb8\u53ef\u540e\u518d\u91cd\u65b0\u767b\u5f55\u3002", (String)"ResetPasswordAction_87", (String)BOS_LOGIN, (Object[])new Object[0]));
                    obj.put("errorCode", map.get(ERRCODE));
                } else {
                    obj.put(ERROR, map.get(DESCRIPTION_CN));
                    obj.put("errorCode", map.get(ERRCODE));
                }
            }
        }
        catch (Exception e) {
            logger.error("getActiveCode error == " + e);
        }
        obj.put(SUCCESS, success);
        obj.put(V_CODE_TIME, reSendTime * 1000);
        obj.put(RANDOM_CODE, randomCode);
        return obj;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, String> getUserInfo(Account currentAccount, String account) {
        ResultSet rs;
        PreparedStatement stmt;
        Connection conn;
        block9: {
            HashMap<String, String> map;
            block8: {
                conn = null;
                stmt = null;
                rs = null;
                Properties dataBaseProperties = AccountUtils.getTenantDBInfo((Account)currentAccount);
                conn = MCDBUtil.getConnection((Account)currentAccount, (Properties)dataBaseProperties);
                String licSql = "SELECT FPRODINSTCODE from t_lic_license";
                stmt = conn.prepareStatement(licSql);
                rs = stmt.executeQuery();
                map = new HashMap<String, String>();
                boolean hasProdCode = false;
                if (rs.next()) {
                    map.put(PROD_INST_CODE, rs.getString(1));
                    hasProdCode = true;
                }
                SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
                if (hasProdCode) break block8;
                Map<String, String> map2 = null;
                SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
                return map2;
            }
            boolean isEmail = ValidationUtils.isEmail(account);
            String sql = isEmail ? "SELECT t.femail,t.fuid,u.fusername,t.ftruename,t.fusertype,t.fid,u.fisactived from t_sec_user t left join t_sec_user_u u on t.fid = u.fid where t.femail = ? and t.fnumber not in('administrator','cosmic','security','auditor') and t.fenable = '1' and u.fisforbidden = '0' " : "SELECT t.fphone,t.fuid,u.fusername,t.ftruename,t.fusertype,t.fid,u.fisactived from t_sec_user t left join t_sec_user_u u on t.fid = u.fid where t.fphone = ? and t.fnumber not in('administrator','cosmic','security','auditor') and t.fenable = '1' and u.fisforbidden = '0' ";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, account);
            rs = stmt.executeQuery();
            if (!rs.next()) break block9;
            map.put(PHONE, rs.getString(1));
            map.put("uid", rs.getString(2));
            map.put("username", rs.getString(3));
            map.put("truename", rs.getString(4));
            map.put("usertype", rs.getString(5));
            map.put("fid", rs.getString(6));
            map.put("isactived", rs.getString(7));
            HashMap<String, String> hashMap = map;
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
            return hashMap;
        }
        try {
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        }
        catch (SQLException e) {
            try {
                throw new KDException((Throwable)e, BosErrorCode.sQLConnection, new Object[]{ErrorCodeUtils.getDBIntralError() + LoginUtils.SPLIT_SIGN + e.getMessage()});
                catch (Exception e2) {
                    throw new KDException((Throwable)e2, BosErrorCode.sQLConnection, new Object[]{ErrorCodeUtils.getDBIntralError() + LoginUtils.SPLIT_SIGN + e2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return null;
    }

    public void resetPassword(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException {
        this.resetPassword(servletRequest, servletResponse, "");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void resetPassword(HttpServletRequest servletRequest, HttpServletResponse servletResponse, String randomCode) throws IOException {
        String accountIdParameter;
        Account currentCenter;
        String userKey;
        String userID;
        String phone;
        String password;
        String type;
        HashMap<String, Object> mpData;
        Lang lang;
        block26: {
            String passwordWarning;
            lang = LoginLangUtils.getLoginLanguage(servletRequest);
            LoginLangUtils.setLang(lang);
            try {
                LoginUtils.forcePOSTSubmitCheck(servletRequest);
            }
            catch (KDException ex) {
                logger.error("resetPassword\u5f02\u5e38", (Throwable)ex);
                ErrorCode code = ex.getErrorCode();
                String resp = LoginUtils.getLoginResponse(String.valueOf(code.getCode()), ex.getMessage());
                ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)resp);
                return;
            }
            mpData = new HashMap<String, Object>(8);
            type = servletRequest.getParameter("type");
            password = servletRequest.getParameter("password");
            phone = servletRequest.getParameter(PHONE);
            String accessKey = servletRequest.getParameter("accessKey");
            userID = "";
            userKey = "";
            LoginAccount loginAccount = LoginAccountFactory.createInstanceByHttpRequest(servletRequest, Optional.empty());
            currentCenter = loginAccount.getAccount();
            accountIdParameter = loginAccount.getAccountId();
            if (StringUtils.isEmpty((String)randomCode)) {
                randomCode = servletRequest.getParameter(RANDOM_CODE);
            }
            if (kd.bos.login.utils.StringUtils.isNotEmpty(passwordWarning = servletRequest.getParameter(PASSWORD_WARNING)) && Boolean.parseBoolean(passwordWarning)) {
                type = PASSWORD_WARNING;
                String passwordWarningCache = CacheLoginData.getAttribute((String)PASSWORD_WARNING, (String)(currentCenter.getAccountId() + "-" + phone + "-verifyCode"));
                if (kd.bos.login.utils.StringUtils.isNotEmpty(passwordWarningCache) && passwordWarningCache.split(",").length > 0) {
                    userID = passwordWarningCache.split(",")[0];
                    String randomCodeCache = passwordWarningCache.split(",")[1];
                    if (!randomCode.equals(randomCodeCache)) {
                        throw new KDException(LoginErrorCode.loginBizException, new Object[]{String.format(ResManager.loadKDString((String)"\u7981\u6b62\u6b64\u64cd\u4f5c\u767b\u5f55\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55\u3002", (String)"LoginAction_24", (String)BOS_LOGIN, (Object[])new Object[0]), new Object[0])});
                    }
                    password = LoginUtils.getDecryptedPassword(password, phone, accessKey, currentCenter.getAccountId());
                    break block26;
                } else {
                    mpData.put(SUCCESS, false);
                    mpData.put("overtime", true);
                    mpData.put(MSG, ResManager.loadKDString((String)"\u91cd\u7f6e\u5bc6\u7801\u8d85\u65f6\uff0c\u8bf7\u91cd\u65b0\u64cd\u4f5c\u3002", (String)"ResetPasswordAction_78", (String)BOS_LOGIN, (Object[])new Object[0]));
                    String result = JSONUtils.toString(mpData);
                    ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)result);
                    return;
                }
            }
            if (EMAIL.equals(type)) {
                userKey = servletRequest.getParameter("userKey");
                userID = CacheLoginData.getAttribute((String)RESETPWD, (String)(FIND_PSW_BY_EMAIL_KEY + userKey));
                if (StringUtils.isBlank((String)userID)) {
                    mpData.put(SUCCESS, false);
                    mpData.put(MSG, ResManager.loadKDString((String)"\u94fe\u63a5\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6\u94fe\u63a5\u3002", (String)"ResetPasswordAction_19", (String)BOS_LOGIN, (Object[])new Object[0]));
                    String result = JSONUtils.toString(mpData);
                    ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)result);
                    return;
                }
                if (StringUtils.isEmpty((String)accountIdParameter)) {
                    accountIdParameter = CacheLoginData.getAttribute((String)RESETPWD, (String)(FIND_PSW_BY_EMAIL_KEY + userID));
                }
                password = LoginUtils.getDecryptedPassword(password, userKey, accessKey, currentCenter.getAccountId());
            } else {
                password = LoginUtils.getDecryptedPassword(password, phone, accessKey, currentCenter.getAccountId());
                String phonePwdCache = CacheLoginData.getAttribute((String)RESETPWD, (String)(phone + NUMBER));
                String phoneVCode = CacheLoginData.getAttribute((String)RESETPWD, (String)(phone + P_CODE));
                String randomCodeCache = CacheLoginData.getAttribute((String)RESETPWD, (String)(phone + RANDOM_CODE));
                if (kd.bos.util.StringUtils.isNotEmpty((String)randomCodeCache) && !randomCode.equals(randomCodeCache)) {
                    throw new KDException(LoginErrorCode.loginBizException, new Object[]{String.format(ResManager.loadKDString((String)"\u975e\u6cd5\u64cd\u4f5c\uff01", (String)"ApiInterfaceAction_4", (String)BOS_LOGIN, (Object[])new Object[0]), new Object[0])});
                }
                if (phonePwdCache == null || phonePwdCache.trim().length() == 0) {
                    mpData.put(SUCCESS, false);
                    mpData.put("overtime", true);
                    mpData.put(MSG, ResManager.loadKDString((String)"\u91cd\u7f6e\u5bc6\u7801\u8d85\u65f6\uff0c\u8bf7\u91cd\u65b0\u64cd\u4f5c\u3002", (String)"ResetPasswordAction_78", (String)BOS_LOGIN, (Object[])new Object[0]));
                    String result = JSONUtils.toString(mpData);
                    ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)result);
                    return;
                }
            }
        }
        if (password == null || password.trim().length() == 0) {
            mpData.put(SUCCESS, false);
            mpData.put(MSG, ResManager.loadKDString((String)"\u65b0\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ResetPasswordAction_21", (String)BOS_LOGIN, (Object[])new Object[0]));
            String result = JSONUtils.toString(mpData);
            ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)result);
            return;
        }
        Map<String, Object> verifyPwdResult = PswStrategyService.customVerifyPassword(password);
        if (verifyPwdResult != null && verifyPwdResult.get(SUCCESS) != null && !((Boolean)verifyPwdResult.get(SUCCESS)).booleanValue()) {
            mpData.put(SUCCESS, false);
            mpData.put(MSG, verifyPwdResult.get(MSG));
            String result = JSONUtils.toString(mpData);
            ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)result);
            return;
        }
        Account currentAccount = LoginAccountFactory.createInstanceByCustom(accountIdParameter, servletRequest).getAccount();
        LoginUtils.createGuestRequestContext(servletRequest, currentAccount);
        String fid = "";
        String uid = "";
        String fpswhisstr = "";
        String fusername = "";
        String fphone = "";
        String femail = "";
        DynamicObject[] userArray = null;
        userArray = EMAIL.equals(type) || PASSWORD_WARNING.equals(type) ? LoginUserService.getUserList(userID, UserProperType.UserId, true) : (AdminUtils.getAdminList().contains(phone) ? LoginUserService.getUserList(phone, UserProperType.UserName, false) : LoginUserService.getUserList(phone, UserProperType.Mobile, false));
        if (userArray != null && userArray.length > 0) {
            DynamicObject user = userArray[0];
            uid = user.getString("id");
            fid = user.getString("id");
            fpswhisstr = user.getString("pswhisstr");
            fusername = user.getString("username");
            fphone = user.getString(PHONE);
            femail = user.getString(EMAIL);
        }
        String encrypt = PasswordEncryptUtil.getEncryptePasswordWithSalt((String)password, (String)LoginUtils.getCorrectUserIDSalt(fid));
        if (StringUtils.isNotBlank((String)fusername) && password.indexOf(fusername) != -1) {
            mpData.put(SUCCESS, false);
            mpData.put(MSG, ResManager.loadKDString((String)"\u5bc6\u7801\u4e0d\u80fd\u5305\u542b\u7528\u6237\u540d\u3002", (String)"ResetPasswordAction_53", (String)BOS_LOGIN, (Object[])new Object[0]));
            String result = JSONUtils.toString(mpData);
            ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)result);
            return;
        }
        if (StringUtils.isNotBlank((String)fphone) && password.indexOf(fphone) != -1) {
            mpData.put(SUCCESS, false);
            mpData.put(MSG, ResManager.loadKDString((String)"\u5bc6\u7801\u4e0d\u80fd\u5305\u542b\u624b\u673a\u53f7\u3002", (String)"ResetPasswordAction_51", (String)BOS_LOGIN, (Object[])new Object[0]));
            String result = JSONUtils.toString(mpData);
            ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)result);
            return;
        }
        if (StringUtils.isNotBlank((String)femail) && password.indexOf(femail) != -1) {
            mpData.put(SUCCESS, false);
            mpData.put(MSG, ResManager.loadKDString((String)"\u5bc6\u7801\u4e0d\u80fd\u5305\u542b\u90ae\u7bb1\u3002", (String)"ResetPasswordAction_52", (String)BOS_LOGIN, (Object[])new Object[0]));
            String result = JSONUtils.toString(mpData);
            ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)result);
            return;
        }
        if (this.checkPsw(password)) {
            mpData.put(SUCCESS, false);
            mpData.put(MSG, ResManager.loadKDString((String)"\u5bc6\u7801\u4e0d\u80fd\u542b\u6709\u7a7a\u683c\u3001\u4e2d\u6587\u3001\u975e\u6cd5\u7b26\u53f7\u3002", (String)"ResetPasswordAction_60", (String)BOS_LOGIN, (Object[])new Object[0]));
            String result = JSONUtils.toString(mpData);
            ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)result);
            return;
        }
        verifyPwdResult = PswStrategyService.verifyPwdByStrategy(currentAccount, Long.parseLong(fid), password, fpswhisstr);
        if (verifyPwdResult != null && verifyPwdResult.get(SUCCESS) != null && !((Boolean)verifyPwdResult.get(SUCCESS)).booleanValue()) {
            mpData.put(SUCCESS, false);
            mpData.put(MSG, verifyPwdResult.get(MSG));
            String result = JSONUtils.toString(mpData);
            ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)result);
            return;
        }
        if (StringUtils.isEmpty((String)fpswhisstr) || " ".equals(fpswhisstr)) {
            fpswhisstr = encrypt;
        } else {
            CharSequence[] pswHisStrs = fpswhisstr.split(",");
            if (pswHisStrs.length < 10) {
                fpswhisstr = fpswhisstr + "," + encrypt;
            } else {
                pswHisStrs[0] = "";
                fpswhisstr = String.join((CharSequence)",", pswHisStrs).substring(1);
                fpswhisstr = fpswhisstr + "," + encrypt;
            }
        }
        LoginUserDTO loginUserDTO = new LoginUserDTO();
        loginUserDTO.setPassword(encrypt);
        loginUserDTO.setPasswordHis(fpswhisstr);
        loginUserDTO.setUserId(Long.valueOf(Long.parseLong(fid)));
        if (!new ActiveUserService("false").resetUserPassword(loginUserDTO)) {
            mpData.put(SUCCESS, false);
            mpData.put(MSG, ResManager.loadKDString((String)"\u91cd\u7f6e\u5bc6\u7801\u5931\u8d25!", (String)"ResetPasswordAction_25", (String)BOS_LOGIN, (Object[])new Object[0]));
            String result = JSONUtils.toString(mpData);
            ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)result);
            return;
        }
        Map<String, String> userInfo = LoginUserService.getErpUserInfoByUserId(currentAccount, fid, lang.toString());
        SessionParams params = new SessionParams();
        params.setClientEnum(AgentUtil.isMobile(servletRequest) ? LoginClientEnum.MOBILE : LoginClientEnum.WEB);
        params.setIP(NetAddressUtils.getRemoteHost((HttpServletRequest)servletRequest));
        LoginLogUtils.addLog(currentCenter, LoginLogUtils.initLoginLogInfo(fid, userInfo.get("forgid"), params, "ResetPassword"));
        LoginUtils.clearSmsSendTimes(currentCenter.getAccountId(), fphone);
        this.removePasswordCache(fusername, fphone, femail);
        this.clearCache(currentCenter, phone, userKey, fid);
        mpData.put(SUCCESS, true);
        String result = JSONUtils.toString(mpData);
        ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)result);
    }

    public void verifyPhoneCodeAndResetPwd(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException {
        Map<String, Object> mpData = this.verifyPhoneCode(servletRequest);
        Object isSuccess = mpData.get(SUCCESS);
        if (isSuccess != null && Boolean.parseBoolean(isSuccess.toString())) {
            String randomCode = "";
            Object value = mpData.get(RANDOM_CODE);
            if (value != null) {
                randomCode = value.toString();
            }
            this.resetPassword(servletRequest, servletResponse, randomCode);
        } else {
            String result = JSONUtils.toString(mpData);
            ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)result);
        }
    }

    private boolean checkPsw(String password) {
        String pattern = "\\s{1,}";
        String[] split = password.split(pattern);
        return StringUtils.isBlank((String)password) || split.length > 1 || !password.equals(password.trim()) || this.isContainChineseChar(password);
    }

    private boolean isContainChineseChar(String value) {
        String pattern = "[^\\x00-\\xff]{1,}";
        Pattern p = Pattern.compile(pattern);
        Matcher m = p.matcher(value);
        return m.find();
    }

    private void clearCache(Account currentCenter, String phone, String userKey, String fid) {
        StrategeUtils.clearPasswordWrongTimes(currentCenter, fid, LoginClientEnum.WEB.toString());
        CacheLoginData.remove((String)RESETPWD, (String)(phone + P_CODE));
        CacheLoginData.remove((String)RESETPWD, (String)phone);
        CacheLoginData.remove((String)RESETPWD, (String)(FIND_PSW_BY_EMAIL_KEY + userKey));
        CacheLoginData.remove((String)PASSWORD_WARNING, (String)(currentCenter.getAccountId() + "-" + phone + "-verifyCode"));
    }

    private void removePasswordCache(String fusername, String fphone, String femail) {
        String loginPassword = "s_login_password";
        LocalCacheUtils.remove(fusername + loginPassword);
        LocalCacheUtils.remove(fphone + loginPassword);
        LocalCacheUtils.remove(femail + loginPassword);
        LocalCacheUtils.remove("administrator" + loginPassword);
    }

    public void activeUser(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException {
        boolean isGlobalDeploy;
        boolean isEmail;
        Lang lang = LoginLangUtils.getLoginLanguage(servletRequest);
        LoginLangUtils.setLang(lang);
        try {
            LoginUtils.forcePOSTSubmitCheck(servletRequest);
        }
        catch (KDException ex) {
            logger.error("activeUser\u5f02\u5e38", (Throwable)ex);
            ErrorCode code = ex.getErrorCode();
            String resp = LoginUtils.getLoginResponse(String.valueOf(code.getCode()), ex.getMessage());
            ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)resp);
            return;
        }
        Map<Object, Object> mpData = new HashMap<String, Object>(8);
        String account = servletRequest.getParameter(PHONE);
        if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)account)) {
            account = servletRequest.getParameter(E_MAIL);
        }
        if (!(isEmail = ValidationUtils.isEmail(account)) && (isGlobalDeploy = GlobalDeployUtils.isGlobalDeploy((String)RevProxyUtil.getTenantId((HttpServletRequest)servletRequest)))) {
            mpData.put(SUCCESS, false);
            mpData.put(ERROR, ResManager.loadKDString((String)"\u90ae\u7bb1\u683c\u5f0f\u9519\u8bef\u3002", (String)"ResetPasswordAction_94", (String)BOS_LOGIN, (Object[])new Object[0]));
            String result = JSONUtils.toString(mpData);
            ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)result);
            return;
        }
        LoginAccount loginAccount = LoginAccountFactory.createInstanceByHttpRequest(servletRequest, Optional.empty());
        Account currentCenter = loginAccount.getAccount();
        String vCode = servletRequest.getParameter(V_CODE);
        String token = servletRequest.getParameter("token");
        String verifyCode = CacheLoginData.getAttribute((String)ACTIVEPWD, (String)(account + token));
        String vCodeCache = CacheLoginData.getAttribute((String)RESETPWD, (String)(account + token));
        if (kd.bos.login.utils.StringUtils.isEmpty(verifyCode) && kd.bos.login.utils.StringUtils.isNotEmpty(vCode) && kd.bos.util.StringUtils.isNotEmpty((String)vCodeCache) && !vCodeCache.equalsIgnoreCase(vCode)) {
            mpData.put(SUCCESS, false);
            mpData.put(LEVEL, 2);
            mpData.put(ERROR, ResManager.loadKDString((String)"\u8f93\u5165\u56fe\u5f62\u9a8c\u8bc1\u7801\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"ResetPasswordAction_2", (String)BOS_LOGIN, (Object[])new Object[0]));
            String result = JSONUtils.toString(mpData);
            ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)result);
            return;
        }
        if (AdminUtils.getAdminList().contains(account)) {
            mpData.put(SUCCESS, false);
            mpData.put(ERROR, ResManager.loadKDString((String)"\u7ba1\u7406\u5458\u65e0\u9700\u6fc0\u6d3b\u3002", (String)"ResetPasswordAction_17", (String)BOS_LOGIN, (Object[])new Object[0]));
            String result = JSONUtils.toString(mpData);
            ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)result);
            return;
        }
        String randomCode = servletRequest.getParameter(RANDOM_CODE);
        String randomCodeCache = CacheLoginData.getAttribute((String)ACTIVEPWD, (String)(account + RANDOM_CODE));
        if (kd.bos.util.StringUtils.isEmpty((String)randomCodeCache) || kd.bos.util.StringUtils.isEmpty((String)randomCode)) {
            mpData.put(SUCCESS, false);
            mpData.put(ERROR, ResManager.loadKDString((String)"\u77ed\u4fe1/\u90ae\u7bb1\u9a8c\u8bc1\u7801\u8f93\u5165\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"ResetPasswordAction_88", (String)BOS_LOGIN, (Object[])new Object[0]));
            String result = JSONUtils.toString(mpData);
            ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)result);
            return;
        }
        if (!randomCode.equals(randomCodeCache)) {
            mpData.put(SUCCESS, false);
            mpData.put(ERROR, ResManager.loadKDString((String)"\u77ed\u4fe1/\u90ae\u7bb1\u9a8c\u8bc1\u7801\u8f93\u5165\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"ResetPasswordAction_88", (String)BOS_LOGIN, (Object[])new Object[0]));
            String result = JSONUtils.toString(mpData);
            ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)result);
            return;
        }
        String code = servletRequest.getParameter("code");
        ActiveUserService hasChangedPwdService = new ActiveUserService(servletRequest, account, currentCenter);
        mpData = hasChangedPwdService.customVerifyPassword();
        if (null != mpData.get(SUCCESS) && !((Boolean)mpData.get(SUCCESS)).booleanValue()) {
            String result = JSONUtils.toString(mpData);
            ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)result);
            return;
        }
        Map<String, String> paramMap = LoginUserService.getUserInfo(currentCenter, account);
        if (paramMap == null || paramMap.isEmpty() || ObjectUtils.isEmpty((Object)paramMap.get("fid"))) {
            mpData.put(SUCCESS, false);
            mpData.put(MSG, ResManager.loadKDString((String)"\u8be5\u7528\u6237\u672a\u6ce8\u518c\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ResetPasswordAction_9", (String)BOS_LOGIN, (Object[])new Object[0]));
            String result = JSONUtils.toString(mpData);
            ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)result);
            return;
        }
        Map<String, Object> verifyPwdResult = hasChangedPwdService.verifyPwdByStrategy(paramMap, currentCenter);
        if (verifyPwdResult != null && verifyPwdResult.get(SUCCESS) != null && !((Boolean)verifyPwdResult.get(SUCCESS)).booleanValue()) {
            mpData.put(SUCCESS, false);
            mpData.put(MSG, verifyPwdResult.get(MSG));
            String result = JSONUtils.toString(mpData);
            ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)result);
            return;
        }
        Boolean success = false;
        String responseData = "";
        LoginUserDTO loginUserDTO = new LoginUserDTO();
        loginUserDTO.setUserId(Long.valueOf(Long.parseLong(paramMap.get("fid"))));
        ParametersUtils.removeUserInfoBykey(currentCenter, account);
        Map<String, Object> result = this.verifyCloudCode(currentCenter, account, code);
        if (null != result && result.size() > 0) {
            if (result.get(ERRCODE) != null && VALUE_0.equals(String.valueOf(result.get(ERRCODE)))) {
                Map data = null != result.get("data") ? (Map)result.get("data") : null;
                String uid = "";
                uid = null != data ? (null != data.get("uid") ? data.get("uid").toString() : VALUE_0) : VALUE_0;
                loginUserDTO.setUid(Long.valueOf(Long.parseLong(uid)));
                success = this.activeUser(currentCenter, loginUserDTO);
            } else if (result.get(ERRCODE) != null && "4006".equals(String.valueOf(result.get(ERRCODE)))) {
                mpData.put(MSG, ResManager.loadKDString((String)"\u7cfb\u7edf\u672a\u6ce8\u518c\uff0c\u8bf7\u5148\u8054\u7cfb\u7ba1\u7406\u5458\u540c\u6b65\u8bb8\u53ef\u3002", (String)"ResetPasswordAction_80", (String)BOS_LOGIN, (Object[])new Object[0]));
                mpData.put(SUCCESS, false);
            } else {
                mpData.put(SUCCESS, false);
                logger.info(String.valueOf(result.get(DESCRIPTION_CN)));
                mpData.put(MSG, ResManager.loadKDString((String)"\u77ed\u4fe1/\u90ae\u7bb1\u9a8c\u8bc1\u7801\u4e0d\u5b58\u5728\u6216\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6\u3002", (String)"ResetPasswordAction_110", (String)BOS_LOGIN, (Object[])new Object[0]));
                responseData = JSONUtils.toString(mpData);
                ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)responseData);
                return;
            }
        }
        if (success.booleanValue()) {
            if (hasChangedPwdService.resetPassWord(paramMap, loginUserDTO)) {
                mpData.put(SUCCESS, true);
            } else {
                mpData.put(SUCCESS, false);
                mpData.put(MSG, ResManager.loadKDString((String)"\u6fc0\u6d3b\u6210\u529f\uff0c\u5bc6\u7801\u91cd\u7f6e\u5931\u8d25\u3002", (String)"ResetPasswordAction_28", (String)BOS_LOGIN, (Object[])new Object[0]));
            }
            PrivacyPolicyService.signPrivacyPolicy(servletRequest, paramMap.get("fid"));
            StringBuilder keyStr = new StringBuilder("prodInstId").append(account).append(currentCenter.getAccountId());
            CacheLoginData.remove((String)ACTIVEPWD, (String)keyStr.toString());
        } else {
            mpData.put(SUCCESS, false);
            mpData.put(MSG, ResManager.loadKDString((String)"\u7528\u6237\u6fc0\u6d3b\u5931\u8d25\u3002", (String)"ResetPasswordAction_29", (String)BOS_LOGIN, (Object[])new Object[0]));
        }
        responseData = JSONUtils.toString(mpData);
        ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)responseData);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean resetPsw(Account currentAccount, String account, String password) {
        boolean bl;
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            Properties dataBaseProperties = AccountUtils.getTenantDBInfo((Account)currentAccount);
            if (dataBaseProperties == null) {
                throw new KDException(BosErrorCode.configNotFound, new Object[]{ErrorCodeUtils.getDBGetError()});
            }
            conn = MCDBUtil.getConnection((Account)currentAccount, (Properties)dataBaseProperties);
            String sql = ValidationUtils.isEmail(account) ? "UPDATE t_sec_user_u SET FISACTIVED = '1' , FPASSWORD = ? where fid = (SELECT fid from t_sec_user where FENABLE = '1' and FEMAIL = ? AND FUSERTYPE IN ('1','2','3','4','5'))" : "UPDATE t_sec_user_u SET FISACTIVED = '1' , FPASSWORD = ? where fid = (SELECT fid from t_sec_user where FENABLE = '1' and FPHONE = ? AND FUSERTYPE IN ('1','2','3','4','5'))";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, password);
            stmt.setString(2, account);
            int update = stmt.executeUpdate();
            bl = update > 0;
        }
        catch (SQLException e) {
            try {
                throw new KDException((Throwable)e, BosErrorCode.sQLConnection, new Object[]{ErrorCodeUtils.getDBIntralError() + LoginUtils.SPLIT_SIGN + e.getMessage()});
                catch (Exception e2) {
                    throw new KDException((Throwable)e2, BosErrorCode.sQLConnection, new Object[]{ErrorCodeUtils.getDBIntralError() + LoginUtils.SPLIT_SIGN + e2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
        return bl;
    }

    private Map<String, Object> verifyCloudCode(Account currentCenter, String account, String vcode) {
        Map<String, Object> result = new HashMap<String, Object>();
        StringBuilder url = new StringBuilder(ResetPasswordAction.getBaseUrl()).append("clouderp/account/vcode/verifying");
        try {
            long t1 = System.currentTimeMillis();
            Map<String, String> paramMap = LoginUserService.getUserInfo(currentCenter, account);
            if (paramMap == null) {
                result.put(SUCCESS, false);
                result.put(ERROR, ResManager.loadKDString((String)"\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ResetPasswordAction_3", (String)BOS_LOGIN, (Object[])new Object[0]));
                return result;
            }
            String uid = VALUE_0;
            List<Map<String, Object>> productList = LicenseService.getProductList(currentCenter);
            Map<String, Object> product = productList.get(0);
            Object clientId = product.get("clientId");
            Object clientSecret = product.get("clientSecret");
            Object prodInstId = product.get(PROD_INST_CODE);
            if (ObjectUtils.isEmpty((Object)clientId)) {
                clientId = ResetPasswordAction.getCloudClientId();
            }
            if (ObjectUtils.isEmpty((Object)clientSecret)) {
                clientSecret = ResetPasswordAction.getClientSecret();
            }
            String phone2 = paramMap.get(PHONE);
            StringBuilder s = new StringBuilder();
            s.append(clientId).append(clientSecret).append(uid).append(prodInstId).append(phone2).append(vcode).append(t1);
            String signiture = TransferUtil.sha1(s.toString());
            boolean isEmail = ValidationUtils.isEmail(phone2);
            if (isEmail) {
                url.append(CLIENT_ID2).append(ResetPasswordAction.getCloudClientId()).append(UID_STR).append(uid).append(PROD_INST_CODE_STR).append(prodInstId).append("&vcode=").append(vcode).append(TIMESTAMP_STR).append(t1).append("&email=").append(phone2).append(SIGNITURE_STR).append(signiture);
            } else {
                url.append(CLIENT_ID2).append(ResetPasswordAction.getCloudClientId()).append(UID_STR).append(uid).append(PROD_INST_CODE_STR).append(prodInstId).append("&vcode=").append(vcode).append(TIMESTAMP_STR).append(t1).append("&phone=").append(phone2).append(SIGNITURE_STR).append(signiture);
            }
            String returnValue = HttpClientUtils.get((String)url.toString());
            logger.info("verifyCloudCode : returnValue = " + returnValue);
            if (returnValue != null && returnValue.length() > 0) {
                result = (Map)JSONObject.parseObject((String)returnValue, Map.class);
            }
        }
        catch (Exception e) {
            logger.error("verifyCode error == " + e);
        }
        return result;
    }

    private String modifyPhoneCode(String msg) {
        char[] chars = msg.toCharArray();
        for (int i = 0; i < msg.length() - 1; ++i) {
            if (chars[i] != chars[i + 1]) continue;
            int n = i + 1;
            chars[n] = (char)(chars[n] + '\u0001');
            if (chars[i + 1] != ':') continue;
            chars[i + 1] = 48;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(chars);
        msg = sb.toString();
        return msg;
    }

    public void getCodeFromCloudPlatform(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException {
        Map<Object, Object> mpData = new HashMap();
        String phone = servletRequest.getParameter(PHONE);
        String tenantNo = RevProxyUtil.getTenantCode((HttpServletRequest)servletRequest);
        Account currentCenter = LoginAccountFactory.createInstanceByHttpRequest(servletRequest, Optional.empty()).getAccount();
        mpData = this.getActiveCode(currentCenter, phone);
        String result = JSONUtils.toString(mpData);
        ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)result);
    }

    public void verifyCode2CloudPlatform(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException {
        Lang lang = LoginLangUtils.getLoginLanguage(servletRequest);
        LoginLangUtils.setLang(lang);
        try {
            LoginUtils.forcePOSTSubmitCheck(servletRequest);
        }
        catch (KDException ex) {
            logger.error((Throwable)ex);
            ErrorCode code = ex.getErrorCode();
            String resp = LoginUtils.getLoginResponse(String.valueOf(code.getCode()), ex.getMessage());
            ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)resp);
            return;
        }
        HashMap<String, Object> mpData = new HashMap<String, Object>();
        String phone = servletRequest.getParameter(PHONE);
        String code = servletRequest.getParameter("code");
        LoginAccount loginAccount = LoginAccountFactory.createInstanceByHttpRequest(servletRequest, Optional.empty());
        Account currentCenter = loginAccount.getAccount();
        Boolean success = false;
        String responseData = "";
        Map<String, Object> result = this.verifyCloudCode(currentCenter, phone, code);
        if (null != result && result.size() > 0 && result.get(ERRCODE) != null) {
            if (VALUE_0.equals(String.valueOf(result.get(ERRCODE)))) {
                success = true;
            } else {
                logger.info("verifyCloudCode : errcode = " + result.get(ERRCODE));
                mpData.put(SUCCESS, false);
                mpData.put(MSG, result.get(DESCRIPTION_CN));
                responseData = JSONUtils.toString(mpData);
                ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)responseData);
                return;
            }
        }
        if (success.booleanValue()) {
            boolean isChanged = this.activeUser(currentCenter, phone);
            if (isChanged) {
                mpData.put(SUCCESS, true);
            } else {
                mpData.put(SUCCESS, false);
                mpData.put(MSG, ResManager.loadKDString((String)"\u7528\u6237\u4fe1\u606f\u4fee\u6539\u5931\u8d25\u3002", (String)"ResetPasswordAction_38", (String)BOS_LOGIN, (Object[])new Object[0]));
            }
            responseData = JSONUtils.toString(mpData);
            ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)responseData);
            return;
        }
        mpData.put(SUCCESS, false);
        mpData.put(MSG, ResManager.loadKDString((String)"\u7528\u6237\u6fc0\u6d3b\u5931\u8d25\u3002", (String)"ResetPasswordAction_29", (String)BOS_LOGIN, (Object[])new Object[0]));
        responseData = JSONUtils.toString(mpData);
        ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)responseData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - bad return control flow
     */
    private boolean activeUser(Account currentAccount, String phone) {
        boolean bl;
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            Properties dataBaseProperties = AccountUtils.getTenantDBInfo((Account)currentAccount);
            if (dataBaseProperties == null) {
                throw new KDException(BosErrorCode.configNotFound, new Object[]{ErrorCodeUtils.getDBGetError()});
            }
            conn = MCDBUtil.getConnection((Account)currentAccount, (Properties)dataBaseProperties);
            String sql = "UPDATE t_sec_user_u SET FISACTIVED = '1' where fid = (SELECT fid from t_sec_user where FENABLE = '1' and FPHONE = ? )";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, phone);
            int update = stmt.executeUpdate();
            bl = update > 0;
        }
        catch (SQLException e) {
            logger.error((Throwable)e);
            SQLUtils.cleanup(stmt, (Connection)conn);
        }
        catch (Exception e2) {
            logger.error((Throwable)e2);
            {
                catch (Throwable throwable) {
                    SQLUtils.cleanup(stmt, conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup(stmt, (Connection)conn);
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
        return bl;
        return false;
    }

    public void validateLicDate(HttpServletRequest request, HttpServletResponse response) throws IOException {
        HashMap<String, Object> mpData = new HashMap<String, Object>(8);
        mpData.put(OVER_TIME, false);
        if (LoginUtils.isMCSystem()) {
            String result = JSONUtils.toString(mpData);
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)result);
            return;
        }
        LicenseServiceImpl licenseService = new LicenseServiceImpl();
        List list = licenseService.getLicenseExpireNotice();
        mpData.put("licenseList", list);
        String result = JSONUtils.toString(mpData);
        ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)result);
    }

    public static int differentDays(Date date1, Date date2) {
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(date1);
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(date2);
        int day1 = cal1.get(6);
        int day2 = cal2.get(6);
        int year1 = cal1.get(1);
        int year2 = cal2.get(1);
        if (year1 != year2) {
            int timeDistance = 0;
            for (int i = year1; i < year2; ++i) {
                if (i % 4 == 0 && i % 100 != 0 || i % 400 == 0) {
                    timeDistance += 366;
                    continue;
                }
                timeDistance += 365;
            }
            return timeDistance + (day2 - day1);
        }
        return day2 - day1;
    }

    protected Date getPreDate(Date holdDate) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(holdDate);
        ((Calendar)calendar).add(5, -30);
        Date utilDate = calendar.getTime();
        return new Date(utilDate.getTime());
    }

    private Map<String, Object> sendEmail(HttpServletRequest servletRequest, Account currentCenter, String email) {
        HashMap<String, Object> mpData = new HashMap<String, Object>(4);
        mpData.put(SUCCESS, false);
        mpData.put(MSG, ResManager.loadKDString((String)"\u90ae\u4ef6\u53d1\u9001\u5931\u8d25\u3002", (String)"ResetPasswordAction_44", (String)BOS_LOGIN, (Object[])new Object[0]));
        try {
            HashMap<String, Object> values = new HashMap<String, Object>();
            Object[] userArray = LoginUserService.getUserList(email, UserProperType.Email, false);
            String userId = "";
            if (ObjectUtils.isEmpty((Object[])userArray)) {
                boolean isEnable = LoginUserService.checkUserEnable(currentCenter, email);
                if (isEnable) {
                    mpData.put(MSG, ResManager.loadKDString((String)"\u7528\u6237\u5df2\u88ab\u7981\u7528\u3002", (String)"ResetPasswordAction_59", (String)BOS_LOGIN, (Object[])new Object[0]));
                    return mpData;
                }
                mpData.put(SUCCESS, true);
                mpData.put("user", VALUE_0);
                return mpData;
            }
            Object user = userArray[0];
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)((String)user.get(EMAIL)))) {
                mpData.put(MSG, ResManager.loadKDString((String)"\u8d26\u53f7\u672a\u7ed1\u5b9a\u90ae\u7bb1\u3002", (String)"ResetPasswordAction_91", (String)BOS_LOGIN, (Object[])new Object[0]));
                return mpData;
            }
            userId = String.valueOf(user.get("id"));
            values.put("id", user.get("id"));
            values.put("name", user.get("name"));
            values.put(NUMBER, user.get(NUMBER));
            values.put("userType", user.get("userType"));
            values.put(PHONE, user.get(PHONE));
            values.put(EMAIL, user.get(EMAIL));
            email = (String)user.get(EMAIL);
            final MsgChannel msgChannel = this.getMsgChannel();
            if (!msgChannel.getNotEmpty().booleanValue()) {
                mpData.put(MSG, ResManager.loadKDString((String)"\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u914d\u7f6e\u90ae\u7bb1\u6e20\u9053\u3002", (String)"ResetPasswordAction_57", (String)BOS_LOGIN, (Object[])new Object[0]));
                return mpData;
            }
            Properties props = this.getEmailProperties(msgChannel);
            Session session = Session.getInstance((Properties)props, (Authenticator)new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    String userName = "";
                    String pw = "";
                    if (msgChannel.isAuth()) {
                        pw = msgChannel.getPassword();
                        userName = msgChannel.getUsername();
                    }
                    String pwAfterDcode = "";
                    if (kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)pw)) {
                        pwAfterDcode = pw.startsWith("d@f*g:") ? Encrypters.decode((String)pw) : pw;
                    }
                    return new PasswordAuthentication(userName, pwAfterDcode);
                }
            });
            session.setDebug(false);
            String key = kd.bos.login.utils.StringUtils.randomWord(128);
            Map<String, String> templateMsgMap = this.getTemplateMsgMap(servletRequest, currentCenter, values, key);
            if (templateMsgMap.isEmpty()) {
                return mpData;
            }
            String subject = templateMsgMap.get("subject");
            String templateMsg = templateMsgMap.get("templateMsg");
            MimeMessage msg = new MimeMessage(session);
            msg.setFrom((Address)new InternetAddress(msgChannel.getFromAccount(), msgChannel.getFromUsername()));
            msg.setRecipient(Message.RecipientType.TO, (Address)new InternetAddress(email));
            MimeBodyPart mbp = new MimeBodyPart();
            String contentType = "text/html;charset=UTF-8";
            msg.setSubject(SecurityUtils.replaceCrlf(subject));
            mbp.setContent((Object)templateMsg, contentType);
            MimeMultipart mp = new MimeMultipart();
            mp.addBodyPart((BodyPart)mbp);
            msg.setContent((Multipart)mp);
            msg.setSentDate(new Date());
            Transport.send((Message)msg);
            CacheLoginData.setAttribute((String)RESETPWD, (String)(FIND_PSW_BY_EMAIL_KEY + key), (String)userId, (int)1800);
            CacheLoginData.setAttribute((String)RESETPWD, (String)(FIND_PSW_BY_EMAIL_KEY + userId), (String)currentCenter.getAccountId(), (int)1800);
        }
        catch (MessagingException e) {
            logger.error((Throwable)e);
            String msg = e.getMessage();
            if (StringUtils.isNotEmpty((String)msg) && msg.replace(" ", "").contains("authenticationfailed")) {
                mpData.put(MSG, ResManager.loadKDString((String)"\u90ae\u7bb1\u8ba4\u8bc1\u5931\u8d25\uff0c \u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ResetPasswordAction_54", (String)BOS_LOGIN, (Object[])new Object[0]));
            } else {
                mpData.put(MSG, ResManager.loadKDString((String)"\u90ae\u4ef6\u53d1\u9001\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u90ae\u7bb1\u670d\u52a1\u5668\u914d\u7f6e\u3002", (String)"ResetPasswordAction_55", (String)BOS_LOGIN, (Object[])new Object[0]));
            }
            return mpData;
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            String msg = e.getMessage();
            mpData.put(MSG, e.getMessage());
            return mpData;
        }
        mpData.put(SUCCESS, true);
        return mpData;
    }

    private MsgChannel getMsgChannel() {
        DynamicObject[] msgChannelArray = BusinessDataServiceHelper.load((String)"msg_channel", (String)"smtphost,smtpport,username, password,fromaccount,domain,enable,mobileappconfig,fromusername,auth", (QFilter[])new QFilter[]{new QFilter("category", "=", (Object)EMAIL)}, (String)"createdate asc");
        MsgChannel channel = new MsgChannel(false);
        for (DynamicObject data : msgChannelArray) {
            if ("true".equalsIgnoreCase(String.valueOf(data.get("enable")))) {
                this.setChannelFromDb(data, channel);
                return channel;
            }
            this.setChannelFromDb(data, channel);
        }
        return channel;
    }

    private void setChannelFromDb(DynamicObject data, MsgChannel channel) {
        channel.setPassword(String.valueOf(data.get("password")));
        channel.setSmtpHost(String.valueOf(data.get("smtphost")));
        channel.setSmtpPort(String.valueOf(data.get("smtpport")));
        channel.setUsername(String.valueOf(data.get("username")));
        channel.setFromAccount(String.valueOf(data.get("fromaccount")));
        channel.setFromUsername(String.valueOf(data.get("fromusername")));
        channel.setDomain(String.valueOf(data.get("domain")));
        channel.setConfig(String.valueOf(data.get("mobileappconfig")));
        channel.setNotEmpty(true);
        channel.setAuth(data.getBoolean("auth"));
    }

    private static String getBaseUrl() {
        String baseConfig = System.getProperty("url");
        if (StringUtils.isEmpty((String)baseConfig)) {
            baseConfig = "http://api.kingdee.com/";
        }
        return kd.bos.login.utils.StringUtils.getPathString(baseConfig);
    }

    private static String getCloudClientId() {
        String cloudId = System.getProperty("clientId");
        if (StringUtils.isEmpty((String)cloudId)) {
            cloudId = "201230";
        }
        return cloudId;
    }

    private static String getClientSecret() {
        String clientSecret = System.getProperty("clientSecret");
        if (StringUtils.isNotEmpty((String)clientSecret)) {
            clientSecret = Encrypters.decode((String)clientSecret);
        }
        if (kd.bos.util.StringUtils.isEmpty((String)clientSecret)) {
            clientSecret = DefaultParameterService.getDefaultValueByKey("client_param");
        }
        return clientSecret;
    }

    private Map<String, Object> checkUserStatus(String mobile, Map<String, Object> mpData) {
        DynamicObject[] userArray = LoginUserService.getUserList(mobile, UserProperType.Mobile, true);
        if (userArray != null && userArray.length > 0) {
            boolean flag = false;
            for (DynamicObject user : userArray) {
                String fenable = user.getString("enable");
                String fisforbidden = user.getString("isforbidden");
                if (!(kd.bos.util.StringUtils.isNotEmpty((String)fenable) && fenable.equals(VALUE_0) || "true".equals(fisforbidden))) {
                    flag = false;
                    break;
                }
                flag = true;
            }
            if (flag) {
                mpData.put(MSG, ResManager.loadKDString((String)"\u7528\u6237\u5df2\u88ab\u7981\u7528\u3002", (String)"ResetPasswordAction_59", (String)BOS_LOGIN, (Object[])new Object[0]));
                mpData.put(SUCCESS, false);
            }
        } else {
            mpData.put(SUCCESS, false);
            mpData.put(PHONE, false);
            CacheLoginData.setAttribute((String)RESETPWD, (String)(mobile + "_sendStatus"), (String)"false", (int)300);
        }
        return mpData;
    }

    private boolean activeUser(Account currentCenter, LoginUserDTO loginUserDTO) {
        Object data = DispatchServiceHelper.invokeBOSService("ILoginUserService", "activeUser", currentCenter, loginUserDTO);
        return "true".equals(String.valueOf(data));
    }

    private Properties getEmailProperties(MsgChannel msgChannel) {
        Properties props = System.getProperties();
        if (StringUtils.isNotEmpty((String)msgChannel.getDomain())) {
            props.put("mail.smtp.auth.ntlm.domain", msgChannel.getDomain());
            logger.info("sendEmail--email domain is setted");
        } else {
            props.remove("mail.smtp.auth.ntlm.domain");
        }
        if (StringUtils.isNotEmpty((String)msgChannel.getConfig())) {
            JSONObject jsonConfig = JSONObject.parseObject((String)msgChannel.getConfig());
            String smtpProtocol = jsonConfig.getString("smtpProtocol");
            if ("ssl".equalsIgnoreCase(smtpProtocol)) {
                props.put("mail.smtp.ssl.enable", "true");
                props.setProperty("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            } else if ("tls".equalsIgnoreCase(smtpProtocol)) {
                props.put("mail.smtp.starttls.enable", "true");
            } else if ("all".equalsIgnoreCase(smtpProtocol)) {
                props.put("mail.smtp.starttls.enable", "true");
                props.put("mail.smtp.ssl.enable", "true");
                props.setProperty("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            } else {
                props.remove("mail.smtp.ssl.enable");
                props.remove("mail.smtp.socketFactory.class");
                props.remove("mail.smtp.starttls.enable");
            }
        }
        props.setProperty("mail.smtp.host", msgChannel.getSmtpHost());
        props.setProperty("mail.smtp.socketFactory.fallback", "false");
        props.setProperty("mail.smtp.port", msgChannel.getSmtpPort());
        props.setProperty("mail.smtp.socketFactory.port", msgChannel.getSmtpPort());
        props.setProperty("mail.smtp.auth", "true");
        props.setProperty("mail.smtp.connectiontimeout", "20000");
        props.setProperty("mail.smtp.timeout", "20000");
        System.setProperty("java.net.preferIPv4Stack", "true");
        return props;
    }

    private Map<String, Object> getCheckSendResult(String phone, Map<String, Object> mpData, int msgTimeout) {
        String attribute = CacheLoginData.getAttribute((String)RESETPWD, (String)phone);
        if (attribute != null && attribute.trim().length() != 0) {
            mpData.put(SUCCESS, false);
            mpData.put("hasSent", true);
            mpData.put(LEVEL, 2);
            mpData.put(MSG, String.format(ResManager.loadKDString((String)"%s\u79d2\u5185\u4ec5\u80fd\u83b7\u53d6\u4e00\u6b21\u624b\u673a\u9a8c\u8bc1\u7801\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"ResetPasswordAction_79", (String)BOS_LOGIN, (Object[])new Object[0]), msgTimeout));
        }
        return mpData;
    }

    private Map<String, String> getTemplateMsgMap(HttpServletRequest servletRequest, Account currentCenter, Map<String, Object> values, String key) {
        String domainurl;
        HashMap<String, String> result = new HashMap<String, String>(2);
        String templateMsg = "<p>\u5c0a\u656c\u7684 {name} \uff1a&nbsp;</p><p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\u5982\u60a8\u7684\u5bc6\u7801\u5df2\u9057\u5fd8\uff0c\u70b9\u51fb\u4e0b\u65b9\u94fe\u63a5\u8fdb\u5165\u91cd\u7f6e\uff0c</p><p>\u5e76\u59a5\u5b58\u60a8\u7684\u7528\u6237\u540d\u548c\u5bc6\u7801\u3002&nbsp;</p><p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\u6b64\u90ae\u4ef6\u65e0\u9700\u56de\u590d\u3002\u611f\u8c22\u60a8\u7684\u652f\u6301\u3002&nbsp;&nbsp;</p><p><a href=\"{url}\" target=\"_blank\">{url}</a><br></p>";
        if (Lang.en_US.equals((Object)LoginLangUtils.getLoginLanguage(servletRequest))) {
            templateMsg = "<p>Dear {name} : &nbsp;</p><p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; If you have forgotten your password,click the link below to go to reset,</p><p>and save your username and password. &nbsp;</p><p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;No reply is required. Thank you for your support. &nbsp;&nbsp;</p><p><a href=\"{url}\" target=\"_blank\">{url}</a><br></p>";
        }
        String subject = ResManager.loadKDString((String)"\u7528\u6237\u91cd\u8bbe\u5bc6\u7801\u8bf4\u660e", (String)"ResetPasswordAction_46", (String)BOS_LOGIN, (Object[])new Object[0]);
        List templateMsgList = MessageCenterServiceHelper.getMessageTemplateByFilters((String)"warning", (String)EMAIL, (String)"findPswByEmail", (String)"bos_user");
        if (CollectionUtils.isEmpty((Collection)templateMsgList)) {
            Lang lang = ResetPasswordAction.getDefaultLang(servletRequest, currentCenter);
            LoginLangUtils.setLang(lang);
            templateMsgList = MessageCenterServiceHelper.getMessageTemplateByFilters((String)"warning", (String)EMAIL, (String)"findPswByEmail", (String)"bos_user");
        }
        if (!ObjectUtils.isEmpty((Object)templateMsgList) && StringUtils.isNotBlank((String)((String)templateMsgList.get(0)))) {
            JSONObject json = JSONObject.parseObject((String)((String)templateMsgList.get(0)));
            if (null != json.get((Object)"emailTitle")) {
                subject = json.get((Object)"emailTitle").toString();
            }
            if (null != json.get((Object)"emailContent")) {
                templateMsg = json.get((Object)"emailContent").toString();
            }
        }
        if (kd.bos.util.StringUtils.isEmpty((String)(domainurl = RevProxyUtil.getURLContextPath((HttpServletRequest)servletRequest)))) {
            domainurl = UrlService.getDomainContextUrlByTenantCode((String)RevProxyUtil.getTenantCode((HttpServletRequest)servletRequest));
        }
        if (kd.bos.util.StringUtils.isNotEmpty((String)domainurl) && domainurl.endsWith("/")) {
            domainurl = domainurl.substring(0, domainurl.length() - 1);
        }
        String lang = servletRequest.getParameter("language");
        StringBuilder sb = new StringBuilder();
        sb.append(domainurl).append("/login.html?userKey=").append(key).append("&language=").append(lang).append("#findPassword");
        templateMsg = templateMsg.replace("{url}", sb.toString());
        for (Map.Entry<String, Object> entry : values.entrySet()) {
            templateMsg = templateMsg.replace("{" + entry.getKey() + "}", null != entry.getValue() ? entry.getValue().toString() : "  ");
            subject = subject.replace("{" + entry.getKey() + "}", null != entry.getValue() ? entry.getValue().toString() : "  ");
        }
        result.put("templateMsg", templateMsg);
        result.put("subject", subject);
        return result;
    }

    private static Lang getDefaultLang(HttpServletRequest servletRequest, Account currentCenter) {
        List<Language> lList = LoginUtils.getAllLanguagesByAccount(currentCenter);
        for (Language language : lList) {
            if (!language.isDefault()) continue;
            return Lang.from((String)language.getName());
        }
        return LoginLangUtils.getLoginLanguage(servletRequest);
    }
}

