/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.actions;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.actiondispatcher.ActionUtil;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dc.api.model.Account;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDException;
import kd.bos.exception.LoginErrorCode;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.CacheLoginData;
import kd.bos.login.LoginClientEnum;
import kd.bos.login.actions.LoginAction;
import kd.bos.login.lang.LoginLangUtils;
import kd.bos.login.service.MailService;
import kd.bos.login.service.session.SessionService;
import kd.bos.login.service.session.SessionServiceFactory;
import kd.bos.login.user.DefaultParameterService;
import kd.bos.login.user.LoginUserService;
import kd.bos.login.user.UserService;
import kd.bos.login.utils.AdminUtils;
import kd.bos.login.utils.Constants;
import kd.bos.login.utils.JSONUtils;
import kd.bos.login.utils.LoginUtils;
import kd.bos.login.utils.MessageUtils;
import kd.bos.login.utils.SessionUtils;
import kd.bos.login.utils.StringUtils;
import kd.bos.login.utils.ValidationUtils;
import kd.bos.login.utils.account.LoginAccountFactory;
import kd.bos.login.utils.log.AppLogParams;
import kd.bos.login.utils.log.LoginLogUtils;
import kd.bos.login.utils.sms.LoginMessageUtils;
import kd.bos.util.NetAddressUtils;

public class SMSLoginAction {
    private static final String BOS_LOGIN = "bos-login";
    private static final String SUCCESS = "success";
    private static final String FORGID = "forgid";
    private static Log logger = LogFactory.getLog(LoginAction.class);
    private static final String ERRCODE = "errcode";
    private static final int LIMIT_TIMEOUT = 300;
    private static final String TOTAL_TIMES = "total_times";
    private SessionService sessionService = SessionServiceFactory.createSessionService();

    public void sendMessage(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException {
        Lang lang = LoginLangUtils.getLoginLanguage(servletRequest);
        LoginLangUtils.setLang(lang);
        try {
            Account currentCenter = LoginAccountFactory.createInstanceByHttpRequest(servletRequest, Optional.empty()).getAccount();
            int msgTimeout = LoginMessageUtils.getMsgTimeout(currentCenter);
            int timeout = MessageUtils.getSMSTimeOut();
            if (!LoginUtils.proveVerifyCode(servletRequest, servletResponse, true, this.needVerifyCode(currentCenter), timeout)) {
                return;
            }
            String userName = servletRequest.getParameter(Constants.LOGIN_USER_KEY);
            String limitKey = currentCenter.getAccountId() + userName + "limit";
            String factorType = servletRequest.getParameter("factor");
            if (factorType != null && "email".equals(factorType)) {
                this.sendByEmail(servletRequest, servletResponse);
                return;
            }
            if (this.sendPhoneCode(servletRequest, servletResponse, lang, currentCenter, msgTimeout, timeout, userName, limitKey)) {
                HashMap<String, Comparable<Boolean>> mpData = new HashMap<String, Comparable<Boolean>>(8);
                mpData.put(SUCCESS, Boolean.valueOf(true));
                mpData.put("timeout", Integer.valueOf(msgTimeout));
                String result = JSONUtils.toString(mpData);
                ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)result);
                return;
            }
        }
        catch (KDException ex) {
            logger.error((Throwable)ex);
            this.outputSMSError(servletResponse, ex.getMessage());
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            KDException kd = new KDException(LoginErrorCode.loginBizException, new Object[]{ResManager.loadKDString((String)"\u7cfb\u7edf\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"SMSLoginAction_5", (String)BOS_LOGIN, (Object[])new Object[0])});
            this.outputSMSError(servletResponse, kd.getMessage());
        }
    }

    private void sendByEmail(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException {
        try {
            Lang lang = LoginLangUtils.getLoginLanguage(servletRequest);
            Account currentCenter = LoginAccountFactory.createInstanceByHttpRequest(servletRequest, Optional.empty()).getAccount();
            String userName = servletRequest.getParameter(Constants.LOGIN_USER_KEY);
            String limitKey = currentCenter.getAccountId() + userName + "limit";
            String attribute = CacheLoginData.getAttribute((String)"emailLogin", (String)limitKey);
            int msgTimeout = LoginMessageUtils.getMsgTimeout(currentCenter);
            if (attribute != null && attribute.trim().length() != 0) {
                throw new KDException(LoginErrorCode.loginBizException, new Object[]{String.format(ResManager.loadKDString((String)"%s\u79d2\u5185\u4ec5\u80fd\u83b7\u53d6\u4e00\u6b21\u9a8c\u8bc1\u7801\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"SMSLoginAction_10", (String)BOS_LOGIN, (Object[])new Object[0]), msgTimeout)});
            }
            boolean isAdmin = AdminUtils.getAdminList().contains(userName);
            if (!isAdmin && !ValidationUtils.isEmail(userName)) {
                throw new KDException(LoginErrorCode.loginBizException, new Object[]{String.format(ResManager.loadKDString((String)"\u90ae\u7bb1\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"ResetPasswordAction_82", (String)BOS_LOGIN, (Object[])new Object[0]), userName)});
            }
            Map<String, String> mapUser = null;
            if (isAdmin) {
                mapUser = LoginUserService.getErpUserInfoByUserName(currentCenter, userName, lang.getLangTag());
                if (mapUser.get("userid") != null) {
                    mapUser = LoginUserService.getErpUserInfoByUserId(currentCenter, mapUser.get("userid"), lang.getLangTag());
                }
            } else {
                mapUser = LoginUserService.getErpUserInfoByEmail(currentCenter, userName, lang.getLangTag());
            }
            String email = null;
            if (mapUser != null && mapUser.size() > 0) {
                email = mapUser.get("femail");
                if (isAdmin && StringUtils.isEmpty(email)) {
                    throw new KDException(LoginErrorCode.loginBizException, new Object[]{ResManager.loadKDString((String)"\u7ba1\u7406\u5458\u672a\u8bbe\u7f6e\u90ae\u7bb1\u8d26\u53f7\u3002", (String)"SMSLoginAction_11", (String)BOS_LOGIN, (Object[])new Object[0])});
                }
            } else {
                HashMap<String, Comparable<Boolean>> mpData = new HashMap<String, Comparable<Boolean>>(8);
                mpData.put(SUCCESS, Boolean.valueOf(true));
                mpData.put("timeout", Integer.valueOf(msgTimeout));
                String result = JSONUtils.toString(mpData);
                ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)result);
                return;
            }
            String code = StringUtils.randomNumber(MessageUtils.getSMSCodelength());
            CacheLoginData.setAttribute((String)"emailLogin", (String)(currentCenter.getAccountId() + userName), (String)code, (int)300);
            CacheLoginData.setAttribute((String)"emailLogin", (String)limitKey, (String)code, (int)msgTimeout);
            MailService mailService = new MailService();
            mailService.sendEmailByLogin(email, code);
            AppLogParams logParams = LoginLogUtils.initParams(servletRequest, currentCenter, isAdmin ? userName : email, "email");
            logParams.setAdmin(isAdmin);
            LoginLogUtils.addAppLog(logParams);
            HashMap<String, Comparable<Boolean>> mpData = new HashMap<String, Comparable<Boolean>>(8);
            mpData.put(SUCCESS, Boolean.valueOf(true));
            mpData.put("timeout", Integer.valueOf(msgTimeout));
            String result = JSONUtils.toString(mpData);
            ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)result);
        }
        catch (KDException ex) {
            logger.error((Throwable)ex);
            this.outputSMSError(servletResponse, ex.getMessage());
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            KDException kd = new KDException(LoginErrorCode.loginBizException, new Object[]{ResManager.loadKDString((String)"\u7cfb\u7edf\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"SMSLoginAction_5", (String)BOS_LOGIN, (Object[])new Object[0])});
            this.outputSMSError(servletResponse, kd.getMessage());
        }
    }

    private void sendActiveMessage(Account currentCenter, String userName, String phone, int timeout) {
        Map<String, Object> mpData = UserService.getActiveCode(currentCenter, phone);
        if (mpData.get(SUCCESS) == null || !((Boolean)mpData.get(SUCCESS)).booleanValue()) {
            throw new KDException(LoginErrorCode.loginBizException, new Object[]{mpData.get("error")});
        }
        CacheLoginData.setAttribute((String)"smsLogin", (String)SMSLoginAction.getCacheKey(currentCenter.getAccountId() + userName, "actived"), (String)"true", (int)timeout);
    }

    private void outputSMSError(HttpServletResponse servletResponse, String message) throws IOException {
        HashMap<String, Object> mpDatampData = new HashMap<String, Object>();
        mpDatampData.put(SUCCESS, false);
        mpDatampData.put("msg", message);
        String result = JSONUtils.toString(mpDatampData);
        ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)result);
    }

    public void login(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException {
        Lang lang = LoginLangUtils.getLoginLanguage(servletRequest);
        LoginLangUtils.setLang(lang);
        String needVerifyCode = servletRequest.getParameter("needVerifyCode");
        int timeout = MessageUtils.getSMSTimeOut();
        try {
            String userName = servletRequest.getParameter(Constants.LOGIN_USER_KEY);
            Account currentCenter = LoginAccountFactory.createInstanceByHttpRequest(servletRequest, Optional.empty()).getAccount();
            boolean checkFlag = false;
            checkFlag = this.checkCode(servletRequest, currentCenter, userName, lang);
            if (checkFlag) {
                this.loginByPhone(servletRequest, servletResponse, userName, currentCenter);
            }
        }
        catch (KDException ex) {
            logger.error((Throwable)ex);
            this.outputSMSError(servletResponse, ex.getMessage());
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            this.outputSMSError(servletResponse, e.getMessage());
        }
    }

    private void loginByPhone(HttpServletRequest request, HttpServletResponse response, String user, Account currentCenter) throws KDException, IOException {
        String redirect;
        Lang lang = LoginLangUtils.getLoginLanguage(request);
        LoginLangUtils.setLang(lang);
        Map<String, String> userInfo = LoginUserService.getErpUserInfoByPhone(currentCenter, user, lang.name());
        if (userInfo == null || userInfo.size() <= 1) {
            throw new KDException(LoginErrorCode.loginBizException, new Object[]{ResManager.loadKDString((String)"\u60a8\u7684\u8d26\u53f7\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728!", (String)"SMSLoginAction_8", (String)BOS_LOGIN, (Object[])new Object[0])});
        }
        String userName = userInfo.get("ftruename");
        String accessToken = SessionUtils.createNewSession(request, response, currentCenter, lang, NetAddressUtils.getRemoteHost((HttpServletRequest)request), userInfo, LoginClientEnum.WEB);
        Map cacheKey = CacheLoginData.getCache((String)CacheLoginData.getType4YzjEKey((String)currentCenter.getAccountId()));
        if (cacheKey == null || cacheKey.size() == 0) {
            HashMap<String, String> mpYzjEidKeyData = new HashMap<String, String>();
            mpYzjEidKeyData.put("Eid", currentCenter.getEid());
            mpYzjEidKeyData.put("KeyData", currentCenter.getKeyFile());
            CacheLoginData.setAttributes((String)CacheLoginData.getType4YzjEKey((String)currentCenter.getAccountId()), mpYzjEidKeyData);
        }
        if (StringUtils.isEmpty(redirect = request.getParameter("redirect"))) {
            redirect = "index.html";
        } else {
            String qs = request.getQueryString();
            if (qs != null) {
                redirect = qs.replace("redirect=", "");
            }
            if (!LoginUtils.isSelfEnvironment(redirect, request, response) && !this.trustRedirectUrl(currentCenter, redirect)) {
                redirect = "index.html?formId=pc_main_console";
            }
        }
        LoginUtils.clearSmsSendTimes(currentCenter.getAccountId(), user);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("errorcode", 0);
        map.put("RedirectURL", redirect);
        map.put("accesstoken", accessToken);
        map.put("username", userName);
        String result = JSONUtils.toString(map);
        ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)result);
    }

    private void sendMessage(Account currentCenter, String userName, int timeout, String phone, String code, String sendMessage, HttpServletRequest servletRequest) {
        Map<String, Object> sendSmsCheckResult = LoginUtils.isAllowSendSms(currentCenter.getAccountId(), userName);
        if (sendSmsCheckResult.get(SUCCESS) != null && !Boolean.parseBoolean(sendSmsCheckResult.get(SUCCESS).toString())) {
            throw new KDException(LoginErrorCode.loginBizException, new Object[]{sendSmsCheckResult.get("message")});
        }
        boolean isAdmin = AdminUtils.getAdminList().contains(userName);
        AppLogParams logParams = LoginLogUtils.initParams(servletRequest, currentCenter, isAdmin ? userName : phone, "phone");
        logParams.setAdmin(isAdmin);
        boolean isOk = MessageUtils.sendMessage(phone, code, sendMessage, MessageUtils.getSignature(currentCenter), Lang.get());
        if (!isOk && isAdmin) {
            isOk = MessageUtils.sendMessage(phone, sendMessage, MessageUtils.getSignature(currentCenter));
        }
        if (!isOk) {
            logParams.setResult(false);
            LoginLogUtils.addAppLog(logParams);
            throw new KDException(LoginErrorCode.loginBizException, new Object[]{ResManager.loadKDString((String)"\u6821\u9a8c\u7801\u53d1\u9001\u5931\u8d25\u3002", (String)"SMSLoginAction_3", (String)BOS_LOGIN, (Object[])new Object[0])});
        }
        LoginLogUtils.addAppLog(logParams);
    }

    private String dealActiveData(Account currentCenter, Map<String, Object> result, String userName, Lang lang) {
        String message = "";
        if (result.get(ERRCODE) != null && "0".equals(String.valueOf(result.get(ERRCODE)))) {
            Map data = null != result.get("data") ? (Map)result.get("data") : null;
            String uid = "";
            uid = null != data ? (null != data.get("uid") ? data.get("uid").toString() : "0") : "0";
            if (ValidationUtils.isEmail(userName)) {
                boolean checkFlag = LoginUserService.updateErpUserInfoByEmail(currentCenter, userName, uid);
            } else {
                boolean checkFlag = LoginUserService.updateErpUserInfoByPhone(currentCenter, userName, uid);
            }
        } else {
            message = result.get(ERRCODE) != null && "4006".equals(String.valueOf(result.get(ERRCODE))) ? ResManager.loadKDString((String)"\u7cfb\u7edf\u672a\u6ce8\u518c\uff0c\u8bf7\u5148\u8054\u7cfb\u7ba1\u7406\u5458\u540c\u6b65\u8bb8\u53ef\u3002", (String)"ResetPasswordAction_80", (String)BOS_LOGIN, (Object[])new Object[0]) : (lang != null && (lang.name().equalsIgnoreCase("en") || lang.name().equalsIgnoreCase("en_US")) ? (result.get("description") != null ? result.get("description").toString() : "") : (result.get("DESCRIPTION_CN") != null ? result.get("DESCRIPTION_CN").toString() : ""));
        }
        return message;
    }

    private static String getCacheKey(String prefix, String suffix) {
        StringBuilder cacheKey = new StringBuilder();
        cacheKey.append(prefix).append(suffix);
        return cacheKey.toString();
    }

    private static boolean isNew(HttpServletRequest request) {
        String isNew = request.getParameter("isNew");
        return StringUtils.isNotEmpty(isNew) && "true".equals(isNew);
    }

    private static boolean isNeedActive(HttpServletRequest request) {
        String needActiveStr = request.getParameter("needActive");
        return !StringUtils.isNotEmpty(needActiveStr) || !"false".equals(needActiveStr);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean checkCode(HttpServletRequest servletRequest, Account currentCenter, String userName, Lang lang) {
        boolean checkFlag = false;
        String mobileCode = servletRequest.getParameter("smsCode");
        String isActived = CacheLoginData.getAttribute((String)"smsLogin", (String)SMSLoginAction.getCacheKey(currentCenter.getAccountId() + userName, "actived"));
        if (SMSLoginAction.isNeedActive(servletRequest) && SMSLoginAction.isNew(servletRequest) && StringUtils.isNotEmpty(isActived)) {
            Map<String, Object> result = UserService.verifyCloudCode(currentCenter, userName, mobileCode);
            if (null != result && result.size() > 0) {
                String message = this.dealActiveData(currentCenter, result, userName, lang);
                if (!StringUtils.isEmpty(message)) throw new KDException(LoginErrorCode.loginBizException, new Object[]{message});
                checkFlag = true;
            }
        } else {
            String code = CacheLoginData.getAttribute((String)"smsLogin", (String)(currentCenter.getAccountId() + userName));
            if (!StringUtils.isNotEmpty(code)) throw new KDException(LoginErrorCode.loginBizException, new Object[]{String.format(ResManager.loadKDString((String)"\u624b\u673a\u9a8c\u8bc1\u7801\u9519\u8bef\u6216\u5df2\u8fc7\u671f\u3002", (String)"SMSLoginAction_7", (String)BOS_LOGIN, (Object[])new Object[0]), userName)});
            if (code.equals(mobileCode)) {
                checkFlag = true;
            } else {
                String errorTimes = CacheLoginData.getAttribute((String)"smsLogin", (String)(currentCenter.getAccountId() + userName + TOTAL_TIMES));
                if (StringUtils.isNotBlank(errorTimes) && Integer.parseInt(errorTimes) > 3) {
                    CacheLoginData.remove((String)"smsLogin", (String)(currentCenter.getAccountId() + userName + TOTAL_TIMES));
                    CacheLoginData.remove((String)"smsLogin", (String)(currentCenter.getAccountId() + userName));
                    throw new KDException(LoginErrorCode.loginBizException, new Object[]{String.format(ResManager.loadKDString((String)"\u624b\u673a\u9a8c\u8bc1\u7801\u9519\u8bef\u6216\u5df2\u8fc7\u671f\u3002", (String)"SMSLoginAction_6", (String)BOS_LOGIN, (Object[])new Object[0]), userName)});
                }
                if (StringUtils.isEmpty(errorTimes)) {
                    errorTimes = "0";
                }
                errorTimes = String.valueOf(Integer.parseInt(errorTimes) + 1);
                CacheLoginData.setAttribute((String)"smsLogin", (String)(currentCenter.getAccountId() + userName + TOTAL_TIMES), (String)errorTimes, (int)300);
                throw new KDException(LoginErrorCode.loginBizException, new Object[]{String.format(ResManager.loadKDString((String)"\u624b\u673a\u9a8c\u8bc1\u7801\u9519\u8bef\u6216\u5df2\u8fc7\u671f\u3002", (String)"SMSLoginAction_6", (String)BOS_LOGIN, (Object[])new Object[0]), userName)});
            }
        }
        if (!checkFlag) return checkFlag;
        CacheLoginData.remove((String)"smsLogin", (String)(currentCenter.getAccountId() + userName));
        CacheLoginData.remove((String)"smsLogin", (String)(currentCenter.getAccountId() + "randomCode"));
        CacheLoginData.remove((String)"smsLogin", (String)(currentCenter.getAccountId() + userName + TOTAL_TIMES));
        return checkFlag;
    }

    private boolean sendPhoneCode(HttpServletRequest servletRequest, HttpServletResponse servletResponse, Lang lang, Account currentCenter, int msgTimeout, int timeout, String userName, String limitKey) {
        DLock lock = null;
        try {
            lock = DLock.create((String)(currentCenter.getAccountId() + userName));
            if (lock.tryLock(3000L)) {
                String msg;
                String attribute = CacheLoginData.getAttribute((String)"smsLogin", (String)limitKey);
                if (attribute != null && attribute.trim().length() != 0) {
                    throw new KDException(LoginErrorCode.loginBizException, new Object[]{String.format(ResManager.loadKDString((String)"%s\u79d2\u5185\u4ec5\u80fd\u83b7\u53d6\u4e00\u6b21\u9a8c\u8bc1\u7801\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"SMSLoginAction_10", (String)BOS_LOGIN, (Object[])new Object[0]), msgTimeout)});
                }
                if (!AdminUtils.getAdminList().contains(userName) && StringUtils.isNotEmpty(msg = this.verifyPhoneNumber(userName))) {
                    throw new KDException(LoginErrorCode.loginBizException, new Object[]{msg});
                }
                Map<String, String> mapUser = LoginUserService.getErpUserInfoByPhone(currentCenter, userName, lang.getLangTag());
                String phone = null;
                if (mapUser != null && mapUser.size() > 0) {
                    phone = mapUser.get("fphone");
                    if (AdminUtils.getAdminList().contains(userName) && StringUtils.isEmpty(phone)) {
                        throw new KDException(LoginErrorCode.loginBizException, new Object[]{ResManager.loadKDString((String)"\u7ba1\u7406\u5458\u672a\u8bbe\u7f6e\u624b\u673a\u53f7\u7801\u3002", (String)"SMSLoginAction_2", (String)BOS_LOGIN, (Object[])new Object[0])});
                    }
                } else {
                    HashMap<String, Comparable<Boolean>> mpData = new HashMap<String, Comparable<Boolean>>(8);
                    mpData.put(SUCCESS, Boolean.valueOf(true));
                    mpData.put("timeout", Integer.valueOf(msgTimeout));
                    String result = JSONUtils.toString(mpData);
                    ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)result);
                    boolean bl = false;
                    return bl;
                }
                String code = StringUtils.randomNumber(MessageUtils.getSMSCodelength());
                String sendMessage = MessageUtils.getSMSContent(code);
                this.sendMessage(currentCenter, userName, timeout, phone, code, sendMessage, servletRequest);
                CacheLoginData.setAttribute((String)"smsLogin", (String)(currentCenter.getAccountId() + userName), (String)code, (int)300);
                CacheLoginData.setAttribute((String)"smsLogin", (String)limitKey, (String)code, (int)msgTimeout);
            }
        }
        catch (Exception e) {
            logger.error("sendMessage", (Throwable)e);
            throw new KDException(LoginErrorCode.loginBizException, new Object[]{e.getMessage()});
        }
        finally {
            if (lock != null) {
                lock.unlock();
            }
        }
        return true;
    }

    private String verifyPhoneNumber(String phone) {
        if (phone != null && !phone.contains("-")) {
            phone = "86-" + phone;
        }
        return LoginUtils.verifyPhoneNumber(phone);
    }

    private boolean needVerifyCode(Account currentCenter) {
        String needVerifyCode = DefaultParameterService.getDefaultParamsConfig(currentCenter, "bos_svc_login_needVerifyCode");
        return StringUtils.isEmpty(needVerifyCode) || "true".equals(needVerifyCode);
    }

    private boolean trustRedirectUrl(Account currentCenter, String redirect) {
        String trustRedirectUrl = DefaultParameterService.getDefaultParamsConfig(currentCenter, "bos_svc_login_trustRedirectUrl");
        if (StringUtils.isNotBlank(trustRedirectUrl)) {
            String[] trustRedirectUrlArray;
            for (String trustUrl : trustRedirectUrlArray = trustRedirectUrl.split(";")) {
                if (!redirect.contains(trustUrl)) continue;
                return true;
            }
        }
        return false;
    }
}

