/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.actions;

import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.actiondispatcher.ActionUtil;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.exception.LoginErrorCode;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.LoginClientEnum;
import kd.bos.login.LoginType;
import kd.bos.login.lang.LoginLangUtils;
import kd.bos.login.user.LoginUserService;
import kd.bos.login.utils.HttpUtils;
import kd.bos.login.utils.LoginUtils;
import kd.bos.login.utils.SessionUtils;
import kd.bos.login.utils.account.LoginAccountFactory;
import kd.bos.tenant.TenantInfo;
import kd.bos.util.NetAddressUtils;
import org.apache.commons.lang.StringUtils;

public class StandaloneAction {
    private static final String HCODE_REDIRECT = "redirect";
    private static final String BOS_LOGIN = "bos-login";
    private static Log logger = LogFactory.getLog(StandaloneAction.class);
    private List<Account> allAccounts;

    public void login(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException {
        Lang lang = LoginLangUtils.getLoginLanguage(servletRequest);
        LoginLangUtils.setLang(lang);
        Object loginType = servletRequest.getAttribute("LoginType");
        if (loginType != LoginType.STANDALONE) {
            return;
        }
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)servletResponse.getOutputStream(), "utf-8");){
            CharSequence html = null;
            try (InputStream in = this.getClass().getResourceAsStream("/StandaloneLogin.tpl");){
                html = CharStreams.toString((Readable)new InputStreamReader(in, "UTF-8"));
            }
            servletResponse.setContentType("text/html;charset=utf-8");
            HashMap<String, CharSequence> m = new HashMap<String, CharSequence>();
            m.put(HCODE_REDIRECT, servletRequest.getParameter(HCODE_REDIRECT));
            this.allAccounts = LoginAccountFactory.createInstanceByDefault().getAccounts();
            StringBuilder sb = new StringBuilder();
            for (Account account : this.allAccounts) {
                TenantInfo tenant = AccountUtils.getTenantByid((String)account.getTenantId());
                if (account.isDefault()) {
                    sb.append("<option selected='selected' value='").append(account.getAccountId()).append("'>").append(account.getAccountName()).append("(").append(tenant.getName()).append(") </option>");
                    continue;
                }
                sb.append("<option  value='").append(account.getAccountId()).append("'>").append(account.getAccountName()).append("(").append(tenant.getName()).append(") </option>");
            }
            m.put("accountList", sb.toString());
            m.put("username", "\"\"");
            m.put("message", "");
            m.put("contextPath", servletRequest.getContextPath());
            html = LoginUtils.replacePlaceHolder(html, m);
            writer.write(html.toString());
            writer.flush();
        }
        catch (KDException ex) {
            logger.error((Throwable)ex);
            ErrorCode code = ex.getErrorCode();
            String resp = LoginUtils.getLoginResponse(String.valueOf(code.getCode()), ex.getMessage());
            ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)resp);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            KDException kd = new KDException(LoginErrorCode.loginBizException, new Object[]{ResManager.loadKDString((String)"\u7cfb\u7edf\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\n", (String)"StandaloneAction_0", (String)BOS_LOGIN, (Object[])new Object[0])});
            String resp = LoginUtils.getLoginResponse(String.valueOf(kd.getErrorCode().getCode()), kd.getMessage());
            ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)resp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loginCheck(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Lang lang = LoginLangUtils.getLoginLanguage(request);
        LoginLangUtils.setLang(lang);
        Object loginType = request.getAttribute("LoginType");
        if (loginType != LoginType.STANDALONE) {
            return;
        }
        String accountId = request.getParameter("accountId");
        String user = request.getParameter("user");
        logger.info(String.format("@......\u767b\u5f55\u9a8c\u8bc1\u7528\u6237\u7684\u5408\u6cd5\u6027:\u79df\u6237:%s,\u7528\u6237%s\u3002", accountId, user));
        OutputStreamWriter writer = null;
        InputStream in = null;
        try {
            String tenantId = request.getParameter("tenantId");
            Account currentCenter = null;
            currentCenter = StringUtils.isNotEmpty((String)tenantId) ? LoginAccountFactory.createInstanceByCustom(accountId, tenantId).getAccount() : LoginAccountFactory.createInstanceByCustom(accountId).getAccount();
            Map<String, String> mpuser = LoginUserService.getErpUserInfoByPhone(currentCenter, user, lang.name());
            if (mpuser.size() > 0) {
                SessionUtils.createNewSession(request, response, currentCenter, LoginLangUtils.getLoginLanguage(request), NetAddressUtils.getRemoteHost((HttpServletRequest)request), mpuser, LoginClientEnum.WEB);
                LoginUtils.setCachkeyData(currentCenter);
                String redirect = request.getParameter(HCODE_REDIRECT);
                if (StringUtils.isEmpty((String)redirect)) {
                    redirect = "/ierp/index.html";
                }
                HttpUtils.sendRedirect(request, response, redirect);
            } else {
                in = this.getClass().getResourceAsStream("/StandaloneLogin.tpl");
                CharSequence html = CharStreams.toString((Readable)new InputStreamReader(in, "UTF-8"));
                response.setContentType("text/html;charset=utf-8");
                HashMap<String, CharSequence> m = new HashMap<String, CharSequence>();
                m.put(HCODE_REDIRECT, request.getParameter(HCODE_REDIRECT));
                this.allAccounts = LoginAccountFactory.createInstanceByDefault().getAccounts();
                StringBuilder sb = new StringBuilder();
                for (Account account : this.allAccounts) {
                    TenantInfo tenant = AccountUtils.getTenantByid((String)account.getTenantId());
                    if (account.isDefault()) {
                        sb.append("<option selected='selected' value='").append(account.getAccountId()).append("'>").append(account.getAccountName()).append("(").append(tenant.getName()).append(") </option>");
                        continue;
                    }
                    sb.append("<option value='").append(account.getAccountId()).append("'>").append(account.getAccountName()).append("(").append(tenant.getName()).append(") </option>");
                }
                m.put("accountList", sb.toString());
                m.put("username", "\"" + user + "\"");
                m.put("contextPath", request.getContextPath());
                m.put("message", ResManager.loadKDString((String)"\u60a8\u7684\u8d26\u53f7\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"StandaloneAction_1", (String)BOS_LOGIN, (Object[])new Object[0]));
                html = LoginUtils.replacePlaceHolder(html, m);
                writer = new OutputStreamWriter((OutputStream)response.getOutputStream(), "utf-8");
                writer.write(html.toString());
                writer.flush();
            }
        }
        catch (KDException ex) {
            ErrorCode code = ex.getErrorCode();
            String resp = LoginUtils.getLoginResponse(String.valueOf(code.getCode()), ex.getMessage());
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)resp);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            String resp = LoginUtils.getLoginResponse("1", ResManager.loadKDString((String)"\u7cfb\u7edf\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\n", (String)"StandaloneAction_0", (String)BOS_LOGIN, (Object[])new Object[0]));
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)resp);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception e) {
                    logger.error((Throwable)e);
                }
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {
                    logger.error((Throwable)e);
                }
            }
        }
    }
}

