/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.actions.dto;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import kd.bos.dc.api.model.Account;
import kd.bos.login.service.DispatchServiceHelper;
import kd.bos.login.service.dto.LoginUserDTO;
import kd.bos.login.user.PswStrategyService;
import kd.bos.login.utils.LoginUtils;
import kd.bos.util.PasswordEncryptUtil;

public class ActiveUserService {
    private static final String SUCCESS = "success";
    private boolean hasChanged;
    private String password;

    public ActiveUserService(String hasChanged) {
        this.hasChanged = Boolean.parseBoolean(hasChanged);
    }

    public ActiveUserService(HttpServletRequest request, String user, Account currentCenter) {
        String hasChangedPwd = request.getParameter("hasChangedPwd");
        this.hasChanged = Boolean.parseBoolean(hasChangedPwd);
        if (!this.hasChanged) {
            String passwordEn = request.getParameter("password");
            String accessKey = request.getParameter("accessKey");
            this.password = LoginUtils.getDecryptedPassword(passwordEn, user, accessKey, currentCenter.getAccountId());
        }
    }

    public Map<String, Object> customVerifyPassword() {
        Map<Object, Object> mpData = new HashMap<String, Boolean>(8);
        if (!this.hasChanged && null != (mpData = PswStrategyService.customVerifyPassword(this.password)).get(SUCCESS) && !((Boolean)mpData.get(SUCCESS)).booleanValue()) {
            return mpData;
        }
        mpData.put(SUCCESS, true);
        return mpData;
    }

    public Map<String, Object> verifyPwdByStrategy(Map<String, String> paramMap, Account currentCenter) {
        HashMap<String, Object> mpData = new HashMap<String, Object>(8);
        if (!this.hasChanged) {
            return PswStrategyService.verifyPwdByStrategy(currentCenter, Long.parseLong(paramMap.get("fid")), this.password, null);
        }
        mpData.put(SUCCESS, true);
        return mpData;
    }

    public boolean resetPassWord(Map<String, String> paramMap, LoginUserDTO loginUserDTO) {
        if (!this.hasChanged) {
            String passwordEn = PasswordEncryptUtil.getEncryptePasswordWithSalt((String)this.password, (String)LoginUtils.getCorrectUserIDSalt(paramMap.get("fid")));
            loginUserDTO.setPassword(passwordEn);
            return this.resetUserPassword(loginUserDTO);
        }
        return true;
    }

    public boolean resetUserPassword(LoginUserDTO loginUserDTO) {
        Object data = DispatchServiceHelper.invokeBOSService("ILoginUserService", "resetUserPassword", loginUserDTO);
        return "true".equals(String.valueOf(data));
    }
}

