/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.api;

import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.api.ApiRequestContext;
import kd.bos.api.internal.MessageInbound;
import kd.bos.api.internal.MessageOutbound;
import kd.bos.api.internal.ResponseDataWrapper;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.mc.tenant.AccountType;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.exception.LoginErrorCode;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.LoginClientEnum;
import kd.bos.login.api.APIErrorCode;
import kd.bos.login.api.APIKDException;
import kd.bos.login.api.APILoginError;
import kd.bos.login.api.APIMediaHandler;
import kd.bos.login.api.APIResponseDataWrapper;
import kd.bos.login.lang.LoginLangUtils;
import kd.bos.login.model.AccessTokenInfo;
import kd.bos.login.model.UserOrgsInfo;
import kd.bos.login.service.DispatchServiceHelper;
import kd.bos.login.service.impl.UpgradeAuthServiceImpl;
import kd.bos.login.service.session.SessionService;
import kd.bos.login.service.session.SessionServiceFactory;
import kd.bos.login.service.session.dto.SessionParams;
import kd.bos.login.spi.OpenApiServiceManager;
import kd.bos.login.thirdapps.AppsService;
import kd.bos.login.thirdapps.Open3rdapps;
import kd.bos.login.thirdauth.UserAccount;
import kd.bos.login.thirdauth.UserAuthResult;
import kd.bos.login.thirdauth.UserProperType;
import kd.bos.login.thirdauth.impl.SelfCreateAuth;
import kd.bos.login.user.LoginUserService;
import kd.bos.login.user.PswStrategyService;
import kd.bos.login.utils.APIUtils;
import kd.bos.login.utils.Constants;
import kd.bos.login.utils.HttpUtils;
import kd.bos.login.utils.JSONUtils;
import kd.bos.login.utils.LoginUtils;
import kd.bos.login.utils.PswStrategyUtils;
import kd.bos.login.utils.RSAUtils;
import kd.bos.login.utils.SessionUtils;
import kd.bos.login.utils.StrategeUtils;
import kd.bos.login.utils.SystemPropertyUtils;
import kd.bos.login.utils.ThirdAPIAPPUtils;
import kd.bos.login.utils.account.LoginAccountFactory;
import kd.bos.login.utils.log.LoginLogUtils;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.service.authorize.model.ApiCommonResult;
import kd.bos.service.authorize.model.ApiIpInfo;
import kd.bos.service.authorize.model.AuthTypeEnum;
import kd.bos.service.authorize.model.JwtInfo;
import kd.bos.session.SessionInfo;
import kd.bos.session.SessionManager;
import kd.bos.util.ExceptionUtils;
import kd.bos.util.HttpClientUtils;
import kd.bos.util.NetAddressUtils;
import kd.bos.util.RevProxyUtil;
import org.apache.commons.lang3.StringUtils;

public class LoginAPI {
    private static final String HEADER_DECRYPT_TYPE = "decryptType";
    private static final String DECRYPT_TYPE_RSA = "rsa";
    private static final String ACCESS_TOKEN = "access_token";
    public static final String SUCCESS = "success";
    public static final String ERROR_CODE = "error_code";
    public static final String ERROR_DESC = "error_desc";
    public static final String BOS_LOGIN = "bos-login";
    private static final String LOGIN_API_3 = "LoginAPI_3";
    private static final String LOGIN_API_0 = "LoginAPI_0";
    private static final String LOGIN_API_1 = "LoginAPI_1";
    private static final String HCODE_TENANTID = "tenantid";
    private static final String HCODE_USERID = "userid";
    private static final String USERINFO = "userinfo";
    private static final String CANT_GET_TENANT_INFO = "can not get user info\u3002";
    private static final String LOGGER_LOGIN_SUCCESS_WAITE_INFO = "get user info\u3002";
    private static final String KEY_APPSECURET_STRING = "appSecuret";
    private static final String KEY_APPSECRET_STRING = "appSecret";
    private static final String KEY_APP_ID_STRING = "appId";
    private static final String KEY_ACCOUNT_ID_STRING = "accountId";
    private static final String KEY_USER_STRING = "user";
    private static final String KEY_PASSWORD_STRING = "password";
    private static final String KEY_USERTYPE_STRING = "usertype";
    private static final String KEY_OPENID_STRING = "openid";
    private static final String KEY_TYPE_STRING = "keytype";
    private static final String DESCRIPTION = "can not get user info";
    private static final String INVOKE_MSERVICE_ERROR = " Failed to invoke microservices. The node may not be started. Pls wait.";
    public static final String JWT = "JWT";
    public static final String USER_ID = "userId";
    public static final String POST = "post";
    private static final String MC_GET_ACCESSTOKEN_IPCHECK_BY_OPENAPI = "get_accesstoken_ipcheck_by_openapi";
    private static Log logger = LogFactory.getLog(LoginAPI.class);
    private static String IS_OPEN_LOGIN_ALLOW = "is_opeid_login_allow";
    private SessionService sessionService = SessionServiceFactory.createSessionService(LoginClientEnum.API);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logout() {
        ApiRequestContext ctx = ApiRequestContext.get();
        Account account = LoginAccountFactory.createInstanceByRequestContext(Optional.empty()).getAccount();
        HttpServletRequest req = ctx.getRequest();
        HttpServletResponse resp = ctx.getResponse();
        LoginUtils.allowCrossDomain(req, resp);
        try {
            Map mapReq;
            String sPostData;
            String accessToken = ctx.getRequest().getParameter(ACCESS_TOKEN);
            if (StringUtils.isBlank((CharSequence)accessToken) && POST.equalsIgnoreCase(ctx.getRequest().getMethod()) && StringUtils.isNotBlank((CharSequence)(sPostData = ctx.getPostData())) && (mapReq = (Map)ctx.getPostData(HashMap.class)) != null) {
                accessToken = (String)mapReq.get(ACCESS_TOKEN);
            }
            if (!StringUtils.isBlank((CharSequence)accessToken)) {
                SessionParams params = new SessionParams();
                SessionInfo si = LoginUtils.getSessinInfoBySessionId(accessToken);
                params.setClientEnum(LoginClientEnum.API);
                params.setIP(si.getLoginIP());
                LoginLogUtils.addLog(account, LoginLogUtils.initLoginLogInfo(si, params, "logout"));
                SessionManager.removeSession((String)accessToken);
            }
            HashMap<String, Object> mpErpLogin = new HashMap<String, Object>();
            mpErpLogin.put(SUCCESS, true);
            mpErpLogin.put(ERROR_CODE, "0");
            mpErpLogin.put(ERROR_DESC, "");
            ctx.writeSuccess(mpErpLogin);
        }
        catch (KDException e) {
            logger.info("API\u8bf7\u6c42\u9000\u51fa\u5931\u8d25:" + e.getMessage());
            this.outputErrorMessage(ctx, e.getErrorCode().getCode(), e.getMessage());
        }
        catch (Exception ex) {
            ctx.writeError("8", String.format(ResManager.loadKDString((String)"\u672a\u77e5\u9519\u8bef\uff1a%s\u3002", (String)LOGIN_API_3, (String)BOS_LOGIN, (Object[])new Object[0]), ExceptionUtils.getExceptionStackTraceMessage((Exception)ex)));
            logger.error("API\u9000\u51fa\u767b\u5f55\u5931\u8d25:" + ex.getMessage());
        }
        finally {
            ctx.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loginout() {
        ApiRequestContext ctx = ApiRequestContext.get();
        HttpServletRequest req = ctx.getRequest();
        HttpServletResponse resp = ctx.getResponse();
        LoginUtils.allowCrossDomain(req, resp);
        try {
            Map mapReq;
            String sPostData;
            String accessToken = ctx.getRequest().getParameter(ACCESS_TOKEN);
            if (StringUtils.isBlank((CharSequence)accessToken) && POST.equalsIgnoreCase(ctx.getRequest().getMethod()) && StringUtils.isNotBlank((CharSequence)(sPostData = ctx.getPostData())) && (mapReq = (Map)ctx.getPostData(HashMap.class)) != null) {
                accessToken = (String)mapReq.get(ACCESS_TOKEN);
            }
            if (!StringUtils.isBlank((CharSequence)accessToken)) {
                SessionManager.removeSession((String)accessToken);
            }
            HashMap<String, Object> mpErpLogin = new HashMap<String, Object>();
            mpErpLogin.put(SUCCESS, true);
            mpErpLogin.put(ERROR_CODE, "0");
            mpErpLogin.put(ERROR_DESC, "");
            resp.setContentType("text/json;charset=utf-8");
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)resp.getOutputStream(), "UTF-8");
            writer.write(new ObjectMapper().writeValueAsString(mpErpLogin));
            writer.flush();
            writer.close();
        }
        catch (KDException e) {
            logger.error("API\u8bf7\u6c42\u9000\u51fa\u5931\u8d25:" + e.getMessage());
            this.outputErrorMessage(ctx, e.getErrorCode().getCode(), e.getMessage());
        }
        catch (Exception ex) {
            ctx.writeError("8", String.format(ResManager.loadKDString((String)"\u672a\u77e5\u9519\u8bef\uff1a%s\u3002", (String)LOGIN_API_3, (String)BOS_LOGIN, (Object[])new Object[0]), ExceptionUtils.getExceptionStackTraceMessage((Exception)ex)));
            logger.error("API\u9000\u51fa\u767b\u5f55\u5931\u8d25:" + ex.getMessage());
        }
        finally {
            ctx.close();
        }
    }

    public void upgradeLogin() {
        ApiRequestContext ctx = ApiRequestContext.get();
        try {
            String sPostData = ctx.getPostData();
            if (StringUtils.isBlank((CharSequence)sPostData)) {
                logger.info("2\u53c2\u6570\u9519\u8bef\uff0c\u65e0\u6cd5\u83b7\u53d6post\u6570\u636e\u3002");
                ctx.writeError("2", ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef\uff0c\u65e0\u6cd5\u83b7\u53d6post\u6570\u636e\u3002", (String)LOGIN_API_0, (String)BOS_LOGIN, (Object[])new Object[0]));
                return;
            }
            if (this.isInvokeMserviceError(ctx)) {
                ctx.writeError("8", INVOKE_MSERVICE_ERROR);
                return;
            }
            this.login4Upgrade(ctx);
        }
        catch (Exception ex) {
            ctx.writeError("8", ex.getMessage());
            logger.error((Throwable)ex);
        }
        finally {
            ctx.close();
            logger.info("\u5347\u7ea7\u670d\u52a1API\u8bf7\u6c42\u767b\u5f55\u5b8c\u6210\u3002");
        }
    }

    private boolean isInvokeMserviceError(ApiRequestContext ctx) {
        try {
            String billFormId = "pc_main_console";
            DispatchServiceHelper.invokeBOSService("FormService", "checkGuestAccess", billFormId);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getAppToken() {
        ApiRequestContext ctx = ApiRequestContext.get();
        HttpServletRequest req = ctx.getRequest();
        HttpServletResponse resp = ctx.getResponse();
        LoginUtils.allowCrossDomain(req, resp);
        try {
            String sPostData = ctx.getPostData();
            if (StringUtils.isBlank((CharSequence)sPostData)) {
                throw new KDException(APILoginError.API_REQUEST_INVALID_PARAMETERS, new Object[]{ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef\uff0c\u65e0\u6cd5\u83b7\u53d6post\u6570\u636e\u3002", (String)LOGIN_API_0, (String)BOS_LOGIN, (Object[])new Object[0])});
            }
            Map mapReq = (Map)ctx.getPostData(HashMap.class);
            if (mapReq == null) {
                throw new KDException(APILoginError.API_REQUEST_INVALID_PARAMETERS, new Object[]{ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef:\u53c2\u6570\u9700\u8981\u4ee5JSON\u683c\u5f0f\u4f20\u5165\u3002", (String)LOGIN_API_1, (String)BOS_LOGIN, (Object[])new Object[0])});
            }
            Lang lang = LoginLangUtils.getLoginLanguage(mapReq);
            LoginLangUtils.setLang(lang);
            String accountIdParameter = (String)mapReq.get(KEY_ACCOUNT_ID_STRING);
            String tenantNo = RevProxyUtil.getTenantCode((HttpServletRequest)req);
            if (StringUtils.isBlank((CharSequence)tenantNo)) {
                throw new KDException(APILoginError.API_REQUEST_INVALID_PARAMETERS, new Object[]{ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef:tenantid\u4e0d\u80fd\u83b7\u53d6\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458 \u3002", (String)"LoginAPI_2", (String)BOS_LOGIN, (Object[])new Object[0])});
            }
            String appId = (String)mapReq.get(KEY_APP_ID_STRING);
            String appSecuret = (String)mapReq.get(KEY_APPSECRET_STRING);
            if (StringUtils.isBlank((CharSequence)appSecuret)) {
                appSecuret = (String)mapReq.get(KEY_APPSECURET_STRING);
            }
            Account currentCenter = LoginAccountFactory.createInstanceByCustom(accountIdParameter, tenantNo).getAccount();
            String appToken = ThirdAPIAPPUtils.getAppToken(currentCenter, lang.name(), appId, appSecuret);
            HashMap<String, Object> mpERPLogin = new HashMap<String, Object>();
            mpERPLogin.put(SUCCESS, true);
            mpERPLogin.put(ERROR_CODE, "0");
            mpERPLogin.put(ERROR_DESC, "");
            mpERPLogin.put("app_token", appToken);
            long expireTime = this.getExpiredTime(currentCenter.getTenantId());
            mpERPLogin.put("expire_time", expireTime);
            ctx.writeSuccess(mpERPLogin);
        }
        catch (KDException e) {
            logger.info(e.getMessage());
            this.outputErrorMessage(ctx, e.getErrorCode().getCode(), e.getMessage());
        }
        catch (Exception ex) {
            ctx.writeError("8", String.format(ResManager.loadKDString((String)"\u672a\u77e5\u9519\u8bef\uff1a%s\u3002", (String)LOGIN_API_3, (String)BOS_LOGIN, (Object[])new Object[0]), ex.getMessage()));
            logger.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)ex));
        }
        finally {
            ctx.close();
        }
    }

    private void outputErrorMessage(ApiRequestContext ctx, String errorCode, String message) {
        ctx.writeError(errorCode, message);
    }

    private void outputAPIErrorMessage(ApiRequestContext ctx, APIErrorCode apiErrorCode, String message) {
        ErrorCode errorCode = apiErrorCode.getErrorCode();
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("state", "error");
        result.put("status", false);
        result.put("errorCode", errorCode.getCode());
        result.put("errorMsg", message);
        result.put("message", message);
        HashMap<String, String> errorDetails = new HashMap<String, String>();
        errorDetails.put("code", apiErrorCode.getCode());
        result.put("errorDetail", errorDetails);
        MessageInbound inbound = new MessageInbound(ctx.getRequest());
        MessageOutbound outbound = new MessageOutbound(ctx.getResponse(), (ResponseDataWrapper)APIResponseDataWrapper.instance);
        ApiRequestContext apiRequestContext = new ApiRequestContext(ctx.getRequest(), ctx.getResponse(), inbound, outbound);
        apiRequestContext.writeError("-999", JSON.toJSONString(result));
    }

    private long getExpiredTime(String tenantId) {
        LocalDateTime now = LocalDateTime.now();
        now = now.plusSeconds(ThirdAPIAPPUtils.getTokenTimeout(tenantId));
        long time2 = now.toInstant(ZoneOffset.of("+8")).toEpochMilli();
        return time2;
    }

    private void decryptParam(HttpServletRequest req, Map<String, String> mapReq) {
        String tenantNo = RevProxyUtil.getTenantCode((HttpServletRequest)req);
        String param = SystemPropertyUtils.getProptyByTenant("bos.svc.login.api.decryptParam", tenantNo);
        if (param == null) {
            param = KEY_PASSWORD_STRING;
        }
        if (req.getHeader(HEADER_DECRYPT_TYPE) != null && DECRYPT_TYPE_RSA.equals(req.getHeader(HEADER_DECRYPT_TYPE)) && mapReq.containsKey(param)) {
            String pkey;
            try {
                pkey = SystemPropertyUtils.getProptyByTenant("bos.svc.login.api.pkey", tenantNo);
            }
            catch (Exception ex) {
                throw new KDException(APILoginError.API_REQUEST_INVALID_PARAMETERS, new Object[]{String.format(ResManager.loadKDString((String)"RSA\u79c1\u94a5\u83b7\u53d6\u5931\u8d25\u3002", (String)"LoginAPI_32", (String)BOS_LOGIN, (Object[])new Object[0]), new Object[0])});
            }
            String paramValue = mapReq.get(param);
            PrivateKey privateKey = RSAUtils.getPrivateKey(pkey);
            KeyPair keyPair = new KeyPair(null, privateKey);
            String origValue = RSAUtils.decryptBase64(paramValue, keyPair);
            mapReq.put(param, origValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void login() {
        block47: {
            ApiRequestContext ctx = ApiRequestContext.get();
            HttpServletRequest req = ctx.getRequest();
            HttpServletResponse resp = ctx.getResponse();
            try {
                boolean isNew;
                LoginUtils.forcePOSTSubmitCheck(req);
                String sPostData = ctx.getPostData();
                if (StringUtils.isBlank((CharSequence)sPostData)) {
                    throw new KDException(APILoginError.API_REQUEST_INVALID_PARAMETERS, new Object[]{ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef\uff0c\u65e0\u6cd5\u83b7\u53d6post\u6570\u636e\u3002", (String)LOGIN_API_0, (String)BOS_LOGIN, (Object[])new Object[0])});
                }
                Map mapReq = (Map)ctx.getPostData(HashMap.class);
                if (mapReq == null) {
                    throw new KDException(APILoginError.API_REQUEST_INVALID_PARAMETERS, new Object[]{ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef:\u53c2\u6570\u9700\u8981\u4ee5JSON\u683c\u5f0f\u4f20\u5165\u3002", (String)LOGIN_API_1, (String)BOS_LOGIN, (Object[])new Object[0])});
                }
                this.decryptParam(req, mapReq);
                String tenantNo = RevProxyUtil.getTenantCode((HttpServletRequest)req);
                if (this.isSupportWayOfOldTenantId()) {
                    tenantNo = (String)mapReq.get(HCODE_TENANTID);
                }
                if (StringUtils.isBlank((CharSequence)tenantNo)) {
                    throw new KDException(APILoginError.API_REQUEST_INVALID_PARAMETERS, new Object[]{ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef\uff0c\u65e0\u6cd5\u83b7\u53d6\u79df\u6237ID\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"LoginAPI_4", (String)BOS_LOGIN, (Object[])new Object[0])});
                }
                Lang lang = LoginLangUtils.getLoginLanguage(mapReq);
                LoginLangUtils.setLang(lang);
                String appToken = (String)mapReq.get("apptoken");
                String appId = (String)mapReq.get(KEY_APP_ID_STRING);
                String appSecuret = (String)mapReq.get(KEY_APPSECRET_STRING);
                if (StringUtils.isBlank((CharSequence)appSecuret)) {
                    appSecuret = (String)mapReq.get(KEY_APPSECURET_STRING);
                }
                boolean bl = isNew = StringUtils.isNotBlank((CharSequence)appToken) || StringUtils.isNotBlank((CharSequence)appId) && StringUtils.isNotBlank((CharSequence)appSecuret);
                if (!isNew && this.isSupportOldInterface()) {
                    this.loginByPassword(mapReq);
                    return;
                }
                if (!isNew) {
                    throw new KDException(APILoginError.API_REQUEST_INVALID_PARAMETERS, new Object[]{ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef\uff0c\u8bf7\u8f93\u5165appToken\u3002", (String)"LoginAPI_5", (String)BOS_LOGIN, (Object[])new Object[0])});
                }
                String accountIdParameter = (String)mapReq.get(KEY_ACCOUNT_ID_STRING);
                Account currentCenter = LoginAccountFactory.createInstanceByCustom(accountIdParameter, tenantNo).getAccount();
                if (StringUtils.isNotBlank((CharSequence)appToken) && !ThirdAPIAPPUtils.checkAppTokenValidation(currentCenter, lang.name(), appToken)) {
                    throw new KDException(APILoginError.API_REQUEST_INVALID_PARAMETERS, new Object[]{ResManager.loadKDString((String)"appToken\u65e0\u6548\u6216\u5df2\u7ecf\u8fc7\u671f\u3002", (String)"LoginAPI_6", (String)BOS_LOGIN, (Object[])new Object[0])});
                }
                this.checkEnhanceToken(appToken, appId, currentCenter);
                this.checkIPForOpenApi(appToken, appId, currentCenter);
                if (StringUtils.isBlank((CharSequence)appToken)) {
                    String accountId = currentCenter.getAccountId();
                    boolean islock = StrategeUtils.checkAPPIdAndSecretErrorTimesIsLock(accountId, appId);
                    boolean isValid = this.checkAPPIdAndSecret(currentCenter, appId, appSecuret);
                    if (islock && isValid) {
                        String lockTime = LoginUtils.thirdAppIdLockTime() + "";
                        throw new APIKDException(APIErrorCode.LOCK_APPID_BUT_VALID_PASS, String.format(ResManager.loadKDString((String)"\u7b2c\u4e09\u65b9\u5e94\u7528ID\u6216\u5e94\u7528\u5bc6\u94a5\u7684\u8bbf\u95ee\u9519\u8bef\u5df2\u8fde\u7eed3\u6b21\uff0c\u8bf7\u5728%s\u79d2\u540e\u91cd\u8bd5\u3002", (String)"ThirdAPIAPPUtils_2", (String)BOS_LOGIN, (Object[])new Object[0]), lockTime));
                    }
                    if (islock) {
                        String lockTime = LoginUtils.thirdAppIdLockTime() + "";
                        throw new APIKDException(APIErrorCode.LOCK_APPID, String.format(ResManager.loadKDString((String)"\u7b2c\u4e09\u65b9\u5e94\u7528ID\u6216\u5e94\u7528\u5bc6\u94a5\u7684\u8bbf\u95ee\u9519\u8bef\u5df2\u8fde\u7eed3\u6b21\uff0c\u8bf7\u5728%s\u79d2\u540e\u91cd\u8bd5\u3002", (String)"ThirdAPIAPPUtils_2", (String)BOS_LOGIN, (Object[])new Object[0]), lockTime));
                    }
                    if (!isValid) {
                        StrategeUtils.setCheckAPPIdAndSecretErrorTimesLogic(accountId, appId);
                        throw new APIKDException(APIErrorCode.ERROR_APPID_OR_APPSECURET, ResManager.loadKDString((String)"\u7b2c\u4e09\u65b9\u5e94\u7528ID\u6216\u5e94\u7528\u5bc6\u94a5\u4e0d\u6b63\u786e\u3002", (String)"ThirdAPIAPPUtils_0", (String)BOS_LOGIN, (Object[])new Object[0]));
                    }
                    StrategeUtils.clearCheckAPPIdAndSecretErrorTimesLogic(accountId, appId);
                }
                if (APIMediaHandler.doHanleDonotNeedAuthtication(ctx)) {
                    return;
                }
                if (StringUtils.isNotBlank((CharSequence)appToken)) {
                    String appID = ThirdAPIAPPUtils.getAppIdByAppToken(currentCenter, appToken);
                    ThirdAPIAPPUtils.createApiContext(appID, currentCenter);
                } else if (StringUtils.isNotBlank((CharSequence)appId)) {
                    ThirdAPIAPPUtils.createApiContext(appId, currentCenter);
                }
                Map<String, String> userInfo = null;
                String userType = (String)mapReq.get(KEY_USERTYPE_STRING);
                String password = (String)mapReq.get(KEY_PASSWORD_STRING);
                if (StringUtils.isNotBlank((CharSequence)password)) {
                    userInfo = this.getPasswordResult(mapReq);
                } else if (APIUtils.isSupportNonPasswordUserLogin(tenantNo)) {
                    if (StringUtils.isBlank((CharSequence)userType)) {
                        userType = "Mobile";
                    }
                    if (mapReq.containsKey(KEY_USER_STRING) && StringUtils.isNotBlank((CharSequence)tenantNo)) {
                        String user = (String)mapReq.get(KEY_USER_STRING);
                        if (StringUtils.isBlank((CharSequence)user)) {
                            throw new KDException(LoginErrorCode.loginBizException, new Object[]{ResManager.loadKDString((String)"\u60a8\u7684\u8d26\u53f7\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u3002", (String)"LoginFilter_10", (String)BOS_LOGIN, (Object[])new Object[0])});
                        }
                        UserAuthResult uar = new UserAuthResult();
                        UserProperType aType = UserProperType.getUserProperTypeByString(userType);
                        if (aType == null) {
                            throw new KDException(APILoginError.API_REQUEST_INVALID_PARAMETERS, new Object[]{"usertype is wrong"});
                        }
                        uar.setUserType(aType);
                        uar.setThirdType((String)mapReq.get("thirdType"));
                        userInfo = LoginUtils.getUserInfoByUserResultByType(lang, currentCenter, uar, user, isNew);
                    }
                } else {
                    if (StringUtils.isNotBlank((CharSequence)appId)) {
                        throw new KDException(APILoginError.API_REQUEST_INVALID_PARAMETERS, new Object[]{ResManager.loadKDString((String)"AppId+user\u7684\u975e\u5bc6\u7801\u65b9\u5f0f\u4e0d\u652f\u6301\u3002", (String)"LoginAPI_33", (String)BOS_LOGIN, (Object[])new Object[0])});
                    }
                    throw new KDException(APILoginError.API_REQUEST_INVALID_PARAMETERS, new Object[]{ResManager.loadKDString((String)"\u4e0d\u652f\u6301AppToken+user\u7684\u975e\u5bc6\u7801\u767b\u5f55\u65b9\u5f0f\u3002", (String)"LoginAPI_29", (String)BOS_LOGIN, (Object[])new Object[0])});
                }
                if (mapReq.containsKey(KEY_OPENID_STRING) && userInfo == null) {
                    String sOpenID = (String)mapReq.get(KEY_OPENID_STRING);
                    if (StringUtils.isBlank((CharSequence)sOpenID)) {
                        throw new KDException(APILoginError.API_REQUEST_INVALID_PARAMETERS, new Object[]{ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef\uff0copenID\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"LoginAPI_7", (String)BOS_LOGIN, (Object[])new Object[0])});
                    }
                    userInfo = LoginUserService.getErpUserInfo(currentCenter, sOpenID, lang.name());
                }
                if (userInfo != null) {
                    String userId = userInfo.get("fid");
                    if (StringUtils.isBlank((CharSequence)userId)) {
                        throw new KDException(APILoginError.API_REQUEST_INVALID_PARAMETERS, new Object[]{ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef\uff0c\u7528\u6237\u4e0d\u5b58\u5728\u3002", (String)"LoginAPI_8", (String)BOS_LOGIN, (Object[])new Object[0])});
                    }
                    String fenable = userInfo.get("fenable");
                    if (!StringUtils.isBlank((CharSequence)fenable) && Constants.NO.equals(fenable)) {
                        throw new KDException(APILoginError.API_REQUEST_INVALID_PARAMETERS, new Object[]{ResManager.loadKDString((String)"\u7528\u6237\u5df2\u7ecf\u88ab\u7981\u7528\u3002", (String)"LoginAPI_28", (String)BOS_LOGIN, (Object[])new Object[0])});
                    }
                    String accCompanyId = (String)mapReq.get("accCompanyId");
                    if (StringUtils.isNotBlank((CharSequence)accCompanyId)) {
                        userInfo.put("accCompanyId", accCompanyId);
                    }
                    String keyType = (String)mapReq.get(KEY_TYPE_STRING);
                    String sessionId = "";
                    if (JWT.equals(keyType)) {
                        sessionId = this.generateJWTToken(appId, currentCenter.getAccountId(), tenantNo, userInfo);
                    } else {
                        SessionParams sessionParams = new SessionParams();
                        sessionParams.setClientEnum(LoginClientEnum.API);
                        sessionParams.setMpUser(userInfo);
                        sessionParams.setLang(lang);
                        sessionParams.setIP(NetAddressUtils.getRemoteHost((HttpServletRequest)req));
                        sessionParams.setCopyToClient(true);
                        sessionParams.setTimeOut(ThirdAPIAPPUtils.getTokenTimeout(currentCenter.getTenantId()));
                        sessionId = this.sessionService.getSession(req, resp, currentCenter, sessionParams);
                        if (StringUtils.isNotBlank((CharSequence)appToken)) {
                            ThirdAPIAPPUtils.setAccessAndAppTokenCach(currentCenter, sessionId, appToken);
                        }
                    }
                    HashMap<String, Object> mpERPLogin = new HashMap<String, Object>();
                    mpERPLogin.put(SUCCESS, true);
                    mpERPLogin.put(ERROR_CODE, "0");
                    mpERPLogin.put(ERROR_DESC, "");
                    mpERPLogin.put(ACCESS_TOKEN, sessionId);
                    mpERPLogin.put("expire_time", this.getExpiredTime(tenantNo));
                    ctx.writeSuccess(mpERPLogin);
                    break block47;
                }
                throw new KDException(APILoginError.API_REQUEST_INVALID_PARAMETERS, new Object[]{ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef:\u5f62\u5f0f\u5e94\u8be5\u4e3a \u7528\u6237\u8d26\u53f7\u3001appToken\u3001\u79df\u6237\u4ee3\u7801\u3001\u767b\u5f55\u7c7b\u578b\u548caccountId\u3002", (String)"LoginAPI_11", (String)BOS_LOGIN, (Object[])new Object[0])});
            }
            catch (APIKDException apiEx) {
                logger.info(apiEx.getMessage());
                this.outputAPIErrorMessage(ctx, apiEx.getApiErrorCode(), apiEx.getMessage());
            }
            catch (OpenApiException openEx) {
                logger.info(openEx.getMessage());
                this.outputErrorMessage(ctx, openEx.getCode(), openEx.getMessage());
            }
            catch (KDException e) {
                logger.info(e.getMessage());
                this.outputErrorMessage(ctx, e.getErrorCode().getCode(), e.getMessage());
            }
            catch (Exception ex) {
                logger.error((Throwable)ex);
                ctx.writeError("8", String.format(ResManager.loadKDString((String)"\u672a\u77e5\u9519\u8bef\uff1a%s\u3002", (String)LOGIN_API_3, (String)BOS_LOGIN, (Object[])new Object[0]), ExceptionUtils.getExceptionStackTraceMessage((Exception)ex)));
            }
            finally {
                ctx.close();
            }
        }
    }

    public void checkEnhanceToken(String appToken, String appId, Account currentCenter) {
        boolean enhanceToken;
        String appIdForWhiteList = appId;
        if (StringUtils.isBlank((CharSequence)appId) && StringUtils.isNotBlank((CharSequence)appToken)) {
            appIdForWhiteList = ThirdAPIAPPUtils.getAppIdByAppToken(currentCenter, appToken);
        }
        if (enhanceToken = OpenApiServiceManager.getApiAuthorizeService().isEnhanceToken(appIdForWhiteList, currentCenter.getAccountId())) {
            throw new OpenApiException(ApiErrorCode.HTTP_UNAUTHORIZED, ResManager.loadKDString((String)"\u7b2c\u4e09\u65b9\u5e94\u7528,\u5df2\u542f\u7528\u4e86\u589e\u5f3aToken\u8ba4\u8bc1\uff0c\u8bf7\u4f7f\u7528/kapi/oauth2/getToken\u63a5\u53e3\u83b7\u53d6Token\u3002", (String)"LoginAPI_40", (String)BOS_LOGIN, (Object[])new Object[0]), new Object[0]);
        }
    }

    private void checkIPForOpenApi(String appToken, String appId, Account currentCenter) {
        String checkIPFormMC = SystemPropertyUtils.getProptyByTenant(MC_GET_ACCESSTOKEN_IPCHECK_BY_OPENAPI, currentCenter.getTenantId());
        if (StringUtils.isBlank((CharSequence)checkIPFormMC) || Boolean.FALSE.toString().equals(checkIPFormMC)) {
            return;
        }
        String appIdForWhiteList = appId;
        if (StringUtils.isBlank((CharSequence)appId) && StringUtils.isNotBlank((CharSequence)appToken)) {
            appIdForWhiteList = ThirdAPIAPPUtils.getAppIdByAppToken(currentCenter, appToken);
        }
        if (StringUtils.isNotBlank((CharSequence)appIdForWhiteList)) {
            ApiIpInfo apiIpInfo = new ApiIpInfo();
            apiIpInfo.setThirdAppNumber(appIdForWhiteList);
            apiIpInfo.setIp(NetAddressUtils.getRemoteHost((HttpServletRequest)ApiRequestContext.get().getRequest()));
            apiIpInfo.setAccountId(currentCenter.getAccountId());
            ApiCommonResult apiCommonResult = OpenApiServiceManager.getApiAuthService().checkIP(apiIpInfo);
            if (apiCommonResult != null && !apiCommonResult.getStatus().booleanValue()) {
                throw new KDException(new ErrorCode(apiCommonResult.getErrorCode(), apiCommonResult.getMessage()), new Object[0]);
            }
        }
    }

    private String generateJWTToken(String appId, String accountIdParameter, String tenantId, Map<String, String> userInfo) {
        JwtInfo jwtInfo = new JwtInfo();
        jwtInfo.setAccountId(accountIdParameter);
        jwtInfo.setAuthType(AuthTypeEnum.AUTH_JWT.getId());
        jwtInfo.setTenantId(tenantId);
        jwtInfo.setThirdAppNumber(appId);
        jwtInfo.setData(userInfo);
        return OpenApiServiceManager.getApiAuthService().generateJWTToken(jwtInfo);
    }

    private boolean checkAPPIdAndSecret(Account currentCenter, String appId, String appSecuret) {
        boolean returnValue = false;
        List<Open3rdapps> allList = AppsService.getAll3rdApps(currentCenter);
        for (Open3rdapps apps : allList) {
            if (!appId.equals(apps.getNumber()) || !LoginUtils.checkPassword(appSecuret, apps.getSyspwd())) continue;
            returnValue = true;
            break;
        }
        return returnValue;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, String> getPasswordResult(Map<String, String> mapReq) {
        ApiRequestContext ctx = ApiRequestContext.get();
        HttpServletRequest req = ctx.getRequest();
        try {
            if (mapReq == null) {
                throw new KDException(APILoginError.API_REQUEST_INVALID_PARAMETERS, new Object[]{ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef:\u53c2\u6570\u9700\u8981\u4ee5JSON\u683c\u5f0f\u4f20\u5165\u3002", (String)LOGIN_API_1, (String)BOS_LOGIN, (Object[])new Object[0])});
            }
            Map<String, String> userInfo = null;
            String loginType = mapReq.get("logintype");
            if (mapReq.containsKey(KEY_USER_STRING) && mapReq.containsKey(KEY_PASSWORD_STRING)) {
                AccountType aType = AccountType.getTypeByString((String)loginType, (AccountType)AccountType.YzjPublicCloud);
                switch (aType) {
                    case YzjPublicCloud: {
                        userInfo = this.getByUserInfo(ctx, mapReq);
                        break;
                    }
                    case SelfCreate: {
                        userInfo = this.getByJDYun(ctx, mapReq);
                        break;
                    }
                    default: {
                        userInfo = this.getByJDYun(ctx, mapReq);
                    }
                }
            }
            if (userInfo != null) return userInfo;
            throw new KDException(APILoginError.API_REQUEST_INVALID_PARAMETERS, new Object[]{ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef\uff0c\u8bf7\u586b\u5199\u6b63\u786e\u7684\u7528\u6237\u8d26\u53f7\u3001\u5bc6\u7801\u3001\u767b\u5f55\u7c7b\u578b\u548c\u6570\u636e\u4e2d\u5fc3ID\u3002", (String)"LoginAPI_12", (String)BOS_LOGIN, (Object[])new Object[0])});
        }
        catch (KDException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new KDException(APILoginError.API_REQUEST_INVALID_PARAMETERS, new Object[]{ExceptionUtils.getExceptionStackTraceMessage((Exception)ex)});
        }
    }

    private boolean isSupportWayOfOldTenantId() {
        boolean isSupport = false;
        return isSupport;
    }

    private boolean isSupportOldInterface() {
        boolean isSupported = true;
        String supportString = System.getProperty("login.api.supprted.old");
        if (supportString != null && "false".equalsIgnoreCase(supportString.trim())) {
            isSupported = false;
        }
        return isSupported;
    }

    private void login4Upgrade(ApiRequestContext ctx) {
        try {
            Map req = (Map)ctx.getPostData(HashMap.class);
            Account currentCenter = LoginAccountFactory.createInstanceByPostRequest(ctx.getRequest(), ctx.getResponse(), Optional.empty()).getAccount();
            UpgradeAuthServiceImpl upgradeAuthService = new UpgradeAuthServiceImpl();
            boolean flag = upgradeAuthService.mcUpgradeAuth(currentCenter, ctx.getRequest());
            if (!flag) {
                String msg = ResManager.loadKDString((String)"\u5347\u7ea7\u670d\u52a1\u8ba4\u8bc1\u5931\u8d25\u3002", (String)"LoginAPI_100", (String)BOS_LOGIN, (Object[])new Object[0]);
                ctx.writeError("7", msg);
                return;
            }
            HashMap<String, String> user = new HashMap<String, String>();
            user.put("forgid", "0");
            user.put("fid", "0");
            user.put("ftruename", "");
            user.put("fopenid", "");
            user.put("userType", "1");
            String sessionid = SessionUtils.createNewSession4WS(currentCenter, LoginLangUtils.getLoginLanguage(req), NetAddressUtils.getRemoteHost((HttpServletRequest)ApiRequestContext.get().getRequest()), user, LoginClientEnum.API, ThirdAPIAPPUtils.getTokenTimeout(currentCenter.getTenantId()));
            HashMap<String, Object> mpERPLogin = new HashMap<String, Object>();
            mpERPLogin.put(SUCCESS, true);
            mpERPLogin.put(ERROR_CODE, "0");
            mpERPLogin.put(ERROR_DESC, "");
            mpERPLogin.put(ACCESS_TOKEN, sessionid);
            mpERPLogin.put("KERPSESSIONID", sessionid);
            ctx.writeSuccess(mpERPLogin);
        }
        catch (KDException e) {
            ErrorCode code = e.getErrorCode();
            ctx.writeError(code.getCode(), e.getMessage());
            throw e;
        }
        catch (Exception ex) {
            logger.error((Throwable)ex);
            ctx.writeError("3", ExceptionUtils.getExceptionStackTraceMessage((Exception)ex));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void loginByPassword(Map<String, String> mapReq) {
        ApiRequestContext ctx = ApiRequestContext.get();
        HttpServletRequest req = ctx.getRequest();
        HttpServletResponse resp = ctx.getResponse();
        try {
            if (mapReq == null) {
                ctx.writeError("2", ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef:\u53c2\u6570\u9700\u8981\u4ee5JSON\u683c\u5f0f\u4f20\u5165\u3002", (String)LOGIN_API_1, (String)BOS_LOGIN, (Object[])new Object[0]));
                return;
            }
            String loginType = mapReq.get("logintype");
            if (mapReq.containsKey(KEY_USER_STRING) && mapReq.containsKey(KEY_PASSWORD_STRING)) {
                AccountType aType = AccountType.getTypeByString((String)loginType, (AccountType)AccountType.YzjPublicCloud);
                switch (aType) {
                    case YzjPublicCloud: {
                        this.loginByUserInfo(ctx, mapReq);
                        return;
                    }
                    case SelfCreate: {
                        this.loginByJDYun(ctx, mapReq);
                        return;
                    }
                    default: {
                        this.loginByJDYun(ctx, mapReq);
                        return;
                    }
                }
            }
            if (LoginAPI.isOpenIDAllow() && mapReq.containsKey(KEY_OPENID_STRING)) {
                this.loginByOpenID(ctx, mapReq);
                return;
            }
            ctx.writeError("1", ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef\uff0c\u8bf7\u586b\u5199\u6b63\u786e\u7684\u7528\u6237\u8d26\u53f7\u3001\u5bc6\u7801\u3001\u79df\u6237\u4ee3\u7801\u3001\u767b\u5f55\u7c7b\u578b\u548c\u6570\u636e\u4e2d\u5fc3ID\u3002", (String)"LoginAPI_14", (String)BOS_LOGIN, (Object[])new Object[0]));
            return;
        }
        catch (KDException e) {
            logger.info(e.getMessage());
            ErrorCode code = e.getErrorCode();
            ctx.writeError(code.getCode(), e.getMessage());
            return;
        }
        catch (Exception ex) {
            ctx.writeError("8", String.format(ResManager.loadKDString((String)"\u672a\u77e5\u9519\u8bef\uff1a%s\u3002", (String)LOGIN_API_3, (String)BOS_LOGIN, (Object[])new Object[0]), ExceptionUtils.getExceptionStackTraceMessage((Exception)ex)));
            logger.error(ex.getMessage());
            return;
        }
        finally {
            ctx.close();
        }
    }

    public static boolean isOpenIDAllow() {
        String allowString;
        boolean isAllow = false;
        if (System.getProperty(IS_OPEN_LOGIN_ALLOW) != null && (allowString = System.getProperty(IS_OPEN_LOGIN_ALLOW)) != null) {
            try {
                isAllow = Boolean.parseBoolean(allowString);
            }
            catch (Exception e) {
                logger.error("isOpenIDAllow:", (Throwable)e);
            }
        }
        return isAllow;
    }

    private void loginByOpenID(ApiRequestContext ctx, Map<String, String> mpReq) {
        String sOpenID = null;
        String tenantNo = null;
        try {
            sOpenID = mpReq.get(KEY_OPENID_STRING);
            tenantNo = RevProxyUtil.getTenantCode((HttpServletRequest)ctx.getRequest());
            if (this.isSupportWayOfOldTenantId()) {
                tenantNo = mpReq.get(HCODE_TENANTID);
            }
            if (StringUtils.isBlank((CharSequence)sOpenID) || StringUtils.isBlank((CharSequence)tenantNo)) {
                ctx.writeError("1", ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef\uff0copenID\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"LoginAPI_15", (String)BOS_LOGIN, (Object[])new Object[0]));
                return;
            }
            String accountIdParameter = mpReq.get(KEY_ACCOUNT_ID_STRING);
            Account currentCenter = LoginAccountFactory.createInstanceByCustom(accountIdParameter, tenantNo).getAccount();
            Lang lang = LoginLangUtils.getLang(mpReq.get("language"));
            Map<String, String> mpErpUser = LoginUserService.getErpUserInfo(currentCenter, sOpenID, lang.name());
            String sessionid = null;
            if ("0".equals(mpErpUser.get(SUCCESS))) {
                logger.error(String.format("\u65e0\u6cd5\u83b7\u53d6\u79df\u6237\u4e2d\u6307\u5b9a\u7528\u6237\u7684\u767b\u5f55\u4fe1\u606f\uff0c\u79df\u6237=%s,\u7528\u6237Openid=%s\u3002", tenantNo, sOpenID));
                ctx.writeError("6", ResManager.loadKDString((String)"\u60a8\u7684\u8d26\u53f7\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"LoginAPI_16", (String)BOS_LOGIN, (Object[])new Object[0]));
                return;
            }
            boolean isProd = true;
            sessionid = SessionUtils.createNewSession4WS(currentCenter, LoginLangUtils.getLoginLanguage(mpReq), NetAddressUtils.getRemoteHost((HttpServletRequest)ApiRequestContext.get().getRequest()), mpErpUser, LoginClientEnum.API, ThirdAPIAPPUtils.getTokenTimeout(currentCenter.getTenantId()));
            if (StringUtils.isBlank((CharSequence)sessionid)) {
                ctx.writeError("7", ResManager.loadKDString((String)"\u767b\u5f55\u5931\u8d25\uff0c\u65e0\u6cd5\u521b\u5efa\u7cfb\u7edf\u4f1a\u8bdd\u4fe1\u606f\u3002", (String)"LoginAPI_17", (String)BOS_LOGIN, (Object[])new Object[0]));
                return;
            }
            HashMap<String, Object> mpERPLogin = new HashMap<String, Object>();
            mpERPLogin.put(SUCCESS, true);
            mpERPLogin.put(ERROR_CODE, "0");
            mpERPLogin.put(ERROR_DESC, "");
            mpERPLogin.put(ACCESS_TOKEN, sessionid);
            mpERPLogin.put("KERPSESSIONID", sessionid);
            ctx.writeSuccess(mpERPLogin);
        }
        catch (KDException e) {
            ErrorCode code = e.getErrorCode();
            ctx.writeError(code.getCode(), e.getMessage());
            throw e;
        }
        catch (Exception ex) {
            ctx.writeError("3", ExceptionUtils.getExceptionStackTraceMessage((Exception)ex));
            throw ex;
        }
    }

    private void loginByJDYun(ApiRequestContext ctx, Map<String, String> mpReq) {
        String sUserNum = null;
        String sPassword = null;
        String tenantId = null;
        try {
            sUserNum = mpReq.get(KEY_USER_STRING);
            sPassword = mpReq.get(KEY_PASSWORD_STRING);
            tenantId = RevProxyUtil.getTenantCode((HttpServletRequest)ctx.getRequest());
            if (this.isSupportWayOfOldTenantId()) {
                tenantId = mpReq.get(HCODE_TENANTID);
            }
            Lang lang = LoginLangUtils.getLoginLanguage(mpReq);
            LoginLangUtils.setLang(lang);
            if (StringUtils.isBlank((CharSequence)sUserNum) || StringUtils.isBlank((CharSequence)sPassword)) {
                logger.error("\u8bf7\u6c42\u53c2\u6570\u9519\u8bef\uff0c\u7528\u6237\u540d\u3001\u5bc6\u7801\u3001\u79df\u6237\u5fc5\u987b\u5168\u90e8\u8f93\u5165\u3002");
                ctx.writeError("1", ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef\uff0c\u7528\u6237\u540d\u548c\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"LoginAPI_18", (String)BOS_LOGIN, (Object[])new Object[0]));
                return;
            }
            String accountIdParameter = mpReq.get(KEY_ACCOUNT_ID_STRING);
            Account currentCenter = LoginAccountFactory.createInstanceByCustom(accountIdParameter, tenantId).getAccount();
            Map<String, String> userInfo = LoginUserService.getErpUserInfoByPhone(currentCenter, sUserNum, lang.name());
            if (userInfo != null && userInfo.size() == 0) {
                userInfo = LoginUserService.getErpUserInfoByUserName(currentCenter, sUserNum, lang.name());
            }
            if (userInfo != null && !userInfo.containsKey("fid")) {
                userInfo = LoginUserService.getErpUserInfoByEmail(currentCenter, sUserNum, lang.name());
            }
            if (userInfo == null || userInfo.size() == 0) {
                LoginUtils.checkUserEnable(currentCenter, sUserNum);
                throw new APIKDException(APIErrorCode.ERROR_USER_OR_PASSWD, ResManager.loadKDString((String)"\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef\u3002", (String)"LoginAction_10", (String)BOS_LOGIN, (Object[])new Object[0]));
            }
            String userId = userInfo.get("fid");
            if (StringUtils.isBlank((CharSequence)userId)) {
                throw new APIKDException(APIErrorCode.ERROR_USER_OR_PASSWD, ResManager.loadKDString((String)"\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef\u3002", (String)"LoginAction_10", (String)BOS_LOGIN, (Object[])new Object[0]));
            }
            PswStrategyUtils.isLocked(currentCenter, userId);
            UserAuthResult uar = SelfCreateAuth.loginByUserAndPassword(sUserNum, sPassword, currentCenter, userInfo);
            if (uar == null || uar.getUserType() == UserProperType.Unknown || !uar.isSucess()) {
                String resp = ResManager.loadKDString((String)"\u7cfb\u7edf\u65e0\u6cd5\u9a8c\u8bc1\u8d26\u53f7\u4fe1\u606f\u3002", (String)"LoginAPI_19", (String)BOS_LOGIN, (Object[])new Object[0]);
                if (uar != null && !StringUtils.isBlank((CharSequence)uar.getErrDesc())) {
                    resp = uar.getErrDesc();
                }
                PswStrategyService.insertDefaultPSW(currentCenter);
                StrategeUtils.addPasswordWrongTimes(currentCenter, userId, LoginClientEnum.WEB.toString());
                resp = PswStrategyService.handleAfterLogon(currentCenter, Long.parseLong(userInfo.get(HCODE_USERID)), false, NetAddressUtils.getRemoteHost((HttpServletRequest)ctx.getRequest()));
                throw new APIKDException(APIErrorCode.ERROR_USER_OR_PASSWD_DEPRECATED, resp);
            }
            String verifyPSWStrategyMsg = PswStrategyUtils.verifyPSWStrategy(currentCenter, Long.parseLong(userId), sPassword);
            if (StringUtils.isNotBlank((CharSequence)verifyPSWStrategyMsg)) {
                throw new KDException(APILoginError.API_REQUEST_INVALID_PARAMETERS, new Object[]{verifyPSWStrategyMsg});
            }
            PswStrategyService.handleAfterLogon(currentCenter, Long.parseLong(userInfo.get(HCODE_USERID)), true, NetAddressUtils.getRemoteHost((HttpServletRequest)ctx.getRequest()));
            String sessionid = "";
            if (userInfo != null) {
                sessionid = SessionUtils.createNewSession(ApiRequestContext.get().getRequest(), ApiRequestContext.get().getResponse(), currentCenter, lang, NetAddressUtils.getRemoteHost((HttpServletRequest)ApiRequestContext.get().getRequest()), userInfo, LoginClientEnum.API);
            }
            HashMap<String, Object> mpERPLogin = new HashMap<String, Object>();
            mpERPLogin.put(SUCCESS, true);
            mpERPLogin.put(ERROR_CODE, "0");
            mpERPLogin.put(ERROR_DESC, "");
            mpERPLogin.put(ACCESS_TOKEN, sessionid);
            mpERPLogin.put("KERPSESSIONID", sessionid);
            ctx.writeSuccess(mpERPLogin);
        }
        catch (KDException e) {
            throw e;
        }
        catch (Exception ex) {
            logger.error((Throwable)ex);
            ctx.writeError("3", ExceptionUtils.getExceptionStackTraceMessage((Exception)ex));
        }
    }

    private Map<String, String> getByJDYun(ApiRequestContext ctx, Map<String, String> mpReq) {
        String sUserNum = null;
        String sPassword = null;
        String tenantId = null;
        try {
            sUserNum = mpReq.get(KEY_USER_STRING);
            sPassword = mpReq.get(KEY_PASSWORD_STRING);
            tenantId = RevProxyUtil.getTenantCode((HttpServletRequest)ctx.getRequest());
            if (this.isSupportWayOfOldTenantId()) {
                tenantId = mpReq.get(HCODE_TENANTID);
            }
            Lang lang = LoginLangUtils.getLoginLanguage(mpReq);
            LoginLangUtils.setLang(lang);
            if (StringUtils.isBlank((CharSequence)sUserNum) || StringUtils.isBlank((CharSequence)sPassword)) {
                logger.error("\u8bf7\u6c42\u53c2\u6570\u9519\u8bef\uff0c\u7528\u6237\u540d\u3001\u5bc6\u7801\u3001\u79df\u6237\u5fc5\u987b\u5168\u90e8\u8f93\u5165\u3002");
                throw new KDException(new ErrorCode("1", ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef\uff0c\u7528\u6237\u540d\u548c\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"LoginAPI_18", (String)BOS_LOGIN, (Object[])new Object[0])), new Object[0]);
            }
            String accountIdParameter = mpReq.get(KEY_ACCOUNT_ID_STRING);
            Account currentCenter = LoginAccountFactory.createInstanceByCustom(accountIdParameter, tenantId).getAccount();
            UserAccount userAccount = new UserAccount(sUserNum, sPassword);
            Map<String, Object> userInfo = StrategeUtils.getUserId(ctx.getRequest(), sUserNum, currentCenter);
            String userId = null;
            if (userInfo == null || userInfo.size() == 0 || userInfo.get(USER_ID) == null) {
                LoginUtils.checkUserEnable(currentCenter, sUserNum);
                throw new APIKDException(APIErrorCode.ERROR_USER_OR_PASSWD, ResManager.loadKDString((String)"\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef\u3002", (String)"LoginAction_10", (String)BOS_LOGIN, (Object[])new Object[0]));
            }
            userId = userInfo.get(USER_ID).toString();
            PswStrategyUtils.isLocked(currentCenter, userId);
            UserAuthResult uar = SelfCreateAuth.loginByUserAndPassword(userAccount, currentCenter);
            if (uar == null || uar.getUserType() == UserProperType.Unknown || !uar.isSucess()) {
                String resp = ResManager.loadKDString((String)"\u7cfb\u7edf\u65e0\u6cd5\u9a8c\u8bc1\u8d26\u53f7\u4fe1\u606f\u3002", (String)"LoginAPI_19", (String)BOS_LOGIN, (Object[])new Object[0]);
                if (uar != null && !StringUtils.isBlank((CharSequence)uar.getErrDesc())) {
                    resp = uar.getErrDesc();
                }
                StrategeUtils.addPasswordWrongTimes(currentCenter, userId, LoginClientEnum.WEB.toString());
                resp = PswStrategyService.handleAfterLogon(currentCenter, Long.parseLong(userId), false, NetAddressUtils.getRemoteHost((HttpServletRequest)ctx.getRequest()));
                throw new APIKDException(APIErrorCode.ERROR_USER_OR_PASSWD_DEPRECATED, resp);
            }
            String verifyPSWStrategyMsg = PswStrategyUtils.verifyPSWStrategy(currentCenter, Long.parseLong(userId), sPassword);
            if (StringUtils.isNotBlank((CharSequence)verifyPSWStrategyMsg)) {
                throw new KDException(LoginErrorCode.loginBizException, new Object[]{verifyPSWStrategyMsg});
            }
            PswStrategyService.handleAfterLogon(currentCenter, Long.parseLong(userId), true, NetAddressUtils.getRemoteHost((HttpServletRequest)ctx.getRequest()));
            String user = String.valueOf(uar.getUser());
            Map<String, String> userResult = LoginUtils.getUserInfoByUserResult(lang, currentCenter, uar, user);
            return userResult;
        }
        catch (KDException e) {
            throw e;
        }
        catch (Exception ex) {
            ctx.writeError("3", ExceptionUtils.getExceptionStackTraceMessage((Exception)ex));
            throw ex;
        }
    }

    private void loginByUserInfo(ApiRequestContext ctx, Map<String, String> mpReq) {
        String sUserNum = null;
        String sPassword = null;
        String tenantId = null;
        try {
            sUserNum = mpReq.get(KEY_USER_STRING);
            sPassword = mpReq.get(KEY_PASSWORD_STRING);
            tenantId = RevProxyUtil.getTenantCode((HttpServletRequest)ctx.getRequest());
            if (this.isSupportWayOfOldTenantId()) {
                tenantId = mpReq.get(HCODE_TENANTID);
            }
            Lang lang = LoginLangUtils.getLoginLanguage(mpReq);
            LoginLangUtils.setLang(lang);
            if (StringUtils.isBlank((CharSequence)sUserNum) || StringUtils.isBlank((CharSequence)sPassword)) {
                logger.error("\u8bf7\u6c42\u53c2\u6570\u9519\u8bef\uff0c\u5e94\u8be5\u4e3a\u4e09\u4e2a\u53c2\u6570\u6216\u8005\u90e8\u5206\u53c2\u6570\u6ca1\u6709\u8d4b\u503c\u3002");
                ctx.writeError("1", ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef\uff0c\u7528\u6237\u540d\u548c\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"LoginAPI_20", (String)BOS_LOGIN, (Object[])new Object[0]));
                return;
            }
            Map<String, Object> mpYTXZ = LoginAPI.getYTXZAccessToken(sUserNum, sPassword);
            if (!((Boolean)mpYTXZ.get(SUCCESS)).booleanValue()) {
                ctx.writeSuccess(mpYTXZ);
                return;
            }
            String sAccessToken = mpYTXZ.get(ACCESS_TOKEN).toString();
            long userid = Long.parseLong(mpYTXZ.get("uid").toString());
            Map<String, Object> mpUserLogininfo = this.getUserLoginInfo(ctx.getRequest(), sAccessToken, userid, lang.name());
            String sessionid = null;
            if (!((Boolean)mpUserLogininfo.get(SUCCESS)).booleanValue()) {
                logger.error(String.format("\u65e0\u6cd5\u83b7\u53d6\u79df\u6237\u4e2d\u6307\u5b9a\u7528\u6237\u7684\u767b\u5f55\u4fe1\u606f\uff0c\u79df\u6237=%s,\u7528\u6237=%s\u3002", tenantId, userid));
                ctx.writeSuccess(mpUserLogininfo);
                return;
            }
            String accountIdParameter = mpReq.get(KEY_ACCOUNT_ID_STRING);
            Account currentCenter = LoginAccountFactory.createInstanceByCustom(accountIdParameter, tenantId).getAccount();
            sessionid = SessionUtils.createNewSession4WS(currentCenter, lang, NetAddressUtils.getRemoteHost((HttpServletRequest)ApiRequestContext.get().getRequest()), (Map)mpUserLogininfo.get(USERINFO), LoginClientEnum.API, ThirdAPIAPPUtils.getTokenTimeout(currentCenter.getTenantId()));
            if (StringUtils.isBlank((CharSequence)sessionid)) {
                ctx.writeError("7", "Unable to create session information of ERP system.");
                return;
            }
            HashMap<String, Object> mpERPLogin = new HashMap<String, Object>();
            mpERPLogin.put(SUCCESS, true);
            mpERPLogin.put(ERROR_CODE, "0");
            mpERPLogin.put(ERROR_DESC, "");
            mpERPLogin.put(ACCESS_TOKEN, sessionid);
            mpERPLogin.put("KERPSESSIONID", sessionid);
            ctx.writeSuccess(mpERPLogin);
        }
        catch (KDException e) {
            ErrorCode code = e.getErrorCode();
            ctx.writeError(code.getCode(), e.getMessage());
            throw e;
        }
        catch (Exception ex) {
            ctx.writeError("3", ExceptionUtils.getExceptionStackTraceMessage((Exception)ex));
            throw new KDException(LoginErrorCode.loginBizException, new Object[]{ex.getMessage()});
        }
    }

    private Map<String, String> getByUserInfo(ApiRequestContext ctx, Map<String, String> mpReq) {
        String sUserNum = null;
        String sPassword = null;
        String tenantId = null;
        try {
            sUserNum = mpReq.get(KEY_USER_STRING);
            sPassword = mpReq.get(KEY_PASSWORD_STRING);
            tenantId = RevProxyUtil.getTenantCode((HttpServletRequest)ctx.getRequest());
            if (this.isSupportWayOfOldTenantId()) {
                tenantId = mpReq.get(HCODE_TENANTID);
            }
            Lang lang = LoginLangUtils.getLoginLanguage(mpReq);
            LoginLangUtils.setLang(lang);
            if (StringUtils.isBlank((CharSequence)sUserNum) || StringUtils.isBlank((CharSequence)sPassword)) {
                throw new KDException(APILoginError.API_REQUEST_INVALID_PARAMETERS, new Object[]{ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef\uff0c\u7528\u6237\u540d\u548c\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"LoginAPI_20", (String)BOS_LOGIN, (Object[])new Object[0])});
            }
            Map<String, Object> mpYTXZ = LoginAPI.getYTXZAccessToken(sUserNum, sPassword);
            if (!((Boolean)mpYTXZ.get(SUCCESS)).booleanValue()) {
                logger.error(mpYTXZ.toString());
                throw new KDException(APILoginError.API_REQUEST_INVALID_PARAMETERS, new Object[]{"Unable to acquire Cloud passport, returned Map is null. "});
            }
            String sAccessToken = mpYTXZ.get(ACCESS_TOKEN).toString();
            long userid = Long.parseLong(mpYTXZ.get("uid").toString());
            Map<String, String> mpUserLogininfo = this.getNewUserLoginInfo(sAccessToken, userid, tenantId, lang.name());
            return mpUserLogininfo;
        }
        catch (KDException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new KDException(LoginErrorCode.loginBizException, new Object[]{ex.getMessage()});
        }
    }

    public static Map<String, Object> getYTXZAccessToken(String userNum, String password) throws IOException {
        HashMap<String, Object> mpYTXZ = new HashMap<String, Object>();
        String ytxzHost = System.getProperty("YTXZHost");
        String ytxzClient_ID = System.getProperty("YTXZClient_ID");
        String ytxzClient_Secret = System.getProperty("YTXZClient_Secret");
        HashMap<String, String> mpHeader = new HashMap<String, String>();
        mpHeader.put("Content-Type", "application/x-www-form-urlencoded");
        HashMap<String, String> mpBody = new HashMap<String, String>();
        mpBody.put("username", userNum);
        mpBody.put(KEY_PASSWORD_STRING, password);
        mpBody.put("client_id", ytxzClient_ID);
        mpBody.put("client_secret", ytxzClient_Secret);
        String sURL = ytxzHost + "/" + "auth/user/access_token";
        String jsonTxzAccessToken = HttpClientUtils.post((String)sURL, mpHeader, mpBody);
        if (StringUtils.isBlank((CharSequence)jsonTxzAccessToken)) {
            mpYTXZ.put(SUCCESS, false);
            mpYTXZ.put(ERROR_CODE, "3");
            mpYTXZ.put(ERROR_DESC, ResManager.loadKDString((String)"\u65e0\u6cd5\u83b7\u53d6\u4e91\u901a\u884c\u8bc1AccessToken\uff0c\u539f\u56e0\uff1a\u8fdc\u7a0b\u670d\u52a1\u4e0d\u53ef\u7528\uff0c\u6216\u8005\u7528\u6237\u540d\u4e0e\u5bc6\u7801\u4e0d\u5339\u914d\u3002", (String)"LoginAPI_23", (String)BOS_LOGIN, (Object[])new Object[0]));
            mpYTXZ.put(ACCESS_TOKEN, "");
            mpYTXZ.put("uid", "0");
            return mpYTXZ;
        }
        AccessTokenInfo ati = JSONUtils.cast(jsonTxzAccessToken, AccessTokenInfo.class, true);
        if (ati == null || ati.getData() == null || ati.getErrcode() != 0) {
            mpYTXZ.put(SUCCESS, false);
            mpYTXZ.put(ERROR_CODE, "3");
            mpYTXZ.put(ERROR_DESC, ResManager.loadKDString((String)"\u65e0\u6cd5\u83b7\u53d6\u4e91\u901a\u884c\u8bc1AccessToken\uff0c\u539f\u56e0\uff1a\u8fdc\u7a0b\u670d\u52a1\u4e0d\u53ef\u7528\uff0c\u6216\u8005\u7528\u6237\u540d\u4e0e\u5bc6\u7801\u4e0d\u5339\u914d\u3002", (String)"LoginAPI_23", (String)BOS_LOGIN, (Object[])new Object[0]));
            mpYTXZ.put(ACCESS_TOKEN, "");
            mpYTXZ.put("uid", 0);
            return mpYTXZ;
        }
        mpYTXZ.put(SUCCESS, true);
        mpYTXZ.put(ERROR_CODE, "0");
        mpYTXZ.put(ERROR_DESC, "");
        mpYTXZ.put(ACCESS_TOKEN, ati.getData().getAccess_token());
        mpYTXZ.put("uid", ati.getData().getUid());
        return mpYTXZ;
    }

    private Map<String, Object> getUserLoginInfo(HttpServletRequest request, String accessToken, long userID, String language) throws IOException {
        HashMap<String, Object> mpUserAccessToken = new HashMap<String, Object>(8);
        String ytxzHost = System.getProperty("YTXZHost");
        String sURL = ytxzHost + "/" + "passport/user/orgs" + "?access_token=" + accessToken;
        String jsonTxzUserOrgs = HttpUtils.request(sURL, "GET", null);
        if (StringUtils.isBlank((CharSequence)jsonTxzUserOrgs)) {
            mpUserAccessToken.put(SUCCESS, false);
            mpUserAccessToken.put(ERROR_CODE, "5");
            mpUserAccessToken.put(ERROR_DESC, ResManager.loadKDString((String)"\u65e0\u6cd5\u83b7\u53d6\u7528\u6237\u7684\u4e91\u4e4b\u5bb6\u5de5\u4f5c\u5708\u3002", (String)"LoginAPI_24", (String)BOS_LOGIN, (Object[])new Object[0]));
            mpUserAccessToken.put(ACCESS_TOKEN, "");
            mpUserAccessToken.put(USERINFO, null);
            return mpUserAccessToken;
        }
        UserOrgsInfo orgsInfo = JSONUtils.cast(jsonTxzUserOrgs, UserOrgsInfo.class, true);
        if (orgsInfo == null || orgsInfo.getData() == null || orgsInfo.getErrcode() != 0) {
            mpUserAccessToken.put(SUCCESS, false);
            mpUserAccessToken.put(ERROR_CODE, "5");
            mpUserAccessToken.put(ERROR_DESC, "Failed to acquire work cycle of Cloud Hub joined by the user.");
            mpUserAccessToken.put(ACCESS_TOKEN, "");
            mpUserAccessToken.put(USERINFO, null);
            return mpUserAccessToken;
        }
        Account currentCenter = LoginAccountFactory.createInstanceByHttpRequest(request, Optional.empty()).getAccount();
        Map<String, String> mpErpUser = LoginUserService.getErpUserInfo(currentCenter, userID, language);
        if (mpErpUser == null || mpErpUser.size() == 0) {
            mpUserAccessToken.put(SUCCESS, false);
            mpUserAccessToken.put(ERROR_CODE, "6");
            mpUserAccessToken.put(ERROR_DESC, CANT_GET_TENANT_INFO);
            mpUserAccessToken.put(ACCESS_TOKEN, "");
            mpUserAccessToken.put(USERINFO, null);
            return mpUserAccessToken;
        }
        if ("1".equalsIgnoreCase(mpErpUser.get(SUCCESS))) {
            mpUserAccessToken.put(SUCCESS, true);
            mpUserAccessToken.put(ERROR_CODE, 0);
            mpUserAccessToken.put(ERROR_DESC, "");
            mpUserAccessToken.put(ACCESS_TOKEN, "");
            mpUserAccessToken.put(USERINFO, mpErpUser);
        } else {
            mpUserAccessToken.put(SUCCESS, false);
            mpUserAccessToken.put(ERROR_CODE, "6");
            mpUserAccessToken.put(ERROR_DESC, CANT_GET_TENANT_INFO);
            mpUserAccessToken.put(ACCESS_TOKEN, "");
            mpUserAccessToken.put(USERINFO, null);
            logger.error(DESCRIPTION);
        }
        return mpUserAccessToken;
    }

    private Map<String, String> getNewUserLoginInfo(String accessToken, long userID, String tenantId, String language) throws IOException {
        Account currentCenter;
        Map<String, String> mpErpUser;
        String ytxzHost = System.getProperty("YTXZHost");
        String sURL = ytxzHost + "/" + "passport/user/orgs" + "?access_token=" + accessToken;
        String jsonTxzUserOrgs = HttpUtils.request(sURL, "GET", null);
        if (StringUtils.isBlank((CharSequence)jsonTxzUserOrgs)) {
            throw new KDException(new ErrorCode("5", ResManager.loadKDString((String)"\u65e0\u6cd5\u83b7\u53d6\u7528\u6237\u7684\u4e91\u4e4b\u5bb6\u5de5\u4f5c\u5708\u3002", (String)"LoginAPI_24", (String)BOS_LOGIN, (Object[])new Object[0])), new Object[0]);
        }
        UserOrgsInfo orgsInfo = JSONUtils.cast(jsonTxzUserOrgs, UserOrgsInfo.class, true);
        if (orgsInfo == null || orgsInfo.getData() == null || orgsInfo.getErrcode() != 0) {
            throw new KDException(new ErrorCode("5", "Failed to acquire work cycle of Cloud Hub joined by the user."), new Object[0]);
        }
        if (orgsInfo.getData().size() > 0) {
            logger.info(LOGGER_LOGIN_SUCCESS_WAITE_INFO);
        }
        if ((mpErpUser = LoginUserService.getErpUserInfo(currentCenter = LoginAccountFactory.createInstanceByDefault(tenantId).getAccount(), userID, language)) == null || mpErpUser.size() == 0) {
            throw new KDException(new ErrorCode("6", CANT_GET_TENANT_INFO), new Object[0]);
        }
        if (!"1".equalsIgnoreCase(mpErpUser.get(SUCCESS))) {
            throw new KDException(new ErrorCode("6", DESCRIPTION), new Object[0]);
        }
        return mpErpUser;
    }
}

