/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.cloudcommunity;

import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import kd.bos.cloudcommunity.api.CloudCommunityService;
import kd.bos.dc.api.model.Account;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.LoginClientEnum;
import kd.bos.login.cloudcommunity.CloudDeveloperTokenFetch;
import kd.bos.login.cloudcommunity.CloudDeveloperUserFetch;
import kd.bos.login.handler.impl.auth.CloudDeveloperAuthHandler;
import kd.bos.login.lang.LoginLangUtils;
import kd.bos.login.user.LoginUserService;
import kd.bos.login.utils.SessionUtils;
import kd.bos.login.utils.SystemPropertyUtils;
import kd.bos.login.utils.account.LoginAccountFactory;
import kd.bos.service.ServiceFactory;
import kd.bos.session.SessionDAO;
import kd.bos.session.SessionDAOFactory;
import kd.bos.util.NetAddressUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class CloudDeveloperManage {
    private static Log logger = LogFactory.getLog(CloudDeveloperAuthHandler.class);
    public static final String CLIENT_REQUEST_TAG_DEVELOPER_CODE = "developerCode";
    private static final String DEFAULT_DEVELOPER_COMMON_MOBILE = "17299999999";
    private static final String SESSIONKEY_DEVELOPER_UID = "developer_uid";
    private static final String APPCACHE_KEY_CLOUD_DEVELOPER = "cloudDeveloper";
    private HttpServletRequest request;
    private String developerCode;
    private CloudCommunityService cloudCommunityService;

    public static boolean isMatch(HttpServletRequest request) {
        String developerCode = request.getParameter(CLIENT_REQUEST_TAG_DEVELOPER_CODE);
        if (StringUtils.isBlank((CharSequence)developerCode)) {
            return false;
        }
        try {
            ServiceFactory.getService(CloudCommunityService.class);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public CloudDeveloperManage(HttpServletRequest request) {
        this.request = request;
        this.developerCode = request.getParameter(CLIENT_REQUEST_TAG_DEVELOPER_CODE);
        this.cloudCommunityService = (CloudCommunityService)ServiceFactory.getService(CloudCommunityService.class);
    }

    public boolean doLogin() throws Exception {
        String code = this.request.getParameter("code");
        logger.info(String.format("CloudDeveloperManage-Message: cloud community code is %s", code));
        if (StringUtils.isBlank((CharSequence)code)) {
            return false;
        }
        String accessToken = CloudDeveloperTokenFetch.getAccessToken(code, this.request);
        logger.info(String.format("CloudDeveloperManage-Message: cloud community token is %s", accessToken));
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            return false;
        }
        CloudDeveloperUserFetch.UserData userInfo = CloudDeveloperUserFetch.getUserInfo(accessToken);
        if (userInfo == null) {
            return false;
        }
        logger.info(String.format("CloudDeveloperManage-Message: cloud community userInfo is %s", userInfo.toString()));
        this.cloudCommunityService.save(userInfo.convertCommunityUser());
        Account currentCenter = LoginAccountFactory.createInstanceByHttpRequest(this.request, Optional.empty()).getAccount();
        String session = this.createSession(currentCenter, userInfo.getUid());
        logger.info(String.format("CloudDeveloperManage-Message: cloud community session is %s", session));
        IAppCache cloudDeveloperCache = AppCache.get((String)APPCACHE_KEY_CLOUD_DEVELOPER);
        int sessionTimeout = SessionDAO.getSessionTimeout((String)currentCenter.getTenantId());
        cloudDeveloperCache.put(this.developerCode, (Object)session, sessionTimeout);
        return true;
    }

    private String createSession(Account currentCenter, long uid) {
        Lang lang;
        Map<String, String> userInfo;
        String mobile = SystemPropertyUtils.getProptyByTenant("login_cloud_developer_mobile", currentCenter.getTenantId());
        if (StringUtils.isBlank((CharSequence)mobile)) {
            mobile = DEFAULT_DEVELOPER_COMMON_MOBILE;
        }
        if (MapUtils.isEmpty(userInfo = LoginUserService.getErpUserInfoByPhone(currentCenter, mobile, (lang = LoginLangUtils.getLoginLanguage(this.request)).name()))) {
            throw new RuntimeException(String.format("No user found with mobile number: %s", mobile));
        }
        LoginClientEnum loginClient = LoginClientEnum.CLOUD_DEVELOPER;
        String sessionId = SessionUtils.createNewSession(this.request, null, currentCenter, lang, NetAddressUtils.getRemoteHost((HttpServletRequest)this.request), userInfo, loginClient);
        SessionDAO sessionDAO = SessionDAOFactory.getSessionDAO((String)sessionId);
        sessionDAO.setAttribute(SESSIONKEY_DEVELOPER_UID, String.valueOf(uid));
        return sessionId;
    }
}

