/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.cloudcommunity;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.cloudcommunity.CloudDeveloperHttpService;
import kd.bos.login.handler.impl.auth.CloudDeveloperAuthHandler;

class CloudDeveloperTokenFetch {
    private static Log logger = LogFactory.getLog(CloudDeveloperAuthHandler.class);
    private static final String DEFAULT_CONFIG_FILE = "cloud_developer.properties";

    CloudDeveloperTokenFetch() {
    }

    public static String getAccessToken(String code, HttpServletRequest request) throws Exception {
        Builder builder = new Builder();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("grant_type", "authorization_code");
        params.put("code", code);
        params.put("redirect_uri", request.getRequestURL().toString() + "?" + request.getQueryString());
        params.put("client_id", builder.clientId);
        params.put("client_secret", builder.clientSecret);
        String tokenUrl = builder.tokenUrl;
        logger.info(String.format("CloudDeveloperTokenFetch-Message: getAccessToken params is %s", ((Object)params).toString()));
        String responseBody = CloudDeveloperHttpService.sendPostRequest(tokenUrl, params);
        logger.info(String.format("CloudDeveloperTokenFetch-Message: getAccessToken responseBody is %s", responseBody));
        return CloudDeveloperTokenFetch.parseAccessToken(responseBody);
    }

    private static String parseAccessToken(String jsonString) {
        JSONObject jsonObject = JSONObject.parseObject((String)jsonString);
        if (!jsonObject.containsKey((Object)"data")) {
            throw new RuntimeException("Data node is missing");
        }
        JSONObject dataObject = jsonObject.getJSONObject("data");
        if (!dataObject.containsKey((Object)"access_token")) {
            throw new RuntimeException("Access token is missing");
        }
        return dataObject.getString("access_token");
    }

    private static class Builder {
        private String configFile = "cloud_developer.properties";
        private String tokenUrl;
        private String clientId;
        private String clientSecret;

        public Builder() {
            this.loadProperties();
        }

        private void loadProperties() {
            Properties props = new Properties();
            try (InputStream in = CloudDeveloperTokenFetch.class.getClassLoader().getResourceAsStream(this.configFile);){
                props.load(in);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to load config file: " + this.configFile, e);
            }
            this.tokenUrl = props.getProperty("token_url");
            this.clientId = props.getProperty("client_id");
            this.clientSecret = props.getProperty("client_secret");
        }
    }
}

