/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.cloudcommunity;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.annotation.JSONField;
import java.io.IOException;
import kd.bos.cloudcommunity.api.CommunityUser;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.cloudcommunity.CloudDeveloperHttpService;

class CloudDeveloperUserFetch {
    private static Log logger = LogFactory.getLog(CloudDeveloperUserFetch.class);
    private static final String API_BASE_URL = "https://api.kingdee.com";

    CloudDeveloperUserFetch() {
    }

    public static UserData getUserInfo(String accessToken) {
        String urlString = "https://api.kingdee.com/passport/user?access_token=" + accessToken;
        try {
            logger.info(String.format("CloudDeveloperUserFetch-Message: getUserInfo url is %s", urlString));
            String responseBody = CloudDeveloperHttpService.sendGetRequest(urlString);
            logger.info(String.format("CloudDeveloperUserFetch-Message: getUserInfo responseBody is %s", responseBody));
            ApiResponse apiResponse = (ApiResponse)JSON.parseObject((String)responseBody, ApiResponse.class);
            if (apiResponse.errCode != 0) {
                throw new RuntimeException("ErrorCode:" + apiResponse.errCode + " - ErrorMsg:" + apiResponse.description);
            }
            return apiResponse.data;
        }
        catch (IOException e) {
            logger.error((Throwable)e);
            return null;
        }
    }

    public static class UserData {
        private String address;
        private String avatar;
        private String birthday;
        private String email;
        private int gender;
        private String name;
        private String nickname;
        private String phone;
        private long uid;

        public String getAddress() {
            return this.address;
        }

        public void setAddress(String address) {
            this.address = address;
        }

        public String getEmail() {
            return this.email;
        }

        public void setEmail(String email) {
            this.email = email;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getPhone() {
            return this.phone;
        }

        public void setPhone(String phone) {
            this.phone = phone;
        }

        public long getUid() {
            return this.uid;
        }

        public void setUid(long uid) {
            this.uid = uid;
        }

        public String getAvatar() {
            return this.avatar;
        }

        public void setAvatar(String avatar) {
            this.avatar = avatar;
        }

        public String getBirthday() {
            return this.birthday;
        }

        public void setBirthday(String birthday) {
            this.birthday = birthday;
        }

        public int getGender() {
            return this.gender;
        }

        public void setGender(int gender) {
            this.gender = gender;
        }

        public String getNickname() {
            return this.nickname;
        }

        public void setNickname(String nickname) {
            this.nickname = nickname;
        }

        public CommunityUser convertCommunityUser() {
            CommunityUser communityUser = new CommunityUser();
            communityUser.setUid(Long.valueOf(this.uid));
            communityUser.setAddress(this.address);
            communityUser.setAvatar(this.avatar);
            communityUser.setBirthday(this.birthday);
            communityUser.setEmail(this.email);
            communityUser.setGender(Integer.valueOf(this.gender));
            communityUser.setName(this.name);
            communityUser.setNickName(this.nickname);
            communityUser.setPhone(this.phone);
            return communityUser;
        }

        public String toString() {
            return "UserData{address='" + this.address + '\'' + ", avatar='" + this.avatar + '\'' + ", birthday='" + this.birthday + '\'' + ", email='" + this.email + '\'' + ", gender=" + this.gender + ", name='" + this.name + '\'' + ", nickname='" + this.nickname + '\'' + ", phone='" + this.phone + '\'' + ", uid=" + this.uid + '}';
        }
    }

    public static class ApiResponse {
        @JSONField(name="errcode")
        private int errCode;
        @JSONField(name="description")
        private String description;
        @JSONField(name="data")
        private UserData data;

        public int getErrCode() {
            return this.errCode;
        }

        public void setErrCode(int errCode) {
            this.errCode = errCode;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public UserData getData() {
            return this.data;
        }

        public void setData(UserData data) {
            this.data = data;
        }

        public String toString() {
            return "ApiResponse{errCode=" + this.errCode + ", description='" + this.description + '\'' + ", data=" + this.data + '}';
        }
    }
}

