/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.emun;

import java.util.Locale;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.util.StringUtils;

public enum MCDBType {
    MYSQL("1", "mysql", 2, 6),
    ORACLE("3", "oracle", 0, 2),
    SQL_SERVER("6", "sqlserver", 6, 3),
    PG("10", "postgresql", 1, 5),
    DM("11", "dameng", 3, 11),
    GAUSS_100("12", "gauss100", 4, 13),
    VAST_BASE("16", "vastbase", 1, 16);

    String code;
    String type;
    int type4Login;
    int type4KSQL;
    private static final String[] MYSQL_BLACK_LIST;

    private MCDBType(String code, String type, int type4Login, int type4KSQL) {
        this.code = code;
        this.type = type;
        this.type4Login = type4Login;
        this.type4KSQL = type4KSQL;
    }

    public String getCode() {
        return this.code;
    }

    public String getType() {
        return this.type;
    }

    public int getType4Login() {
        return this.type4Login;
    }

    public int getType4KSQL() {
        return this.type4KSQL;
    }

    public static String getCode(String type4Login) {
        if (StringUtils.isEmpty((String)type4Login)) {
            return MYSQL.getCode();
        }
        int i = Integer.parseInt(type4Login);
        for (MCDBType value : MCDBType.values()) {
            if (i != value.getType4Login()) continue;
            return value.getCode();
        }
        return MYSQL.getCode();
    }

    public static String getCode(String type, String type4Login) {
        if (StringUtils.isEmpty((String)type)) {
            return MCDBType.getCode(type4Login);
        }
        for (MCDBType value : MCDBType.values()) {
            if (!type.equals(value.getType())) continue;
            return value.getCode();
        }
        return MYSQL.getCode();
    }

    public static MCDBType getByCode(String code) {
        for (MCDBType value : MCDBType.values()) {
            if (!code.equals(value.code)) continue;
            return value;
        }
        return MYSQL;
    }

    public String getDriver() {
        String driver;
        switch (this) {
            case ORACLE: {
                driver = "oracle.jdbc.driver.OracleDriver";
                break;
            }
            case GAUSS_100: {
                driver = "com.huawei.gauss.jdbc.ZenithDriver";
                break;
            }
            case SQL_SERVER: {
                driver = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
                break;
            }
            case PG: 
            case VAST_BASE: {
                driver = "org.postgresql.Driver";
                break;
            }
            case DM: {
                driver = "dm.jdbc.driver.DmDriver";
                break;
            }
            default: {
                driver = "com.mysql.cj.jdbc.Driver";
            }
        }
        return driver;
    }

    public String getURL(String ip, int port, String instance) {
        return this.getURL(MCDBType.getURLs(ip, port), instance);
    }

    public String getURL(String urls, String instance) {
        String url;
        if (StringUtils.isEmpty((String)instance)) {
            instance = "";
        }
        switch (this) {
            case ORACLE: {
                url = "jdbc:oracle:thin:@" + urls + "/" + instance;
                break;
            }
            case GAUSS_100: {
                url = "jdbc:zenith:@" + urls;
                break;
            }
            case SQL_SERVER: {
                url = "jdbc:sqlserver://" + urls + ";DatabaseName=" + instance;
                break;
            }
            case PG: 
            case VAST_BASE: {
                url = "jdbc:postgresql://" + urls + "/" + instance;
                break;
            }
            case DM: {
                url = "jdbc:dm://" + urls + "/" + instance;
                break;
            }
            default: {
                url = "jdbc:mysql://" + urls + "/" + instance;
            }
        }
        return url;
    }

    public void checkInvalidUrl(String url) throws Exception {
        switch (this) {
            case MYSQL: {
                if (url.contains("?")) {
                    throw new Exception(ResManager.loadKDString((String)"\u8fde\u63a5\u4e32\u5b58\u5728\u53c2\u6570\u6ce8\u5165\u98ce\u9669", (String)"MCDBType_0", (String)"bos-login", (Object[])new Object[0]));
                }
                for (String s : MYSQL_BLACK_LIST) {
                    if (!url.toLowerCase(Locale.ENGLISH).contains(s.toLowerCase(Locale.ENGLISH))) continue;
                    throw new Exception(String.format(ResManager.loadKDString((String)"\u5b58\u5728\u4e0d\u53ef\u7528\u7684MySQL\u9a71\u52a8\u53c2\u6570\uff1a%s", (String)"MCDBType_1", (String)"bos-login", (Object[])new Object[0]), s));
                }
                break;
            }
        }
    }

    public static String getURLs(String ip, int port) {
        if (!ip.contains(",")) {
            return String.format("%s:%s", ip, port);
        }
        return ip;
    }

    static {
        MYSQL_BLACK_LIST = new String[]{"allowLoadLocalInFile"};
    }
}

