/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.filter;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.context.RequestContextCreator;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.login.filter.HandleFilter;
import kd.bos.login.filter.HandleResult;
import kd.bos.login.filter.impl.APIHandlerFilter;
import kd.bos.login.filter.impl.ApiCommonAuthFilter;
import kd.bos.login.filter.impl.BasicAuthFilter;
import kd.bos.login.filter.impl.JWTFilter;
import kd.bos.login.filter.impl.NewPortalFilter;
import kd.bos.login.filter.impl.ShareFilter;
import kd.bos.login.filter.impl.UpgradeFilter;
import kd.bos.login.utils.BeanUtils;
import kd.bos.login.utils.LoginUtils;
import kd.bos.login.utils.SessionUtils;
import kd.bos.session.SessionInfo;
import kd.bos.util.NetAddressUtils;
import kd.bos.util.RevProxyUtil;
import kd.bos.util.StringUtils;

public class MediaHandler {
    private static ArrayList<HandleFilter> handlerList = new ArrayList();

    public static void register(HandleFilter handleFilter) {
        if (handleFilter != null) {
            handlerList.add(handleFilter);
        }
    }

    public static boolean executeHandler(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain, String glableSessoionId) throws IOException, ServletException {
        String tenantId;
        String filterString;
        boolean isHandled = MediaHandler.getFilterResult(request, response, filterChain, glableSessoionId, handlerList);
        if (!isHandled && StringUtils.isNotEmpty((String)(filterString = MediaHandler.getProptyOnlyByTenant("login_extend_filter", tenantId = RevProxyUtil.getTenantCode((HttpServletRequest)request))))) {
            String[] filterArray = filterString.trim().split(",");
            ArrayList<HandleFilter> selfList = new ArrayList<HandleFilter>(10);
            for (String filter : filterArray) {
                HandleFilter handleFilter = (HandleFilter)BeanUtils.getBean(filter);
                selfList.add(handleFilter);
            }
            isHandled = MediaHandler.getFilterResult(request, response, filterChain, glableSessoionId, selfList);
        }
        return isHandled;
    }

    private static boolean getFilterResult(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain, String glableSessoionId, List<HandleFilter> parameterhandlerList) throws IOException, ServletException {
        boolean isHandled = false;
        if (parameterhandlerList == null) {
            return isHandled;
        }
        for (HandleFilter handleFilter : parameterhandlerList) {
            HandleResult result = handleFilter.doFilter(request, response, glableSessoionId);
            if (result.isHandled() && result.isNeedCreateContext()) {
                MediaHandler.createRequestContext(request, response, filterChain, result);
            }
            if (result.isHandled() && !result.isNeedCreateContext() && result.isNeedDoFilter()) {
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            }
            if (!result.isHandled()) continue;
            isHandled = true;
            break;
        }
        return isHandled;
    }

    private static void createRequestContext(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain, HandleResult result) throws IOException, ServletException {
        String tenantId = RevProxyUtil.getTenantCode((HttpServletRequest)request);
        Account currentCenter = AccountUtils.getCorrectAccount((String)result.getAccountId(), (String)tenantId);
        Map<String, String> userInfo = null;
        userInfo = result.isNeedGetUserInfo() ? LoginUtils.getUserInfoByAPIUserType(currentCenter, result.getUser(), result.getUserType().name(), result.getLanguage()) : result.getUserInfo();
        LoginUtils.checkAPIUserInfo(userInfo);
        SessionInfo si = new SessionInfo();
        if (currentCenter != null) {
            si.setTenantId(currentCenter.getTenantId());
        }
        si.setOrgId(userInfo.get("forgid"));
        si.setUserId(userInfo.get("fid"));
        si.setUserName(userInfo.get("ftruename"));
        si.setUserOpenId(userInfo.get("fopenid"));
        si.setUserType(userInfo.get("userType"));
        si.setLoginIP(NetAddressUtils.getRemoteHost((HttpServletRequest)request));
        if (result.getLanguage() != null) {
            si.setLanguage(result.getLanguage().toString());
        }
        si.setUid(userInfo.get("fuid"));
        si.setClient(SessionUtils.getClientString(result.getLoginClient()));
        SessionUtils.setApiClientContext(si);
        si.setAccountId(currentCenter.getAccountId());
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        si.setLoginTime(df.format(new Date()));
        si.setAuthType(result.getAuthType());
        RequestContextCreator.create((HttpServletRequest)request, (String)"-1", (SessionInfo)si);
        if ("5".equalsIgnoreCase(result.getAuthType()) && result.getRequestWrapper() != null) {
            filterChain.doFilter((ServletRequest)result.getRequestWrapper(), (ServletResponse)response);
        } else {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    public static String getProptyOnlyByTenant(String key, String tenantId) {
        String returnValue = "";
        if (StringUtils.isNotEmpty((String)tenantId)) {
            returnValue = System.getProperty(tenantId + "_" + key);
        }
        return returnValue;
    }

    static {
        MediaHandler.register(new APIHandlerFilter());
        MediaHandler.register(new JWTFilter());
        MediaHandler.register(new ShareFilter());
        MediaHandler.register(new NewPortalFilter());
        MediaHandler.register(new UpgradeFilter());
        MediaHandler.register(new BasicAuthFilter());
        MediaHandler.register(new ApiCommonAuthFilter());
    }
}

