/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.filter.impl;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import kd.bos.context.api.ApiContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dc.api.model.Account;
import kd.bos.exception.KDException;
import kd.bos.exception.LoginErrorCode;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.LoginClientEnum;
import kd.bos.login.api.APILoginError;
import kd.bos.login.filter.HandleFilter;
import kd.bos.login.filter.HandleResult;
import kd.bos.login.lang.LoginLangUtils;
import kd.bos.login.spi.OpenApiServiceManager;
import kd.bos.login.user.LoginUserService;
import kd.bos.login.utils.APIUtils;
import kd.bos.login.utils.ErrorCodeUtils;
import kd.bos.login.utils.LoginUtils;
import kd.bos.login.utils.ThirdAPIAPPUtils;
import kd.bos.login.utils.account.LoginAccountFactory;
import kd.bos.service.authorize.http.KDSignHttpServletRequestWrapper;
import kd.bos.service.authorize.model.AuthInfo;
import kd.bos.service.authorize.model.AuthResult;
import kd.bos.service.authorize.model.AuthTypeEnum;
import kd.bos.service.authorize.model.JwtInfo;
import kd.bos.service.authorize.model.SignInfo;
import kd.bos.util.ExceptionUtils;

public class ApiCommonAuthFilter
implements HandleFilter {
    private static final Log logger = LogFactory.getLog(ApiCommonAuthFilter.class);
    private static final String BOS_LOGIN = "bos-login";
    private static final String BASE_AUTHINFO_PARAMS_SIGN = "openApiSign";
    public static final String PATH_VAR_SLIT = "/$/";
    public static final String SIGN_ACCOUNTID_SLIT = ":";
    public static final String BASE_AUTH_PATH_VAR_TAG = "/$/openApiSign";
    private static final String AUTHINFO_PARAMS_SENSE = "sense";

    private void throwKDexecption(String message) throws KDException {
        throw new KDException(LoginErrorCode.loginBizException, new Object[]{ResManager.loadKDString((String)"\u8ba4\u8bc1\u4e0d\u901a\u8fc7\uff0c\u8ba4\u8bc1\u4fe1\u606f\u6709\u8bef\u3002", (String)"APIHandlerFilter_0", (String)BOS_LOGIN, (Object[])new Object[0])});
    }

    private static String trim(String content) {
        if (StringUtils.isEmpty((CharSequence)content)) {
            return "";
        }
        return content.trim();
    }

    @Override
    public HandleResult doFilter(HttpServletRequest request, HttpServletResponse response, String glableSessoionId) throws IOException, ServletException {
        HandleResult result = new HandleResult();
        String requestURI = request.getRequestURI();
        String contextPath = request.getContextPath();
        String accessKey = ThirdAPIAPPUtils.getSignByRequest(request);
        String accountId = "";
        boolean bAPI = Boolean.parseBoolean(request.getHeader("api")) || requestURI.indexOf("/kapi/", contextPath.length()) - contextPath.length() == 0;
        String authType = ApiCommonAuthFilter.trim(ThirdAPIAPPUtils.getBasicAuthParamsByRequest(request, "OpenApiAuth"));
        HashMap<String, String> userInfo = new HashMap();
        try {
            Account currentCenter;
            if (!bAPI || !AuthTypeEnum.isValid((String)authType)) {
                result.setNeedDoFilter(false);
                return result;
            }
            if (!ThirdAPIAPPUtils.isBase64(accessKey)) {
                this.throwKDexecption("accessKey is invalid");
            }
            Map<String, String> mapinfo = ThirdAPIAPPUtils.getAccountIdAndSignCode(accessKey);
            String signCode = mapinfo.get("signCode");
            accountId = mapinfo.get("accountId");
            if (StringUtils.isEmpty((CharSequence)accountId)) {
                throw ErrorCodeUtils.getSystemKDException("error: base auth failed! accountId is null!");
            }
            if (!ThirdAPIAPPUtils.isBase64(signCode)) {
                this.throwKDexecption("signCode is invalid");
            }
            if ((currentCenter = LoginAccountFactory.createInstanceByCustom(accountId, request).getAccount()) == null) {
                throw new KDException(APILoginError.API_REQUEST_INVALID_PARAMETERS, new Object[]{ResManager.loadKDString((String)"\u83b7\u53d6\u6570\u636e\u4e2d\u5fc3\u9519\u8bef\u3002", (String)"ThirdAPIAPPUtils_3", (String)BOS_LOGIN, (Object[])new Object[0])});
            }
            AuthInfo authInfo = AuthInfo.of((String)authType, (String)signCode, (String)accountId);
            authInfo.setUrl(requestURI.substring(request.getContextPath().length()));
            if ("2".equalsIgnoreCase(authType)) {
                String signature = request.getHeader("signature");
                String getSigature = request.getParameter("signature");
                String datetimeString = request.getHeader("timestamp");
                String signatureNonce = request.getHeader("signatureNonce");
                String requestParams = "";
                if ("POST".equalsIgnoreCase(request.getMethod()) && StringUtils.isNotEmpty((CharSequence)signature) && "application/json".equalsIgnoreCase(request.getContentType())) {
                    ThirdAPIAPPUtils.checkDateTimeAndSigature(datetimeString, signatureNonce, currentCenter.getTenantId(), currentCenter.getAccountId());
                    requestParams = LoginUtils.getRequestBody(request);
                } else if ("GET".equalsIgnoreCase(request.getMethod()) && StringUtils.isNotEmpty((CharSequence)getSigature)) {
                    signature = getSigature;
                    datetimeString = request.getParameter("timestamp");
                    signatureNonce = request.getParameter("signatureNonce");
                    ThirdAPIAPPUtils.checkDateTimeAndSigature(datetimeString, signatureNonce, currentCenter.getTenantId(), currentCenter.getAccountId());
                    String parameters = request.getParameter("parameters");
                    if (StringUtils.isEmpty((CharSequence)parameters)) {
                        throw new KDException(APILoginError.API_REQUEST_INVALID_PARAMETERS, new Object[]{ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef\uff1a\u7f3a\u5c11parameters\u53c2\u6570\u3002", (String)"APIHandlerFilter_5", (String)BOS_LOGIN, (Object[])new Object[0])});
                    }
                    String[] parameterArray = parameters.split(",");
                    StringBuilder sb = new StringBuilder();
                    for (int i = 0; i < parameterArray.length; ++i) {
                        String value = kd.bos.login.utils.StringUtils.getStringValue(request.getParameter(parameterArray[i]));
                        if (i == 0) {
                            sb.append(parameterArray[i]).append("=").append(value);
                            continue;
                        }
                        sb.append("&").append(parameterArray[i]).append("=").append(value);
                    }
                    requestParams = sb.toString();
                }
                SignInfo signInfo = SignInfo.of((String)"", (String)accountId, (String)currentCenter.getTenantId());
                signInfo.setDateTime(datetimeString);
                signInfo.setContent(requestParams);
                signInfo.setSignatureNonce(signatureNonce);
                signInfo.setSignature(signature);
                signInfo.setAuthType(AuthTypeEnum.AUTH_DIGEST.getId());
                authInfo.setSignInfo(signInfo);
            } else if ("3".equalsIgnoreCase(authType)) {
                String jwtString = "";
                if ("POST".equalsIgnoreCase(request.getMethod())) {
                    jwtString = request.getHeader("jwt");
                } else if ("GET".equalsIgnoreCase(request.getMethod())) {
                    jwtString = request.getParameter("jwt");
                }
                JwtInfo jwtInfo = new JwtInfo();
                jwtInfo.setAccountId(accountId);
                jwtInfo.setJwt(jwtString);
                authInfo.setJwtInfo(jwtInfo);
                authInfo.setAuthType("3");
            } else if ("5".equalsIgnoreCase(authType)) {
                SignInfo signInfo = new SignInfo();
                signInfo.setContent(LoginUtils.getRequestBody(request));
                authInfo.setSignInfo(signInfo);
                authInfo.setSense(LoginUtils.getParamerter(request, AUTHINFO_PARAMS_SENSE));
                authInfo.setAuthType(authType);
            }
            authInfo.setCommonAuth(true);
            AuthResult authResult = OpenApiServiceManager.getApiAuthService().auth(authInfo);
            if (!authResult.isStatus()) {
                this.throwKDexecption(authResult.getMessage());
            }
            Lang lang = LoginLangUtils.getLoginLanguage(request);
            if ("3".equalsIgnoreCase(authType)) {
                userInfo = authResult.getUserInfo();
            } else {
                if (authResult.getAgentUserId() == null) {
                    this.throwKDexecption("invalid params for agentUserId.");
                }
                userInfo = LoginUserService.getErpUserInfoByUserId(currentCenter, authResult.getAgentUserId().toString(), lang.name());
            }
            if (userInfo.isEmpty()) {
                this.throwKDexecption("invalid agent user is null");
            }
            ApiContext context = ApiContext.create();
            context.setAppNum(authResult.getThirdAppNumber());
            context.setAppId(authResult.getThirdId());
            ApiContext.set((ApiContext)context);
            result.setAccountId(accountId);
            result.setHandled(true);
            result.setUserInfo(userInfo);
            result.setNeedGetUserInfo(false);
            result.setLanguage(lang);
            result.setNeedCreateContext(true);
            result.setLoginClient(LoginClientEnum.API);
            result.setAuthType(authType);
            if ("5".equalsIgnoreCase(authType)) {
                KDSignHttpServletRequestWrapper requestWrapper = new KDSignHttpServletRequestWrapper(request);
                requestWrapper.setBody(authResult.getData().getBytes("UTF-8"));
                result.setRequestWrapper((HttpServletRequestWrapper)requestWrapper);
            }
        }
        catch (KDException var17) {
            logger.error((Throwable)var17);
            APIUtils.outputErrorMessage(response, var17.getErrorCode().getCode(), var17.getMessage());
        }
        catch (Exception var18) {
            logger.error((Throwable)var18);
            APIUtils.outputErrorMessage(response, "8", String.format(ResManager.loadKDString((String)"\u8ba4\u8bc1\u4e0d\u901a\u8fc7\uff0c\u8ba4\u8bc1\u4fe1\u606f\u6709\u8bef\u3002", (String)"APIHandlerFilter_0", (String)BOS_LOGIN, (Object[])new Object[0]), ExceptionUtils.getExceptionStackTraceMessage((Exception)var18)));
        }
        return result;
    }
}

