/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.filter.impl;

import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dc.api.model.Account;
import kd.bos.exception.KDException;
import kd.bos.exception.LoginErrorCode;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.LoginClientEnum;
import kd.bos.login.filter.HandleFilter;
import kd.bos.login.filter.HandleResult;
import kd.bos.login.lang.LoginLangUtils;
import kd.bos.login.spi.OpenApiServiceManager;
import kd.bos.login.user.LoginUserService;
import kd.bos.login.utils.APIUtils;
import kd.bos.login.utils.ErrorCodeUtils;
import kd.bos.login.utils.ThirdAPIAPPUtils;
import kd.bos.login.utils.account.LoginAccountFactory;
import kd.bos.message.service.pa.util.StringUtil;
import kd.bos.service.authorize.model.AuthInfo;
import kd.bos.service.authorize.model.AuthResult;
import kd.bos.util.ExceptionUtils;

public class BasicAuthFilter
implements HandleFilter {
    private static final Log logger = LogFactory.getLog(BasicAuthFilter.class);
    private static final String BASE_AUTHINFO_PARAMS_SIGN = "openApiSign";
    public static final String PATH_VAR_SLIT = "/$/";
    public static final String SIGN_ACCOUNTID_SLIT = ":";
    public static final String BASE_AUTH_PATH_VAR_TAG = "/$/openApiSign";

    private void throwKDexecption(String message) throws KDException {
        throw new KDException(LoginErrorCode.loginBizException, new Object[]{ResManager.loadKDString((String)"\u8ba4\u8bc1\u4e0d\u901a\u8fc7\uff0c\u8ba4\u8bc1\u4fe1\u606f\u6709\u8bef\u3002", (String)"APIHandlerFilter_0", (String)"bos-login", (Object[])new Object[0])});
    }

    private void throwKDexecption() throws KDException {
        throw new KDException(LoginErrorCode.loginBizException, new Object[]{ResManager.loadKDString((String)"\u8ba4\u8bc1\u4e0d\u901a\u8fc7\uff0c\u8ba4\u8bc1\u4fe1\u606f\u6709\u8bef\u3002", (String)"APIHandlerFilter_0", (String)"bos-login", (Object[])new Object[0])});
    }

    @Override
    public HandleResult doFilter(HttpServletRequest request, HttpServletResponse response, String glableSessoionId) throws IOException, ServletException {
        HandleResult result = new HandleResult();
        String requestURI = request.getRequestURI();
        String contextPath = request.getContextPath();
        String accessKey = ThirdAPIAPPUtils.getSignByRequest(request);
        String accountId = "";
        String authType = ThirdAPIAPPUtils.getBasicAuthParamsByRequest(request, "OpenApiAuth");
        if (StringUtils.isNotEmpty((CharSequence)authType)) {
            return result;
        }
        boolean bAPI = Boolean.parseBoolean(request.getHeader("api")) || requestURI.indexOf("/kapi/", contextPath.length()) - contextPath.length() == 0;
        boolean isBaseAuth = !StringUtil.isEmpty((String)accessKey);
        try {
            AuthResult authResult;
            if (!isBaseAuth || !bAPI) {
                result.setNeedDoFilter(false);
                return result;
            }
            if (!ThirdAPIAPPUtils.isBase64(accessKey)) {
                this.throwKDexecption();
            }
            Map<String, String> mapinfo = ThirdAPIAPPUtils.getAccountIdAndSignCode(accessKey);
            String signCode = mapinfo.get("signCode");
            accountId = mapinfo.get("accountId");
            if (StringUtil.isEmpty((String)accountId)) {
                throw ErrorCodeUtils.getSystemKDException("error: base auth failed! accountId is null!");
            }
            if (!ThirdAPIAPPUtils.isBase64(signCode)) {
                this.throwKDexecption();
            }
            if (!(authResult = OpenApiServiceManager.getApiAuthService().auth(AuthInfo.of((String)"4", (String)signCode, (String)accountId))).isStatus()) {
                this.throwKDexecption(authResult.getMessage());
            }
            Account currentCenter = LoginAccountFactory.createInstanceByCustom(accountId, request).getAccount();
            Long userId = authResult.getAgentUserId();
            if (userId == null) {
                this.throwKDexecption();
            }
            Lang lang = LoginLangUtils.getLoginLanguage(request);
            Map<String, String> cUserInfo = LoginUserService.getErpUserInfoByUserId(currentCenter, userId.toString(), lang.name());
            if (cUserInfo.isEmpty()) {
                this.throwKDexecption();
            }
            result.setAccountId(authResult.getAccountId());
            ThirdAPIAPPUtils.createBasicAuthApiContext(authResult);
            result.setHandled(true);
            result.setAccountId(accountId);
            result.setUserInfo(cUserInfo);
            result.setNeedGetUserInfo(false);
            result.setLanguage(lang);
            result.setNeedCreateContext(true);
            result.setLoginClient(LoginClientEnum.API);
            result.setAuthType("4");
        }
        catch (KDException var17) {
            logger.error((Throwable)var17);
            APIUtils.outputErrorMessage(response, var17.getErrorCode().getCode(), var17.getMessage());
        }
        catch (Exception var18) {
            logger.error((Throwable)var18);
            APIUtils.outputErrorMessage(response, "8", String.format(ResManager.loadKDString((String)"\u8ba4\u8bc1\u4e0d\u901a\u8fc7\uff0c\u8ba4\u8bc1\u4fe1\u606f\u6709\u8bef\u3002", (String)"APIHandlerFilter_0", (String)"bos-login", (Object[])new Object[0]), ExceptionUtils.getExceptionStackTraceMessage((Exception)var18)));
        }
        return result;
    }
}

