/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.filter.impl;

import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.cache.CacheData;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dc.api.model.Account;
import kd.bos.exception.KDException;
import kd.bos.exception.LoginErrorCode;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.filter.HandleFilter;
import kd.bos.login.filter.HandleResult;
import kd.bos.login.lang.LoginLangUtils;
import kd.bos.login.thirdauth.UserProperType;
import kd.bos.login.user.LoginUserService;
import kd.bos.login.utils.APIUtils;
import kd.bos.login.utils.JSONUtils;
import kd.bos.login.utils.LoginUtils;
import kd.bos.login.utils.StringUtils;
import kd.bos.login.utils.account.LoginAccountFactory;
import kd.bos.session.SessionManager;
import kd.bos.share.ShareInfo;
import kd.bos.share.ShareUrlService;
import kd.bos.util.RevProxyUtil;

public class ShareFilter
implements HandleFilter {
    private static final String KDSHARE_FLAG = "kdshareflag";
    private static final Log logger = LogFactory.getLog(ShareFilter.class);

    @Override
    public HandleResult doFilter(HttpServletRequest request, HttpServletResponse response, String glableSessoionId) throws IOException, ServletException {
        HandleResult result = new HandleResult();
        boolean isNeedHandle = ShareFilter.isShareUrl(request);
        try {
            if (isNeedHandle) {
                result.setHandled(true);
                String shareFlag = ShareFilter.getShareFlag(request);
                ShareInfo shareInfo = ShareUrlService.getShareInfo((String)shareFlag);
                if (shareInfo == null) {
                    throw new KDException(ResManager.loadKDString((String)"\u5206\u4eabURL\u4e0d\u6b63\u786e\u6216\u8005\u5206\u4eab\u65f6\u95f4\u5df2\u7ecf\u8fc7\u671f\u3002\n", (String)"ShareFilter_0", (String)"bos-login", (Object[])new Object[0]));
                }
                String shareUserId = shareInfo.getShareUserId();
                Lang lang = LoginLangUtils.getLoginLanguage(request);
                Account currentCenter = LoginAccountFactory.createInstanceByCustom(shareInfo.getAccountId(), request).getAccount();
                Map<String, String> map = LoginUserService.getErpUserInfoByUserId(currentCenter, shareUserId, lang.getLocale().getLanguage());
                String enable = map.get("fenable");
                if (enable == null || "0".equals(enable)) {
                    throw new KDException(ResManager.loadKDString((String)"\u5206\u4eab\u7528\u6237\u72b6\u6001\u5f02\u5e38\uff0c\u94fe\u63a5\u5931\u6548\u3002\n", (String)"ShareFilter_1", (String)"bos-login", (Object[])new Object[0]));
                }
                String formId = request.getParameter("formId");
                if (!shareInfo.getFormId().equals(formId)) {
                    throw new KDException(LoginErrorCode.loginBizException, new Object[]{ResManager.loadKDString((String)"\u975e\u6cd5\u64cd\u4f5c\uff01", (String)"LoginUtils_4", (String)"bos-login", (Object[])new Object[0])});
                }
                if (StringUtils.isNotEmpty(shareFlag)) {
                    String lastName = this.getKDShareFlagCookieName(request, KDSHARE_FLAG);
                    SessionManager.writeCookieData((HttpServletRequest)request, (HttpServletResponse)response, (String)lastName, (String)shareFlag);
                }
                LoginUtils.outputString(response, LoginUtils.getIndexHtml(request));
            } else {
                String pageId = request.getParameter("pageId");
                if (StringUtils.isNotEmpty(pageId)) {
                    String shareFlag = CacheData.getAttribute((String)"share", (String)pageId);
                    if (StringUtils.isNotEmpty(shareFlag)) {
                        result = this.handleShareFlag(request, shareFlag);
                    } else {
                        this.resetKDShareCookies(request, response);
                    }
                } else {
                    String lastName = this.getKDShareFlagCookieName(request, KDSHARE_FLAG);
                    String shareFlag = SessionManager.getCookieDataByName((HttpServletRequest)request, (String)lastName);
                    if (StringUtils.isNotEmpty(shareFlag)) {
                        String params;
                        boolean isNeedResult = true;
                        if (this.isGetConfig(request) && StringUtils.isNotEmpty(params = request.getParameter("params"))) {
                            Map jParams = JSONUtils.cast(params, Map.class);
                            String formId = (String)jParams.get("formId");
                            ShareInfo shareInfo = ShareUrlService.getShareInfo((String)shareFlag);
                            if (shareInfo != null && !shareInfo.getFormId().equals(formId)) {
                                this.resetKDShareCookies(request, response);
                                isNeedResult = false;
                            } else {
                                String flag = String.valueOf(jParams.get("flag"));
                                if (StringUtils.isNotEmpty(flag)) {
                                    CacheData.setAttribute((String)"flag", (String)(formId + flag), (String)shareFlag, (int)200);
                                }
                            }
                        }
                        if (isNeedResult && this.isDoAction(request)) {
                            result = this.handleShareFlag(request, shareFlag);
                        }
                    }
                }
            }
        }
        catch (KDException e) {
            logger.error((Throwable)e);
            APIUtils.outputErrorMessage(response, e.getMessage());
        }
        catch (Exception ex) {
            logger.error((Throwable)ex);
            APIUtils.outputErrorMessage(response, "8", ex.getMessage());
        }
        return result;
    }

    private boolean isDoAction(HttpServletRequest request) {
        boolean isDo = request.getRequestURI().contains(".do");
        return isDo;
    }

    private void resetKDShareCookies(HttpServletRequest request, HttpServletResponse response) {
        String flagName = this.getKDShareFlagCookieName(request, KDSHARE_FLAG);
        SessionManager.writeCookieData((HttpServletRequest)request, (HttpServletResponse)response, (String)flagName, (String)"");
    }

    private boolean isGetConfig(HttpServletRequest request) {
        return ShareFilter.isStartUrl(request, "form/getConfig.do");
    }

    private String getKDShareFlagCookieName(HttpServletRequest request, String name) {
        String tenantAlias = RevProxyUtil.getTenantCode((HttpServletRequest)request);
        String lastName = tenantAlias + "_" + name;
        return lastName;
    }

    private HandleResult handleShareFlag(HttpServletRequest request, String shareFlag) {
        HandleResult result = new HandleResult();
        result.setHandled(true);
        ShareInfo shareInfo = ShareUrlService.getShareInfo((String)shareFlag);
        if (shareInfo != null) {
            result.setNeedCreateContext(true);
            result.setUser(shareInfo.getShareUserId());
            result.setUserType(UserProperType.UserId);
            result.setAccountId(shareInfo.getAccountId());
            result.setLanguage(LoginLangUtils.getLang(shareInfo.getLangName()));
            result.setNeedDoFilter(true);
        } else {
            result.setHandled(false);
        }
        return result;
    }

    private static boolean isShareUrl(HttpServletRequest request) {
        return ShareFilter.isStartUrl(request, "kdshare.do");
    }

    private static boolean isStartUrl(HttpServletRequest request, String urlStart) {
        boolean isShareUrl = false;
        String context = request.getContextPath();
        String path = request.getRequestURI();
        String xpath = null;
        if (path != null) {
            xpath = path.replace(context + "/", "");
        }
        if (xpath != null && xpath.startsWith(urlStart)) {
            isShareUrl = true;
        }
        return isShareUrl;
    }

    private static String getShareFlag(HttpServletRequest request) {
        return request.getParameter("shareId");
    }
}

