/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.handler;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.context.RequestContextCreator;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.mc.tenant.AccountType;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.service.DispatchServiceHelper;
import kd.bos.login.sso.SSOAuth;
import kd.bos.login.sso.SSOErrorCode;
import kd.bos.login.utils.LoginUtils;
import kd.bos.login.utils.SecurityUtils;
import kd.bos.login.utils.StringUtils;
import kd.bos.session.SessionInfo;
import kd.bos.util.RevProxyUtil;

public class GuestManager {
    protected static Log logger = LogFactory.getLog(GuestManager.class);

    public String getFormId(HttpServletRequest request) {
        String form = request.getParameter("form");
        if (StringUtils.isEmpty(form)) {
            form = request.getParameter("formId");
        }
        if (StringUtils.isEmpty(form) && LoginUtils.isRootPage(request) && !LoginUtils.isIincludePageId(request)) {
            form = "pc_main_console";
        }
        return form;
    }

    public boolean judgeGuestFormPermission(HttpServletRequest request, HttpServletResponse response, String globalSessionId, String form) throws IOException {
        String billFormId = request.getParameter("billFormId");
        boolean hasRight = false;
        try {
            SessionInfo si = LoginUtils.getSessionInfoBySessionId(request, globalSessionId);
            if (si != null) {
                RequestContextCreator.create((HttpServletRequest)request, (String)globalSessionId, (SessionInfo)si);
                Object formObject = DispatchServiceHelper.invokeBOSService("FormService", "checkGuestAccess", form);
                if (formObject instanceof Boolean) {
                    hasRight = (Boolean)formObject;
                }
                if (StringUtils.isNotEmpty(billFormId) && (formObject = DispatchServiceHelper.invokeBOSService("FormService", "checkGuestAccess", billFormId)) instanceof Boolean) {
                    hasRight = (Boolean)formObject;
                }
            }
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528FormService\u3002checkGuestAccess \u5931\u8d25 ", (Throwable)e);
            hasRight = false;
        }
        if (!hasRight) {
            String url = "?form=" + form;
            url = this.isMobile(request) ? "mobile.html" + url : "index.html" + url;
            url = RevProxyUtil.getURLContextPath((HttpServletRequest)request) + url;
            String accountIdParameter = LoginUtils.getAccountIdByCookie(globalSessionId);
            Account currentCenter = AccountUtils.getCorrectAccount((String)accountIdParameter, (String)RevProxyUtil.getTenantId((HttpServletRequest)request));
            String plugin = currentCenter.getSsoPlugin();
            if (LoginUtils.hasPrevilige(AccountType.ThridParty.toString(), currentCenter.getAllSourceTypes()) && StringUtils.isNotEmpty(plugin)) {
                this.showLoginPage(request, response, url);
            } else {
                this.redirectToYZJLogin(request, response, url);
            }
            return true;
        }
        return false;
    }

    private boolean isMobile(HttpServletRequest request) {
        boolean isMobile;
        String path = request.getRequestURI();
        boolean bl = isMobile = path.contains("/integration/yzjShareOpen.do") && "mob".equals(request.getParameter("device")) || path.contains("/qing/lappEntrance.do");
        if (Pattern.matches(".*/mobile.html.*", request.getServletPath().toLowerCase(Locale.ENGLISH))) {
            isMobile = true;
        }
        return isMobile;
    }

    private void showLoginPage(HttpServletRequest request, HttpServletResponse response, String redirectUrl) throws IOException {
        try {
            SSOAuth ssoIntel = new SSOAuth(request, response);
            ssoIntel.callSSOLogin(redirectUrl);
            return;
        }
        catch (KDException e) {
            if (!SSOErrorCode.match(e.getErrorCode())) {
                throw e;
            }
            this.redirectToYZJLogin(request, response);
            return;
        }
    }

    private void redirectToYZJLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String reRedirectUrl = this.getRedirectUrl(request);
        this.redirectToYZJLogin(request, response, reRedirectUrl);
    }

    private void redirectToYZJLogin(HttpServletRequest request, HttpServletResponse response, String reRedirectUrl) throws IOException {
        boolean isMobile;
        String mainWebSite = RevProxyUtil.getURLContextPath((HttpServletRequest)request);
        String path = request.getRequestURI();
        boolean bl = isMobile = path.contains("/integration/yzjShareOpen.do") && "mob".equals(request.getParameter("device")) || path.contains("/qing/lappEntrance.do");
        if (Pattern.matches(".*/mobile.html.*", request.getServletPath().toLowerCase(Locale.ENGLISH)) || isMobile) {
            String redirectUrl = String.format("%slogin-mobile.html?redirect=%s", mainWebSite, URLEncoder.encode(reRedirectUrl));
            response.sendRedirect(redirectUrl);
        } else {
            String redirectUrl = "index.html";
            String newUrl = URLEncoder.encode(reRedirectUrl);
            String loginType = request.getParameter("aiLoginType");
            if ("face".equalsIgnoreCase(loginType)) {
                redirectUrl = String.format("%slogin-face.html?redirect=%s", mainWebSite, newUrl);
            } else if ("voice".equalsIgnoreCase(loginType)) {
                redirectUrl = String.format("%slogin-voice.html?redirect=%s", mainWebSite, newUrl);
            } else if ("account".equalsIgnoreCase(loginType)) {
                redirectUrl = String.format("%slogin-account.html?redirect=%s", mainWebSite, newUrl);
            } else {
                redirectUrl = String.format("%slogin.html?redirect=%s", mainWebSite, newUrl);
                if (LoginUtils.isMCSystem()) {
                    redirectUrl = String.format("%slogin-mc.html?redirect=%s", mainWebSite, newUrl);
                }
            }
            response.sendRedirect(redirectUrl);
        }
    }

    private String getRedirectUrl(HttpServletRequest request) {
        String returnValue = "";
        if (request != null) {
            String olUrl = request.getRequestURI();
            if (StringUtils.isNotEmpty(request.getQueryString()) && !SecurityUtils.checkXss(request.getQueryString())) {
                olUrl = olUrl + "?" + request.getQueryString();
            }
            String newUrl = olUrl.replace(request.getContextPath() + "/", "");
            returnValue = RevProxyUtil.getURLContextPath((HttpServletRequest)request) + newUrl;
        }
        return returnValue;
    }
}

