/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.handler;

import java.io.IOException;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import kd.bos.login.utils.LoginUtils;
import kd.bos.login.utils.StringUtils;
import kd.bos.login.utils.account.LoginAccount;
import kd.bos.login.utils.account.LoginAccountFactory;
import kd.bos.session.SessionKeys;
import kd.bos.util.RevProxyUtil;

public class LoginAccountHandler {
    public HttpServletRequest handle(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LoginAccount loginAccount;
        String tenantCode = RevProxyUtil.getTenantCode((HttpServletRequest)request);
        boolean multiAccount = SessionKeys.isAccountSession((String)tenantCode);
        if (!multiAccount) {
            return request;
        }
        String requestURI = request.getRequestURI();
        String contextPath = request.getContextPath();
        String mappingPath = contextPath + "/excelpreview";
        Object resultRequest = request;
        if (requestURI.startsWith(mappingPath)) {
            requestURI = requestURI.substring(mappingPath.length() + 1);
            String kdcdc = requestURI.substring(0, requestURI.indexOf("/"));
            resultRequest = new LoginHttpServletRequestWrapper(request, kdcdc);
        }
        if (LoginUtils.isAccountBoolean(resultRequest, loginAccount = LoginAccountFactory.createInstanceByPostRequest(resultRequest, response, Optional.empty()))) {
            LoginUtils.showNoAccountMsg(resultRequest, response);
            response.setStatus(40401);
            return request;
        }
        return resultRequest;
    }

    public static class LoginHttpServletRequestWrapper
    extends HttpServletRequestWrapper {
        private String kdcdc;

        public LoginHttpServletRequestWrapper(HttpServletRequest request, String kdcdc) {
            super(request);
            this.kdcdc = kdcdc;
        }

        private String getReplace() {
            String replace = "/" + this.kdcdc;
            return replace;
        }

        public String getRequestURI() {
            HttpServletRequest request = (HttpServletRequest)this.getRequest();
            if (StringUtils.isEmpty(this.kdcdc)) {
                return request.getRequestURI();
            }
            String requestURI = request.getRequestURI();
            String replace = this.getReplace();
            return requestURI.replace(replace, "");
        }

        public StringBuffer getRequestURL() {
            HttpServletRequest request = (HttpServletRequest)this.getRequest();
            if (StringUtils.isEmpty(this.kdcdc)) {
                return request.getRequestURL();
            }
            StringBuffer requestURL = request.getRequestURL();
            String replace = this.getReplace();
            int strartIndex = requestURL.indexOf(replace);
            return requestURL.delete(strartIndex, strartIndex + replace.length());
        }

        public String getParameter(String name) {
            if ("kdcdc".equals(name)) {
                return this.kdcdc;
            }
            return super.getParameter(name);
        }
    }
}

