/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.handler;

import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import kd.bos.login.handler.ILoginHandler;
import kd.bos.login.handler.LoginHandlerContext;
import kd.bos.login.handler.LoginHandlerResult;
import kd.bos.login.handler.impl.AbstractLoginHandler;
import kd.bos.login.handler.impl.auth.CloudDeveloperAuthHandler;
import kd.bos.login.handler.impl.auth.DownloadFileHandler;
import kd.bos.login.handler.impl.auth.GuestAuth4APIHandler;
import kd.bos.login.handler.impl.auth.GuestAuth4WSDLHandler;
import kd.bos.login.handler.impl.auth.GuestAuth4WebserviceHandler;
import kd.bos.login.handler.impl.auth.GuestAuthKeepAliveHandler;
import kd.bos.login.handler.impl.auth.NewApiAuthHandler;
import kd.bos.login.handler.impl.auth.SMSKeepAliveHandler;
import kd.bos.login.handler.impl.auth.SSOAuthHandler;
import kd.bos.login.handler.impl.auth.ThirdAppAuthHandler;
import kd.bos.login.handler.impl.auth.WebofficeKeepAliveHandler;
import kd.bos.login.handler.impl.common.CodelessShareResourceHandler;
import kd.bos.login.handler.impl.common.CodelessShareSessionHandler;
import kd.bos.login.handler.impl.common.LoginOutResourceHandler;
import kd.bos.login.handler.impl.common.LoginPageResourceHandler;
import kd.bos.login.handler.impl.common.MCLoginHandler;
import kd.bos.login.handler.impl.common.RequestContextHandler;
import kd.bos.login.handler.impl.common.StaticResourceHandler;
import kd.bos.login.handler.impl.common.WPSWriteListResourceHandler;
import kd.bos.login.handler.impl.common.WhiteListResourceHandler;
import kd.bos.login.handler.impl.verify.AILoginHandler;
import kd.bos.login.handler.impl.verify.APIMediaHandler;
import kd.bos.login.handler.impl.verify.APIVerifyHandler;
import kd.bos.login.handler.impl.verify.AccountSessionVerifyHandler;
import kd.bos.login.handler.impl.verify.GuestSessionVerifyHandler;
import kd.bos.login.handler.impl.verify.GuestVerify4APIResourceHandler;
import kd.bos.login.handler.impl.verify.GuestVerify4FormResourceHandler;
import kd.bos.login.handler.impl.verify.KingScriptVerifyHandler;
import kd.bos.login.handler.impl.verify.LoginValidHandler;
import kd.bos.login.handler.impl.verify.NewApiVerifyHandler;
import kd.bos.login.handler.impl.verify.NewPortalHandler;
import kd.bos.login.handler.impl.verify.SSOVerifyHandler;
import kd.bos.login.handler.impl.verify.ThirdAppVerifyHandler;
import kd.bos.login.handler.impl.verify.WebserviceHandler;
import kd.bos.login.handler.impl.verify.YZJShareHandler;

public class LoginHandlerChain {
    private List<ILoginHandler> handlers = new LinkedList<ILoginHandler>();

    public void addHandler(ILoginHandler handler) {
        this.handlers.add(handler);
    }

    public void handle() throws Exception {
        for (ILoginHandler handler : this.handlers) {
            handler.handle();
            if (!handler.isInterrupt()) continue;
            break;
        }
    }

    public <T extends AbstractLoginHandler> Optional<AbstractLoginHandler> searchHandler(Class<T> handlerClass) {
        for (ILoginHandler handler : this.handlers) {
            if (handler.getClass() != handlerClass) continue;
            return Optional.of((AbstractLoginHandler)handler);
        }
        return Optional.empty();
    }

    public static LoginHandlerChain getInstance(LoginHandlerContext context, LoginHandlerResult handlerResult) {
        LoginHandlerChain chain = new LoginHandlerChain();
        LoginHandlerChain.buildChain4Forward(context, handlerResult, chain);
        LoginHandlerChain.buildChain4Verify(context, handlerResult, chain);
        LoginHandlerChain.buildChain4Auth(context, handlerResult, chain);
        LoginHandlerChain.buildChain4End(context, handlerResult, chain);
        return chain;
    }

    private static void buildChain4Forward(LoginHandlerContext context, LoginHandlerResult handlerResult, LoginHandlerChain chain) {
        chain.addHandler(new StaticResourceHandler(context, handlerResult));
        chain.addHandler(new MCLoginHandler(context, handlerResult));
        chain.addHandler(new RequestContextHandler(context, handlerResult));
        chain.addHandler(new LoginOutResourceHandler(context, handlerResult));
        chain.addHandler(new WhiteListResourceHandler(context, handlerResult));
        chain.addHandler(new WPSWriteListResourceHandler(context, handlerResult));
        chain.addHandler(new LoginPageResourceHandler(context, handlerResult));
        chain.addHandler(new CodelessShareResourceHandler(context, handlerResult));
        chain.addHandler(new CodelessShareSessionHandler(context, handlerResult));
        chain.addHandler(new NewApiAuthHandler(context, handlerResult));
        chain.addHandler(new NewApiVerifyHandler(context, handlerResult));
        chain.addHandler(new AccountSessionVerifyHandler(context, handlerResult));
    }

    private static void buildChain4Verify(LoginHandlerContext context, LoginHandlerResult handlerResult, LoginHandlerChain chain) {
        chain.addHandler(new ThirdAppVerifyHandler(context, handlerResult));
        chain.addHandler(new SSOVerifyHandler(context, handlerResult));
        chain.addHandler(new GuestVerify4APIResourceHandler(context, handlerResult));
        chain.addHandler(new GuestVerify4FormResourceHandler(context, handlerResult));
        chain.addHandler(new GuestSessionVerifyHandler(context, handlerResult));
        chain.addHandler(new APIMediaHandler(context, handlerResult));
        chain.addHandler(new APIVerifyHandler(context, handlerResult));
        chain.addHandler(new WebserviceHandler(context, handlerResult));
        chain.addHandler(new YZJShareHandler(context, handlerResult));
        chain.addHandler(new AILoginHandler(context, handlerResult));
        chain.addHandler(new NewPortalHandler(context, handlerResult));
        chain.addHandler(new KingScriptVerifyHandler(context, handlerResult));
    }

    private static void buildChain4Auth(LoginHandlerContext context, LoginHandlerResult handlerResult, LoginHandlerChain chain) {
        chain.addHandler(new ThirdAppAuthHandler(context, handlerResult));
        chain.addHandler(new DownloadFileHandler(context, handlerResult));
        chain.addHandler(new SMSKeepAliveHandler(context, handlerResult));
        chain.addHandler(new WebofficeKeepAliveHandler(context, handlerResult));
        chain.addHandler(new SSOAuthHandler(context, handlerResult));
        chain.addHandler(new GuestAuthKeepAliveHandler(context, handlerResult));
        chain.addHandler(new GuestAuth4WSDLHandler(context, handlerResult));
        chain.addHandler(new GuestAuth4APIHandler(context, handlerResult));
        chain.addHandler(new GuestAuth4WebserviceHandler(context, handlerResult));
        chain.addHandler(new CloudDeveloperAuthHandler(context, handlerResult));
    }

    private static void buildChain4End(LoginHandlerContext context, LoginHandlerResult handlerResult, LoginHandlerChain chain) {
        chain.addHandler(new LoginValidHandler(context, handlerResult));
    }
}

