/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.handler;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.LoginType;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.login.http.KDFlyHttpServletRequestWrapper;
import kd.bos.login.http.KDHttpServletRequestWrapper;
import kd.bos.login.utils.LoginUtils;
import kd.bos.login.utils.StringUtils;
import kd.bos.session.SystemPropertyUtils;
import kd.bos.util.RevProxyUtil;

public class RequestWrapperAnalysis {
    private static Log logger = LogFactory.getLog(RequestWrapperAnalysis.class);
    private static final String HCODE_TICKET = "ticket";
    private static final String QING_LAPP_ENTRANCE_DO = "/qing/lappEntrance.do";
    private static final String WSDL_WHITE_LIST = "bos.svc.login.wsdl.white";
    private static final String WSDL_WHITE_PATTERN = "bos.svc.login.wsdl.pattern";
    private static final String AJAX_HEADER = "ajax";
    private static final String XML_HTTP_REQUEST = "XMLHttpRequest";
    private static final String APP_SYS = "sys";
    private static final String ACCOUNT_ID = "accountId";
    private HttpServletRequest requestWrapper;

    public RequestWrapperAnalysis(HttpServletRequest requestWrapper) {
        this.requestWrapper = requestWrapper;
    }

    public static RequestWrapperAnalysis getInstance(HttpServletRequest requestWrapper) {
        return new RequestWrapperAnalysis(requestWrapper);
    }

    public static HttpServletRequest getRequestWrapper(ServletRequest servletRequestOld) throws IOException {
        HttpServletRequest requestWrapper = (HttpServletRequest)servletRequestOld;
        if ("post".equalsIgnoreCase(requestWrapper.getMethod()) && !LoginUtils.isMultipart(requestWrapper)) {
            try {
                requestWrapper.getParameter(ACCOUNT_ID);
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
            requestWrapper = "original".equalsIgnoreCase(requestWrapper.getHeader("kd-transfer-encoding")) ? new KDFlyHttpServletRequestWrapper(requestWrapper) : new KDHttpServletRequestWrapper(requestWrapper);
        }
        RequestWrapperAnalysis analysis = RequestWrapperAnalysis.getInstance(requestWrapper);
        requestWrapper.setAttribute("LoginType", (Object)analysis.getLoginType());
        requestWrapper.setCharacterEncoding("UTF-8");
        return requestWrapper;
    }

    public String getAPPId() {
        String appId = this.requestWrapper.getParameter("client_id");
        if (StringUtils.isEmpty(appId) && StringUtils.isEmpty(appId = this.requestWrapper.getParameter("appid"))) {
            appId = this.requestWrapper.getParameter("appId");
        }
        return appId;
    }

    public String getRequestURI() {
        return this.requestWrapper.getRequestURI();
    }

    public String getCloudTicket() {
        return this.requestWrapper.getParameter(HCODE_TICKET);
    }

    public String getContextPath() {
        return this.requestWrapper.getServletContext().getContextPath();
    }

    public String getRealUrl() {
        return this.requestWrapper.getRequestURI().substring(this.getContextPath().length());
    }

    public String getYzjSharePathKey() {
        return this.requestWrapper.getParameter("ierpanchor");
    }

    public String getAiLoginType() {
        return this.requestWrapper.getParameter("aiLoginType");
    }

    public LoginType getLoginType() {
        String path;
        RequestWrapperAnalysis analysis = RequestWrapperAnalysis.getInstance(this.requestWrapper);
        LoginType loginType = LoginType.YUNZHIJIA;
        String loginTypeByMC = System.getProperty("login.type");
        if ("STANDALONE".equalsIgnoreCase(loginTypeByMC)) {
            loginType = LoginType.STANDALONE;
        }
        if (((path = analysis.getRequestURI()).toLowerCase(Locale.ENGLISH).contains("/mobile.html") || path.contains(QING_LAPP_ENTRANCE_DO) || StringUtils.isNotEmpty(analysis.getAPPId())) && !StringUtils.isEmpty(analysis.getCloudTicket())) {
            loginType = LoginType.MOBILE;
        }
        return loginType;
    }

    public boolean isNeedWsdl() {
        String requestURI = this.getRequestURI();
        String queryS = this.requestWrapper.getQueryString();
        if (StringUtils.isNotEmpty(queryS) && (queryS.equals("wsdl") || queryS.contains("wsdl="))) {
            String wsdlWitheListStr = SystemPropertyUtils.getProptyByTenant((String)WSDL_WHITE_LIST, (String)RevProxyUtil.getTenantId((HttpServletRequest)this.requestWrapper));
            String wsdlWhitePattern = SystemPropertyUtils.getProptyByTenant((String)WSDL_WHITE_PATTERN, (String)RevProxyUtil.getTenantId((HttpServletRequest)this.requestWrapper));
            if ("get".equalsIgnoreCase(this.requestWrapper.getMethod()) && (requestURI.contains("/kws/") || requestURI.contains("/kapi/v2/")) && queryS.startsWith("wsdl")) {
                return true;
            }
            if (StringUtils.isNotEmpty(wsdlWitheListStr)) {
                List<String> wsdlWitheList = SerializationUtils.fromJsonStringToList(wsdlWitheListStr, String.class);
                for (String wsdlWitheName : wsdlWitheList) {
                    if (!requestURI.contains(wsdlWitheName)) continue;
                    return true;
                }
                return requestURI.equals(wsdlWitheListStr);
            }
            if (StringUtils.isNotEmpty(wsdlWhitePattern)) {
                return Pattern.matches(wsdlWhitePattern, requestURI);
            }
        }
        return requestURI.endsWith("/kws/");
    }

    public boolean isWebService() {
        return this.requestWrapper.getServletPath().contains("/kws");
    }

    public boolean isAjax() {
        boolean returnAjax = false;
        String requestType = this.requestWrapper.getHeader("x-requested-with");
        String isAjax = this.requestWrapper.getHeader(AJAX_HEADER);
        if (XML_HTTP_REQUEST.equalsIgnoreCase(requestType) || "true".equalsIgnoreCase(isAjax)) {
            returnAjax = true;
        }
        return returnAjax;
    }

    public boolean isDo() {
        return this.requestWrapper.getRequestURI().contains(".do");
    }
}

