/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.handler.impl;

import javax.servlet.http.HttpServletRequest;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.handler.ILoginHandler;
import kd.bos.login.handler.LoginHandlerContext;
import kd.bos.login.handler.LoginHandlerLog;
import kd.bos.login.handler.LoginHandlerResult;

public abstract class AbstractLoginHandler
implements ILoginHandler {
    protected static Log logger = LogFactory.getLog(AbstractLoginHandler.class);
    protected final LoginHandlerContext context;
    protected LoginHandlerResult handlerResult;
    private LoginHandlerLog.HandlerStatus handlerStatus = new LoginHandlerLog.HandlerStatus();

    public AbstractLoginHandler(LoginHandlerContext context, LoginHandlerResult handlerResult) {
        this.context = context;
        this.handlerResult = handlerResult;
    }

    @Override
    public final void handle() throws Exception {
        this.context.changeLoginHandler(this);
        boolean match = this.isMatch();
        if (match) {
            this.doHandle();
        }
        this.context.clearLoginHandler();
        this.handlerStatus.setMatch(match);
        this.handlerStatus.setHandlerName(this.getClass().getSimpleName());
        this.handlerResult.getHandlerLog().addHandlers(this.handlerStatus);
    }

    protected abstract void doHandle() throws Exception;

    @Override
    public boolean isInterrupt() {
        return this.handlerResult.isInterrupt();
    }

    protected boolean validClientSession() {
        return this.handlerResult.validClientSession();
    }

    protected String getClientSession() {
        return this.handlerResult.getClientSession();
    }

    public LoginHandlerLog.HandlerStatus getHandlerStatus() {
        return this.handlerStatus;
    }

    protected void doResponse(String ... customLog) {
        this.handlerResult.setInterrupt(true);
        this.handlerStatus.setProcessType(LoginHandlerLog.ProcessEnum.RESPONSE);
        this.handlerStatus.setCustomLog(this.buildCustomLog(customLog));
    }

    protected void doForward(String ... customLog) throws Exception {
        this.doForward((HttpServletRequest)null, customLog);
    }

    protected void doForward(HttpServletRequest requestWrapper, String ... customLog) throws Exception {
        this.context.doFilter(requestWrapper);
        this.handlerResult.setInterrupt(true);
        this.handlerStatus.setProcessType(LoginHandlerLog.ProcessEnum.FORWARD);
        this.handlerStatus.setCustomLog(this.buildCustomLog(customLog));
    }

    protected void doFail(String ... customLog) {
        this.handlerResult.addClientSessionFails();
        this.handlerStatus.setProcessType(LoginHandlerLog.ProcessEnum.FAIL);
        this.handlerStatus.setCustomLog(this.buildCustomLog(customLog));
    }

    protected void doSuccess(String sessionId) throws Exception {
        this.handlerResult.setInterrupt(true);
        this.handlerResult.setSuccess(true);
        this.handlerResult.changeSessionId(sessionId);
        this.handlerResult.createRequestContext(false);
        this.handlerStatus.setProcessType(LoginHandlerLog.ProcessEnum.SUCCESS);
    }

    protected void doGuestVisit(String sessionId) throws Exception {
        this.handlerResult.setInterrupt(true);
        this.handlerResult.setSuccess(true);
        this.handlerResult.changeSessionId(sessionId);
        this.handlerResult.createGuestRequestContext();
        this.handlerStatus.setProcessType(LoginHandlerLog.ProcessEnum.GUEST_VISIT);
    }

    protected void doGuestVisitStandardRC(String sessionId) throws Exception {
        this.handlerResult.setInterrupt(true);
        this.handlerResult.setSuccess(true);
        this.handlerResult.changeSessionId(sessionId);
        this.handlerResult.createRequestContext(true);
        this.handlerStatus.setProcessType(LoginHandlerLog.ProcessEnum.GUEST_VISIT_STANDARD_REQUESTCONTEXT);
    }

    private String buildCustomLog(String[] customLog) {
        if (customLog == null || customLog.length == 0) {
            return "";
        }
        return String.join((CharSequence)"-", customLog);
    }
}

