/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.handler.impl.auth;

import javax.servlet.ServletRequest;
import kd.bos.login.handler.GuestManager;
import kd.bos.login.handler.LoginHandlerContext;
import kd.bos.login.handler.LoginHandlerResult;
import kd.bos.login.handler.impl.AbstractLoginAuthHandler;
import kd.bos.login.utils.LoginUtils;
import kd.bos.login.utils.StringUtils;

public class GuestAuthKeepAliveHandler
extends AbstractLoginAuthHandler {
    private GuestManager guestManager = new GuestManager();

    public GuestAuthKeepAliveHandler(LoginHandlerContext context, LoginHandlerResult handlerResult) {
        super(context, handlerResult);
    }

    @Override
    public boolean doMatch() {
        if (this.context.isAPI() || this.context.isDo() || this.context.isNeedWsdl()) {
            return false;
        }
        String userId = LoginUtils.getParamerter(this.context.getRequestWrapper(), "userId");
        if (!"Guest".equalsIgnoreCase(userId)) {
            return false;
        }
        boolean isGuestAPI = LoginUtils.isAPIByGuestUser((ServletRequest)this.context.getRequestWrapper(), this.context.getResponseWrapper(), null, null);
        return !isGuestAPI;
    }

    @Override
    protected void doHandle() throws Exception {
        boolean result;
        String sessionId = LoginUtils.loginByGuestUser(this.context.getRequestWrapper(), this.context.getResponseWrapper());
        String form = this.guestManager.getFormId(this.context.getRequestWrapper());
        if (StringUtils.isNotEmpty(form) && (result = this.guestManager.judgeGuestFormPermission(this.context.getRequestWrapper(), this.context.getResponseWrapper(), sessionId, form))) {
            this.doResponse(new String[0]);
            return;
        }
        this.doGuestVisit(sessionId);
    }
}

