/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.handler.impl.common;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import kd.bos.context.RequestContext;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.login.handler.LoginHandlerContext;
import kd.bos.login.handler.LoginHandlerResult;
import kd.bos.login.handler.impl.AbstractLoginHandler;
import kd.bos.login.utils.LoginUtils;
import kd.bos.param.service.IParameterReaderService;
import kd.bos.service.ServiceSvcFactory;
import kd.bos.util.NetAddressUtils;
import org.apache.commons.lang3.StringUtils;

public class WPSWriteListResourceHandler
extends AbstractLoginHandler {
    public WPSWriteListResourceHandler(LoginHandlerContext context, LoginHandlerResult handlerResult) {
        super(context, handlerResult);
    }

    @Override
    public boolean isMatch() {
        return this.context.getRequestURI().contains("/attachment/v1/3rd/file/onlyoffice") || this.context.getRequestURI().contains("/attachment/v3/3rd/");
    }

    @Override
    protected void doHandle() throws Exception {
        String accountIdByWps;
        if (this.context.getRequestURI().contains("/attachment/v3/3rd/") && StringUtils.isNotBlank((CharSequence)(accountIdByWps = WPSWriteListResourceHandler.getIdentifyParam(this.context.getRequestWrapper()))) && !RequestContext.get().getAccountId().equals(accountIdByWps)) {
            logger.info("accountIdByWps=>" + accountIdByWps);
            Account account = AccountUtils.getAccountById((String)accountIdByWps);
            LoginUtils.createGuestRequestContext(this.context.getRequestWrapper(), account);
        }
        Map params = ((IParameterReaderService)ServiceSvcFactory.getService(IParameterReaderService.class)).loadPublicParameterFromCache("bos_fileserverconfig");
        String wpsv3serveraddress = (String)params.get("wpsv3serveraddress");
        String onlyofficedeployaddress = (String)params.get("onlyofficedeployaddress");
        String remoteHost = NetAddressUtils.getRemoteHost((HttpServletRequest)this.context.getRequestWrapper());
        String[] ips = remoteHost.split(",");
        List<String> ipList = Arrays.asList(ips);
        if (this.isForWpsV3(wpsv3serveraddress, ipList) || this.isForOnlyoffice(onlyofficedeployaddress, ipList)) {
            this.doForward(new String[0]);
        }
    }

    private static String getIdentifyParam(HttpServletRequest request) {
        String identifyParam = request.getHeader("X-User-Query");
        logger.info("wps v3 get custom param is:" + identifyParam);
        String accountId = "";
        if (kd.bos.login.utils.StringUtils.isNotEmpty(identifyParam)) {
            String[] params;
            for (String param : params = identifyParam.split("&")) {
                String[] kv = param.split("=");
                if (kv.length != 2 || !kv[0].equals("accountId")) continue;
                accountId = kv[1];
            }
        }
        return accountId;
    }

    private boolean isForWpsV3(String wpsv3serveraddress, List<String> ips) {
        return this.ipHandleFilter(wpsv3serveraddress, ips);
    }

    private boolean isForOnlyoffice(String onlyofficedeployaddress, List<String> ips) {
        return this.ipHandleFilter(onlyofficedeployaddress, ips);
    }

    private boolean ipHandleFilter(String address, List<String> ips) {
        if (StringUtils.isBlank((CharSequence)address)) {
            return false;
        }
        for (String ip : address.split(",")) {
            if (!ips.contains(ip)) continue;
            return true;
        }
        return false;
    }
}

