/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.handler.impl.verify;

import java.io.IOException;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.actiondispatcher.ActionUtil;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.login.LoginType;
import kd.bos.login.filter.LoginManage;
import kd.bos.login.handler.LoginHandlerContext;
import kd.bos.login.handler.LoginHandlerResult;
import kd.bos.login.handler.impl.AbstractLoginHandler;
import kd.bos.util.JSONUtils;

public class LoginValidHandler
extends AbstractLoginHandler {
    private LoginManage loginManage = new LoginManage();

    public LoginValidHandler(LoginHandlerContext context, LoginHandlerResult handlerResult) {
        super(context, handlerResult);
    }

    @Override
    public boolean isMatch() {
        return true;
    }

    @Override
    protected void doHandle() throws Exception {
        if (this.validClientSession()) {
            this.doSuccess(this.getClientSession());
            return;
        }
        this.doProcess4Fail();
    }

    private void doProcess4Fail() throws Exception {
        if (this.context.isAPI()) {
            String sLoginJson = this.getUnauthorizedData();
            ActionUtil.writeResponseJson((ServletResponse)this.context.getResponseWrapper(), (CharSequence)sLoginJson);
            this.doResponse("access api fail, session's not find");
            return;
        }
        if (this.context.getRequestURI().contains("/asimov/")) {
            try {
                this.loginManage.doYunzhijiaPubacc(this.context.getRequestWrapper(), this.context.getResponseWrapper());
            }
            catch (Exception e) {
                throw new ServletException(e.getMessage());
            }
            return;
        }
        this.loginFail(this.context.getRequestWrapper(), this.context.getResponseWrapper());
        this.doResponse(new String[0]);
    }

    private String getUnauthorizedData() throws IOException {
        HashMap<String, Object> mpErr = new HashMap<String, Object>(8);
        mpErr.put("errorCode", "401");
        mpErr.put("status", false);
        mpErr.put("message", ResManager.loadKDString((String)"\u672a\u7ecf\u6388\u6743\u7684\u8bbf\u95ee\u3002 ", (String)"LoginFilter_2", (String)"bos-login", (Object[])new Object[0]));
        mpErr.put("success", false);
        mpErr.put("error_code", 1);
        mpErr.put("error_desc", ResManager.loadKDString((String)"\u672a\u7ecf\u6388\u6743\u7684\u8bbf\u95ee\u3002 ", (String)"LoginFilter_2", (String)"bos-login", (Object[])new Object[0]));
        return JSONUtils.toString(mpErr);
    }

    private void loginFail(HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (LoginType.STANDALONE == this.context.getLoginType()) {
            this.loginManage.redirectToStandaloneLogin(request, response);
            return;
        }
        if (LoginType.MOBILE == this.context.getLoginType() && !LoginManage.enableYzjApps(this.context.getTenantId())) {
            this.loginManage.loginByLightAppId(request, response, this.context.getAppId(), this.context.getCloudTicket());
            return;
        }
        this.loginManage.authFailProcess(request, response, this.context, this.handlerResult);
    }
}

