/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.handler.impl.verify;

import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.base.parameter.ParameterService;
import kd.bos.context.RequestContextCreator;
import kd.bos.login.handler.LoginHandlerContext;
import kd.bos.login.handler.LoginHandlerResult;
import kd.bos.login.handler.impl.AbstractLoginVerifyHandler;
import kd.bos.login.service.NewPortalService;
import kd.bos.login.utils.LoginUtils;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.session.SessionInfo;
import kd.bos.util.RevProxyUtil;

public class NewPortalHandler
extends AbstractLoginVerifyHandler {
    private static final String HOME_PAGE = "home_page";
    private static final String PC_MAIN_CONSOLE = "pc_main_console";
    private static List<String> portalPage = Arrays.asList("home_page", "pc_main_console");

    public NewPortalHandler(LoginHandlerContext context, LoginHandlerResult handlerResult) {
        super(context, handlerResult);
    }

    @Override
    public boolean doMatch() {
        HttpServletRequest request = this.context.getRequestWrapper();
        return NewPortalService.isMatch(request);
    }

    @Override
    protected void doHandle() throws Exception {
        boolean isNewPortal;
        HttpServletRequest request = this.context.getRequestWrapper();
        if (NewPortalHandler.isGalaxyMode()) {
            isNewPortal = true;
        } else {
            SessionInfo sessionInfo = LoginUtils.getSessinInfoBySessionId(this.getClientSession());
            RequestContextCreator.create((HttpServletRequest)this.context.getRequestWrapper(), (String)this.getClientSession(), (SessionInfo)sessionInfo);
            Long userId = Long.valueOf(sessionInfo.getUserId());
            String accountId = sessionInfo.getAccountId();
            boolean personsetting = NewPortalService.isPersonalSettingNewPortal(userId, accountId);
            logger.info(String.format("NewPortalHandler--userId:%s, accountId:%s, personsetting:%s,", userId, accountId, personsetting));
            isNewPortal = ParameterService.enableNewPortal() && personsetting;
        }
        String form = NewPortalHandler.getFormIdByRequest(request);
        if (isNewPortal && !HOME_PAGE.equals(form)) {
            this.redirect(HOME_PAGE, request);
            this.doResponse(new String[0]);
            return;
        }
        if (!isNewPortal && !PC_MAIN_CONSOLE.equals(form)) {
            this.redirect(PC_MAIN_CONSOLE, request);
            this.doResponse(new String[0]);
        }
    }

    private void redirect(String form, HttpServletRequest request) throws Exception {
        String url = "?formId=" + form;
        String params = LoginUtils.builderParamter(request);
        url = RevProxyUtil.getURLContextPath((HttpServletRequest)request) + url + params;
        HttpServletResponse response = this.context.getResponseWrapper();
        response.sendRedirect(url);
    }

    private static String getFormIdByRequest(HttpServletRequest request) {
        return request.getParameter("formId");
    }

    private static boolean isGalaxyMode() {
        int modelType = LicenseServiceHelper.getModeType();
        return modelType == 2 || modelType == 4;
    }
}

