/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.handler.impl.verify;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.mc.tenant.AccountType;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.exception.KDException;
import kd.bos.exception.LoginErrorCode;
import kd.bos.login.CacheLoginData;
import kd.bos.login.filter.LoginManage;
import kd.bos.login.handler.LoginHandlerContext;
import kd.bos.login.handler.LoginHandlerResult;
import kd.bos.login.handler.impl.AbstractLoginVerifyHandler;
import kd.bos.login.sso.ISSOAuth;
import kd.bos.login.sso.SSOAuth;
import kd.bos.login.sso.SSOAuthResult;
import kd.bos.login.sso.SSOErrorCode;
import kd.bos.login.thirdauth.AllSSOHandler;
import kd.bos.login.thirdauth.ThirdSSOAuthHandler;
import kd.bos.login.utils.BeanUtils;
import kd.bos.login.utils.LoginUtils;
import kd.bos.login.utils.OnlineUserUtil;
import kd.bos.login.utils.StringUtils;
import kd.bos.util.RevProxyUtil;

public class SSOVerifyHandler
extends AbstractLoginVerifyHandler {
    private ISSOAuth ssoAuth;

    public SSOVerifyHandler(LoginHandlerContext context, LoginHandlerResult handlerResult) {
        super(context, handlerResult);
    }

    @Override
    public boolean doMatch() {
        AllSSOHandler.handleLogoutLogic(this.context.getRequestWrapper());
        try {
            this.ssoAuth = new SSOAuth(this.context.getRequestWrapper(), this.context.getResponseWrapper());
        }
        catch (KDException e) {
            if (SSOErrorCode.match(e.getErrorCode())) {
                return false;
            }
            throw e;
        }
        return true;
    }

    @Override
    protected void doHandle() throws Exception {
        SSOAuthResult ssoAuthResult = this.loginSSOInterceptor();
        if (ssoAuthResult.getType() == SSOAuthResult.SSOSessionType.DONOTHING) {
            return;
        }
        if (ssoAuthResult.getType() == SSOAuthResult.SSOSessionType.RESET) {
            this.loginoutForSession(this.context.getRequestWrapper(), this.context.getResponseWrapper());
            this.doFail("sso session is fail, request account is change");
            return;
        }
        throw new KDException(LoginErrorCode.systemError, new Object[0]);
    }

    private SSOAuthResult loginSSOInterceptor() {
        try {
            return this.ssoAuth.retryAuth(this.getClientSession());
        }
        catch (KDException e) {
            if (SSOErrorCode.match(e.getErrorCode())) {
                return SSOAuthResult.donothing();
            }
            throw e;
        }
    }

    private boolean loginoutForSession(HttpServletRequest request, HttpServletResponse response) {
        String sessionId = this.getClientSession();
        String accountId = "";
        String tenantId = RevProxyUtil.getTenantCode((HttpServletRequest)request);
        accountId = new LoginManage().removeSessionId(request, response, sessionId, accountId, tenantId);
        try {
            OnlineUserUtil.logout(sessionId);
        }
        catch (Exception e) {
            logger.error("onlineUser===>" + e.getMessage());
        }
        Account currentCenter = AccountUtils.getCorrectAccount((String)accountId, (String)tenantId);
        String plugin = currentCenter.getSsoPlugin();
        if (LoginUtils.hasPrevilige(AccountType.ThridParty.toString(), currentCenter.getAllSourceTypes()) && StringUtils.isNotEmpty(plugin)) {
            String cacheValue;
            boolean needExe = true;
            if (LoginUtils.isSupportLoginUnderSSO(currentCenter) && StringUtils.isNotEmpty(cacheValue = CacheLoginData.getAttribute((String)"", (String)LoginUtils.getSSOSupportCachkey(sessionId, currentCenter.getAccountId())))) {
                needExe = false;
            }
            if (needExe) {
                ThirdSSOAuthHandler sso = (ThirdSSOAuthHandler)BeanUtils.getBean(plugin);
                String site = sso.getERPCallback(request, tenantId, currentCenter.getAccountId());
                sso.callTrdSSOLogin(request, response, site);
                return true;
            }
        }
        return false;
    }
}

