/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.http;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;

public class KDFlyHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    private static final Log LOG = LogFactory.getLog(KDFlyHttpServletRequestWrapper.class);
    private final ByteArrayOutputStream outputStream = new ByteArrayOutputStream();

    public KDFlyHttpServletRequestWrapper(HttpServletRequest request) {
        super(request);
        try {
            IOUtils.copy((InputStream)request.getInputStream(), (OutputStream)this.outputStream);
        }
        catch (IOException e) {
            LOG.error("KDHttpServletRequestWrapper error:" + e.getMessage(), (Throwable)e);
        }
    }

    public ServletInputStream getInputStream() throws IOException {
        return new KDServletInputStream(this.outputStream.toByteArray());
    }

    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream()));
    }

    private static class KDServletInputStream
    extends ServletInputStream {
        private final ByteArrayInputStream inputStream;

        public KDServletInputStream(byte[] bytes) {
            this.inputStream = new ByteArrayInputStream(bytes);
        }

        public boolean isFinished() {
            return false;
        }

        public boolean isReady() {
            return false;
        }

        public void setReadListener(ReadListener readListener) {
        }

        public int read() throws IOException {
            return this.inputStream.read();
        }

        public int read(@NotNull byte[] b) throws IOException {
            return this.inputStream.read(b);
        }

        public int read(@NotNull byte[] b, int off, int len) throws IOException {
            return this.inputStream.read(b, off, len);
        }
    }
}

