/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.kapi;

import com.drew.lang.annotations.NotNull;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.cache.LoginCacheService;
import kd.bos.login.model.AuthUserDTO;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiGetMapping;
import kd.bos.openapi.common.custom.annotation.ApiMapping;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import org.apache.commons.lang3.StringUtils;

@ApiController(value="authen", desc="auth")
@ApiMapping(value="/authen")
public class ApiAuthUserController {
    private static Log logger = LogFactory.getLog(ApiAuthUserController.class);
    private LoginCacheService cacheService = new LoginCacheService();

    @ApiGetMapping(value="/getUserInfo", desc="getUserInfo")
    public CustomApiResult<AuthUserDTO> getUserInfo(@ApiParam(value="auth code") @NotNull @ApiParam(value="auth code") String code) {
        AuthUserDTO authUser = new AuthUserDTO();
        if (StringUtils.isBlank((CharSequence)code)) {
            return CustomApiResult.fail((String)"40028", (String)"code is null");
        }
        String userId = this.cacheService.get(code);
        if (StringUtils.isBlank((CharSequence)userId)) {
            logger.info(code + " is null");
            return CustomApiResult.fail((String)"40029", (String)"invalid code");
        }
        this.cacheService.remove(code);
        logger.info(code + " is remove");
        DynamicObject user = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(userId), (String)"bos_user");
        authUser.setEmail(user.getString("email"));
        authUser.setMobile(user.getString("phone"));
        authUser.setUserName(user.getString("username"));
        authUser.setName(user.getString("name"));
        authUser.setWorkNumber(user.getString("number"));
        return CustomApiResult.success((Object)authUser);
    }
}

