/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.listener;

import java.util.Map;
import kd.bos.dc.api.model.Account;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.LoginClientEnum;
import kd.bos.login.lang.LoginLangUtils;
import kd.bos.login.service.session.dto.SessionParams;
import kd.bos.login.util.cache.CacheLoginUtils;
import kd.bos.login.utils.LoginUtils;
import kd.bos.login.utils.OnlineUserUtil;
import kd.bos.login.utils.account.LoginAccountFactory;
import kd.bos.login.utils.log.LoginLogUtils;
import kd.bos.session.SessionInfo;
import kd.bos.session.SessionListener;
import kd.bos.session.SessionManager;
import kd.bos.util.JSONUtils;
import org.apache.commons.lang3.StringUtils;

public class SessionTimeoutListener
implements SessionListener {
    private static Log log = LogFactory.getLog(SessionTimeoutListener.class);

    public void destroy(String sessionId) {
        String[] data;
        String cacheData;
        if (StringUtils.isNotBlank((CharSequence)sessionId) && StringUtils.isNotBlank((CharSequence)(cacheData = SessionManager.getUserIdFromCach((String)sessionId))) && (data = cacheData.split(",")).length >= 5) {
            String userId = data[0];
            String orgId = data[1];
            String client = data[2];
            String accountId = data[3];
            String tenantId = data[4];
            String loginIp = "127.0.0.1";
            String language = "zh_CN";
            if (data.length >= 6) {
                loginIp = data[5];
            }
            if (data.length >= 7 && StringUtils.isNotBlank((CharSequence)data[6])) {
                language = data[6];
                LoginLangUtils.setLang(Lang.from((String)language));
            }
            Account currentAccount = LoginAccountFactory.createInstanceByCustom(accountId, tenantId).getAccount();
            LoginClientEnum clientEnum = LoginClientEnum.getLoginClientByValue(client);
            if (null != clientEnum && clientEnum != LoginClientEnum.BATCH) {
                SessionInfo si = new SessionInfo();
                si.setGloableSessionId(sessionId);
                si.setOrgId(orgId);
                si.setUserId(userId);
                SessionParams params = new SessionParams();
                params.setAppType(this.getAppTypeByUser(userId, tenantId, accountId, sessionId));
                params.setClientEnum(clientEnum);
                params.setIP(loginIp);
                LoginLogUtils.addLog(currentAccount, LoginLogUtils.initLoginLogInfo(si, params, "timeoutLogout"));
                this.onlineUser(sessionId, clientEnum);
            }
            try {
                LoginUtils.removeCacheSession(userId);
            }
            catch (Exception e) {
                log.error((Throwable)e);
            }
            SessionManager.removeCacheValue((String)sessionId);
            SessionManager.removeDBSession((Account)currentAccount, (String)sessionId);
        }
    }

    private void onlineUser(String sessionId, LoginClientEnum clientEnum) {
        if (clientEnum == LoginClientEnum.WEB || clientEnum == LoginClientEnum.MOBILE) {
            try {
                OnlineUserUtil.logout(sessionId);
            }
            catch (Exception e) {
                log.error("onlineUser===>" + e.getMessage());
            }
        }
    }

    private String getAppTypeByUser(String userId, String tenantId, String accountId, String sessionId) {
        String appType = null;
        try {
            String cacheKey = SessionTimeoutListener.getCacheKeyByClient(userId, tenantId, accountId);
            String[] list = CacheLoginUtils.getList((String)cacheKey);
            for (int i = 0; i < list.length; ++i) {
                String userInfo = list[i];
                Map cast = (Map)JSONUtils.cast((String)userInfo, Map.class);
                String s = (String)cast.get("sessionId");
                if (!sessionId.equals(s)) continue;
                appType = this.getAppType((String)cast.get("clientType"));
                CacheLoginUtils.removeListObject((String)cacheKey, (int)i);
                break;
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        return appType;
    }

    private String getAppType(String clientType) {
        String[] split = clientType.split("-");
        if (split.length > 1) {
            return split[1];
        }
        return null;
    }

    private static String getCacheKeyByClient(String userId, String tenantId, String accountId) {
        String sessionId = null;
        if (userId != null) {
            sessionId = tenantId + accountId + "_" + userId;
        }
        return sessionId;
    }
}

