/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.mc;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.ExceptionUtils;
import kd.bos.util.StringUtils;
import org.apache.commons.io.IOUtils;

public class ProcessHelper {
    private String[] commands;
    private int timeout = 0;
    private String message;
    private Map<String, String> env = new HashMap<String, String>();
    private static final int EXIT_CODE_SUCCESS = 0;
    private static final String RESULT_ENCODING = "gbk";
    private static final Log LOGGER = LogFactory.getLog(ProcessHelper.class);

    private ProcessHelper() {
    }

    public ProcessHelper(String[] commands) {
        this(commands, 0);
    }

    private ProcessHelper(String[] commands, int timeout) {
        this.commands = commands;
        this.timeout = timeout;
    }

    public String getMessage() {
        return this.message;
    }

    public void setEnv(String ky, String val) {
        this.env.put(ky, val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute() {
        boolean res;
        block25: {
            try {
                ProcessHelper.checkInvalidCommand(String.join((CharSequence)" ", this.commands));
            }
            catch (Exception e) {
                this.message = e.getMessage();
                return false;
            }
            res = false;
            ProcessBuilder builder = new ProcessBuilder(this.commands);
            Process process = null;
            builder.environment().putAll(this.env);
            try {
                String err = StringUtils.getEmpty();
                process = builder.start();
                if (0 != this.timeout) {
                    boolean finished = process.waitFor(this.timeout, TimeUnit.MILLISECONDS);
                    if (!finished) {
                        throw new InterruptedException(ResManager.loadKDString((String)"\u6267\u884c\u547d\u4ee4\u8d85\u65f6", (String)"ProcessHelper_0", (String)"bos-login", (Object[])new Object[0]));
                    }
                } else {
                    try (InputStream is = process.getErrorStream();){
                        err = IOUtils.toString((InputStream)is, (String)RESULT_ENCODING);
                    }
                    LOGGER.info(err);
                    process.waitFor();
                }
                int exitValue = process.exitValue();
                if (0 == exitValue) {
                    this.message = ResManager.loadKDString((String)"\u6267\u884c\u547d\u4ee4\u5b8c\u6210", (String)"ProcessHelper_1", (String)"bos-login", (Object[])new Object[0]);
                    res = true;
                    break block25;
                }
                throw new IOException(err);
            }
            catch (IOException | InterruptedException e) {
                LOGGER.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                this.message = String.format(ResManager.loadKDString((String)"\u6267\u884c\u547d\u4ee4\u65f6\u51fa\u9519\uff1a%s", (String)"ProcessHelper_2", (String)"bos-login", (Object[])new Object[0]), e.getMessage());
            }
            finally {
                if (null != process) {
                    process.destroy();
                }
            }
        }
        return res;
    }

    private static void checkInvalidCommand(String value) throws Exception {
        String commandRegex = "[.]{2}|[|&`]+|touch";
        Pattern pattern = Pattern.compile(commandRegex);
        Matcher matcher = pattern.matcher(value);
        if (matcher.find()) {
            throw new Exception(ResManager.loadKDString((String)"\u8be5\u64cd\u4f5c\u5b58\u5728\u547d\u4ee4\u6ce8\u5165\u98ce\u9669\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570", (String)"ProcessHelper_3", (String)"bos-login", (Object[])new Object[0]));
        }
    }
}

