/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.route;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.login.CacheLoginData;
import kd.bos.login.route.RouteService;
import kd.bos.login.utils.LoginUtils;
import kd.bos.share.NoCodeShare;
import kd.bos.share.service.NoCodeShareSerivce;
import kd.bos.share.service.ShareSerivce;
import kd.bos.share.session.ShareSession;
import org.apache.commons.lang3.StringUtils;

public class ShareRouteService
implements RouteService {
    private ShareSerivce shareSerivce = new NoCodeShareSerivce();
    private static final String NO_CODE_SHARE_PREFIX = "/share/";
    private static final String UNDER_LINE = "_";
    private static final String errorCode = "40100";

    @Override
    public String route(HttpServletRequest request, HttpServletResponse response) throws IOException {
        return this.route(request, response, null);
    }

    @Override
    public String route(HttpServletRequest request, HttpServletResponse response, String cookie) throws IOException {
        String uri = request.getRequestURI();
        String[] shares = uri.split(NO_CODE_SHARE_PREFIX);
        String shareid = null;
        if (shares.length != 0) {
            shareid = shares[1];
        }
        if (shareid == null) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u6ca1\u6709shareid\uff01", (String)"ShareRouteService_0", (String)"bos-login", (Object[])new Object[0]));
        }
        if (shareid.contains(UNDER_LINE)) {
            String[] strings = shareid.split(UNDER_LINE);
            if (!StringUtils.isNumeric((CharSequence)strings[0])) {
                return null;
            }
            cookie = this.getCurrentCookie(request, strings[1]);
            if (cookie != null) {
                return cookie;
            }
            NoCodeShare noCodeShare = (NoCodeShare)this.shareSerivce.getShareById(strings[0], strings[1]);
            Long now = System.currentTimeMillis();
            if (now > noCodeShare.getExpireTime()) {
                throw new KDException(new ErrorCode(errorCode, ResManager.loadKDString((String)"\u5206\u4eab\u94fe\u63a5\u5df2\u8fc7\u671f\uff01", (String)"ShareRouteService_1", (String)"bos-login", (Object[])new Object[0])), new Object[0]);
            }
            if (noCodeShare == null) {
                throw new KDException(new ErrorCode(errorCode, ResManager.loadKDString((String)"\u5206\u4eab\u94fe\u63a5\u5df2\u5931\u6548\uff01", (String)"ShareRouteService_2", (String)"bos-login", (Object[])new Object[0])), new Object[0]);
            }
            return ShareSession.getShareSessionId(request, response, strings[0], strings[1], strings[2]);
        }
        return null;
    }

    private String getCurrentCookie(HttpServletRequest request, String accountId) {
        String userId;
        String shareIdCache;
        String cookie = LoginUtils.getKDCookieValue(request, accountId);
        if (cookie != null && StringUtils.isEmpty((CharSequence)(shareIdCache = CacheLoginData.getAttribute((String)"nocode_share", (String)cookie))) && StringUtils.isNotEmpty((CharSequence)(userId = LoginUtils.getUserIdFromSession(cookie, true))) && !"-1".equals(userId) && !"0".equals(userId)) {
            return cookie;
        }
        return null;
    }

    private boolean validationUrl(String url, String shareUrl) {
        return url.contains(shareUrl);
    }
}

