/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.service.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.model.Language;
import kd.bos.login.service.ICustomLoginConfigService;
import kd.bos.login.service.dto.CustomLoginParams;
import kd.bos.login.utils.LoginUtils;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.util.RevProxyUtil;

public class CustomLoginConfigService
implements ICustomLoginConfigService {
    private static Log logger = LogFactory.getLog(CustomLoginConfigService.class);

    @Override
    public Map<String, Object> getLoginConfigServiceData(HttpServletRequest request, String type) {
        Map<String, Object> map = new HashMap<String, Object>();
        try {
            String tenantId = RevProxyUtil.getTenantCode((HttpServletRequest)request);
            String accountIdParameter = request.getParameter("accountId");
            Account currentCenter = AccountUtils.getCorrectAccount((String)accountIdParameter, (String)tenantId);
            List<Language> lList = LoginUtils.getAllLanguagesByAccount(currentCenter);
            List numList = lList.stream().map(Language::getNumber).collect(Collectors.toList());
            CustomLoginParams loginParams = new CustomLoginParams();
            loginParams.setLangList(numList);
            loginParams.initRequestParams(request);
            loginParams.setType(type);
            loginParams.setAccountId(accountIdParameter);
            map = (Map)DispatchServiceHelper.invokeBOSService((String)"bos", (String)"IExtLoginConfigService", (String)"getLoginConfigServiceData", (Object[])new Object[]{loginParams, ""});
        }
        catch (KDException e) {
            logger.error("getLoginConfigService error", (Throwable)e);
        }
        return map;
    }

    @Override
    public Map<String, Object> getLoginConfigServiceData(HttpServletRequest request) {
        return this.getLoginConfigServiceData(request, "bizextplugin");
    }

    @Override
    public Map<String, Object> getLoginConfigExtData(HttpServletRequest request, String type) {
        Map<String, Object> map = new HashMap<String, Object>();
        try {
            map = (Map)DispatchServiceHelper.invokeBOSService((String)"bos", (String)"IExtLoginConfigService", (String)"getExtData", (Object[])new Object[]{"BOS_SVC_LOGIN_PAGE_PARAM", type});
        }
        catch (KDException e) {
            logger.error("getExtData error", (Throwable)e);
        }
        return map;
    }

    @Override
    public Map<String, Object> getLoginConfigExtData(HttpServletRequest request) {
        return this.getLoginConfigExtData(request, "bizextplugin");
    }
}

