/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.service.impl;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.route.RouteService;
import kd.bos.login.service.NewPortalService;
import kd.bos.login.utils.LoginUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.RevProxyUtil;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class FormRouteServiceImpl
implements RouteService {
    private static final Log logger = LogFactory.getLog(FormRouteServiceImpl.class);
    private static final String MOBILE_HTML = "mobile.html";
    private static final String INDEX_HTML = "index.html";
    private static final String FORM = "form";
    private static final String FORM_ID = "formId";
    private static final String CLIENT_TYPE = "web";

    @Override
    public boolean isJumpRoute(HttpServletRequest request, HttpServletResponse response, String sessionId) throws IOException {
        boolean isHandle = NewPortalService.newPortalFilter(request, response, sessionId);
        if (isHandle) {
            return true;
        }
        return this.thirdAppJumpRoute(request, response);
    }

    public boolean thirdAppJumpRoute(HttpServletRequest request, HttpServletResponse response) {
        try {
            String lightAppId = this.getLightAppId(request);
            if (StringUtils.isBlank((CharSequence)lightAppId)) {
                return false;
            }
            Map<String, String> routeSchemes = this.getThirdAppRouteSchemes(lightAppId);
            if (ObjectUtils.isEmpty(routeSchemes)) {
                return false;
            }
            if (!request.getRequestURI().endsWith(MOBILE_HTML) && !request.getRequestURI().endsWith(INDEX_HTML)) {
                return false;
            }
            String url = "";
            if (request.getRequestURI().endsWith(MOBILE_HTML)) {
                if (StringUtils.isBlank((CharSequence)routeSchemes.get(request.getParameter(FORM)))) {
                    return false;
                }
                url = "mobile.html?form=" + routeSchemes.get(request.getParameter(FORM));
            } else if (request.getRequestURI().endsWith(INDEX_HTML)) {
                String formId = routeSchemes.get(CLIENT_TYPE + request.getParameter(FORM_ID));
                if (StringUtils.isBlank((CharSequence)formId)) {
                    return false;
                }
                url = "index.html?formId=" + formId;
            }
            String params = LoginUtils.builderParamter(request);
            url = RevProxyUtil.getURLContextPath((HttpServletRequest)request) + url + params;
            response.sendRedirect(url);
            return true;
        }
        catch (Exception e) {
            logger.error("FormRouteServiceImpl--error", (Throwable)e);
            return false;
        }
    }

    private String getLightAppId(HttpServletRequest request) {
        String lightAppId = request.getParameter("lightAppId");
        if (StringUtils.isBlank((CharSequence)lightAppId) && StringUtils.isNotBlank((CharSequence)request.getParameter("ticket"))) {
            lightAppId = request.getParameter("appid");
        }
        if (StringUtils.isBlank((CharSequence)lightAppId) && StringUtils.isNotBlank((CharSequence)request.getParameter("ticket"))) {
            lightAppId = request.getParameter("client_id");
        }
        if (StringUtils.isBlank((CharSequence)lightAppId) && StringUtils.isNotBlank((CharSequence)request.getParameter("code"))) {
            lightAppId = request.getParameter("appkey");
        }
        if (StringUtils.isBlank((CharSequence)lightAppId) && StringUtils.isNotBlank((CharSequence)request.getParameter("code"))) {
            lightAppId = request.getParameter("agentid");
        }
        if (StringUtils.isBlank((CharSequence)lightAppId) && StringUtils.isNotBlank((CharSequence)request.getParameter("code"))) {
            lightAppId = request.getParameter("flyBookAppId");
        }
        return lightAppId;
    }

    private Map<String, String> getThirdAppRouteSchemes(String lightAppId) {
        HashMap<String, String> result = new HashMap<String, String>(2);
        DynamicObject[] routeSchemes = BusinessDataServiceHelper.load((String)"third_app_route_schemes", (String)"sourceform.number,destform.number,mobilesourceform.number,mobiledestform.number", (QFilter[])new QFilter[]{new QFilter("thirdappid", "=", (Object)lightAppId), new QFilter("enable", "=", (Object)"1")});
        if (ObjectUtils.isEmpty((Object)routeSchemes)) {
            return result;
        }
        DynamicObject routeScheme = routeSchemes[0];
        if (StringUtils.isNotBlank((CharSequence)routeScheme.getString("sourceform.number")) && StringUtils.isNotBlank((CharSequence)routeScheme.getString("destform.number"))) {
            result.put(CLIENT_TYPE + routeScheme.getString("sourceform.number"), routeScheme.getString("destform.number"));
        }
        if (StringUtils.isNotBlank((CharSequence)routeScheme.getString("mobilesourceform.number")) && StringUtils.isNotBlank((CharSequence)routeScheme.getString("mobiledestform.number"))) {
            result.put(routeScheme.getString("mobilesourceform.number"), routeScheme.getString("mobiledestform.number"));
        }
        return result;
    }

    @Override
    public String route(HttpServletRequest request, HttpServletResponse response) throws IOException {
        return null;
    }

    @Override
    public String route(HttpServletRequest request, HttpServletResponse response, String cookie) throws IOException {
        return null;
    }
}

