/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.service.impl;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import kd.bos.dc.api.model.Account;
import kd.bos.encrypt.Encrypters;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.CacheLoginData;
import kd.bos.login.api.APILoginError;
import kd.bos.login.model.KeyValuePair;
import kd.bos.login.service.IUpgradeAuthService;
import kd.bos.login.utils.KeyValueUtils;
import kd.bos.login.utils.ShaSignUtils;
import kd.bos.login.utils.SystemPropertyUtils;
import kd.bos.util.StringUtils;

public class UpgradeAuthServiceImpl
implements IUpgradeAuthService {
    private static Log logger = LogFactory.getLog(UpgradeAuthServiceImpl.class);
    private static Integer SIGN_TIMEOUT = 600;

    @Override
    public boolean mcUpgradeAuth(Account currentCenter, HttpServletRequest request) {
        String contentSign = request.getHeader("contentSign");
        String mcVal = SystemPropertyUtils.getProptyByTenant("mc_auth_login_appVal", currentCenter.getTenantId());
        if (StringUtils.isNotEmpty((String)mcVal)) {
            String timeStamp = request.getHeader("timeStamp");
            String contentSignCache = CacheLoginData.getAttribute((String)"mcUpgradeAuth", (String)contentSign);
            if (StringUtils.isNotEmpty((String)contentSignCache)) {
                throw new KDException(APILoginError.API_REQUEST_INVALID_PARAMETERS, new Object[]{contentSign + "sign is used."});
            }
            if (UpgradeAuthServiceImpl.checkDateTime(timeStamp)) {
                KeyValuePair ac = new KeyValuePair("accountId", currentCenter.getAccountId());
                KeyValuePair te = new KeyValuePair("tenantid", currentCenter.getTenantId());
                KeyValuePair t = new KeyValuePair("timeStamp", timeStamp);
                List<KeyValuePair> list = Arrays.asList(t, ac, te);
                if (Encrypters.isEncrypted((String)mcVal)) {
                    mcVal = Encrypters.decode((String)mcVal);
                }
                byte[] s = mcVal.getBytes(StandardCharsets.UTF_8);
                String sign = ShaSignUtils.hmacSHA256(KeyValueUtils.arrayAscToString(list).getBytes(StandardCharsets.UTF_8), s);
                Arrays.fill(s, (byte)-128);
                if (StringUtils.isEmpty((String)contentSign) || !contentSign.equalsIgnoreCase(sign)) {
                    throw new KDException(APILoginError.API_REQUEST_INVALID_PARAMETERS, new Object[]{"contentSign is null or contentSign is not correct."});
                }
                CacheLoginData.setAttribute((String)"mcUpgradeAuth", (String)contentSign, (String)contentSign, (int)SIGN_TIMEOUT);
            }
        }
        return true;
    }

    private static boolean checkDateTime(String timeStamp) {
        long now = System.currentTimeMillis();
        if (StringUtils.isEmpty((String)timeStamp) || StringUtils.isNotEmpty((String)timeStamp) && StringUtils.isNumeric((String)timeStamp) && Math.abs(now - Long.parseLong(timeStamp)) / 1000L > (long)SIGN_TIMEOUT.intValue()) {
            throw new KDException(APILoginError.API_REQUEST_INVALID_PARAMETERS, new Object[]{"timeStamp is null or timeStamp is no correct."});
        }
        return true;
    }
}

