/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.service.openapi;

import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.api.ApiRequestContext;
import kd.bos.context.api.ApiContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dc.api.model.Account;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.LoginClientEnum;
import kd.bos.login.filter.LoginManage;
import kd.bos.login.service.openapi.TokenErrorCode;
import kd.bos.login.service.session.SessionService;
import kd.bos.login.service.session.SessionServiceFactory;
import kd.bos.login.service.session.dto.SessionParams;
import kd.bos.login.user.LoginUserService;
import kd.bos.login.utils.ThirdAPIAPPUtils;
import kd.bos.login.utils.account.LoginAccountFactory;
import kd.bos.service.authorize.model.AccessTokenInfo;
import kd.bos.service.authorize.model.AccessTokenRequest;
import kd.bos.service.authorize.model.ApiCommonResult;
import kd.bos.service.authorize.model.OAuth2Authentication;
import kd.bos.service.authorize.token.AccessTokenService;
import kd.bos.session.SessionDAO;
import kd.bos.session.SessionDAOFactory;
import kd.bos.session.SessionManager;
import kd.bos.util.NetAddressUtils;
import org.apache.commons.lang3.StringUtils;

public class AccessTokenServiceImpl
implements AccessTokenService {
    private static final String BOS_LOGIN = "bos-login";
    private static Log logger = LogFactory.getLog(AccessTokenServiceImpl.class);
    private SessionService sessionService = SessionServiceFactory.createSessionService(LoginClientEnum.NEWAPI);

    public ApiCommonResult<AccessTokenInfo> generateAccessToken(AccessTokenRequest tokenRequest) {
        try {
            ApiRequestContext context = ApiRequestContext.get();
            HttpServletRequest request = context.getRequest();
            HttpServletResponse response = context.getResponse();
            Account account = LoginAccountFactory.createInstanceByCustom(tokenRequest.getAccountId()).getAccount();
            if (account == null) {
                return new ApiCommonResult().fail(ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef\uff0c\u65e0\u6cd5\u83b7\u53d6\u79df\u6237ID\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"LoginAPI_4", (String)BOS_LOGIN, (Object[])new Object[0]), TokenErrorCode.API_REQUEST_INVALID_PARAMETERS.getCode());
            }
            Map<String, String> userInfo = LoginUserService.getErpUserInfoByUserId(account, String.valueOf(tokenRequest.getAgentUserId()), tokenRequest.getLang());
            if (userInfo.isEmpty()) {
                return new ApiCommonResult().fail(ResManager.loadKDString((String)"\u60a8\u7684\u8d26\u53f7\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u3002", (String)"LoginFilter_10", (String)BOS_LOGIN, (Object[])new Object[0]), TokenErrorCode.API_REQUEST_INVALID_PARAMETERS.getCode());
            }
            ApiContext apiContext = ApiContext.create();
            apiContext.setAppId(tokenRequest.getThirdId());
            apiContext.setAppNum(tokenRequest.getThirdAppNumber());
            ApiContext.set((ApiContext)apiContext);
            SessionParams sessionParams = new SessionParams();
            sessionParams.setClientEnum(LoginClientEnum.NEWAPI);
            sessionParams.setMpUser(userInfo);
            sessionParams.setLang(Lang.from((String)tokenRequest.getLang()));
            sessionParams.setIP(NetAddressUtils.getRemoteHost((HttpServletRequest)request));
            sessionParams.setCopyToClient(true);
            sessionParams.setTimeOut(ThirdAPIAPPUtils.getTokenTimeout(tokenRequest.getTenantId()));
            String sessionId = this.sessionService.getSession(request, response, account, sessionParams);
            AccessTokenInfo accessTokenInfo = new AccessTokenInfo();
            accessTokenInfo.setToken(sessionId);
            accessTokenInfo.setTokenType("access_token");
            accessTokenInfo.setExpires(Long.valueOf(this.getExpiredTime(SessionDAOFactory.getSessionDAO((String)sessionId), null)));
            return new ApiCommonResult().success((Object)accessTokenInfo);
        }
        catch (Exception ex) {
            logger.error((Throwable)ex);
            return new ApiCommonResult().fail(ex.getMessage(), TokenErrorCode.SERVICE_ERROR.getCode());
        }
    }

    public ApiCommonResult<AccessTokenInfo> refreshAccessToken(OAuth2Authentication authentication) {
        ApiCommonResult<AccessTokenInfo> result = this.verifyAccessToken(authentication);
        if (!result.getStatus().booleanValue()) {
            return result;
        }
        Account account = LoginAccountFactory.createInstanceByCustom(authentication.getAccountId()).getAccount();
        if (account == null) {
            return new ApiCommonResult().fail(ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef\uff0c\u65e0\u6cd5\u83b7\u53d6\u79df\u6237ID\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"LoginAPI_4", (String)BOS_LOGIN, (Object[])new Object[0]), TokenErrorCode.API_REQUEST_INVALID_PARAMETERS.getCode());
        }
        String token = authentication.getToken().getToken();
        SessionManager.touchSession((String)token);
        AccessTokenInfo accessTokenInfo = authentication.getToken();
        accessTokenInfo.setExpires(Long.valueOf(this.getExpiredTime(account.getTenantId())));
        return new ApiCommonResult().success((Object)accessTokenInfo);
    }

    public ApiCommonResult<String> withdrawAccessToken(OAuth2Authentication authentication) {
        ApiRequestContext context = ApiRequestContext.get();
        HttpServletRequest request = context.getRequest();
        HttpServletResponse response = context.getResponse();
        Account account = LoginAccountFactory.createInstanceByCustom(authentication.getAccountId()).getAccount();
        if (account == null) {
            return new ApiCommonResult().fail(ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef\uff0c\u65e0\u6cd5\u83b7\u53d6\u79df\u6237ID\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"LoginAPI_4", (String)BOS_LOGIN, (Object[])new Object[0]), TokenErrorCode.API_REQUEST_INVALID_PARAMETERS.getCode());
        }
        AccessTokenInfo accessTokenInfo = authentication.getToken();
        new LoginManage().removeSessionId(request, response, accessTokenInfo.getToken(), account.getAccountId(), account.getTenantId());
        return ApiCommonResult.getSuccessResult((String)"0", null);
    }

    public ApiCommonResult<AccessTokenInfo> verifyAccessToken(OAuth2Authentication authentication) {
        AccessTokenInfo accessTokenInfo = authentication.getToken();
        Map<String, String> sessionInfo = this.getSessionInfo(accessTokenInfo.getToken());
        if (!authentication.getAccountId().equals(sessionInfo.get("accountId"))) {
            return new ApiCommonResult().fail("session is not find", TokenErrorCode.UNAUTHORIZED_ACCESS.getCode());
        }
        accessTokenInfo.setExpires(Long.valueOf(this.getExpiredTime(SessionDAOFactory.getSessionDAO((String)accessTokenInfo.getToken()), sessionInfo)));
        return new ApiCommonResult().success((Object)accessTokenInfo);
    }

    public ApiCommonResult<String> getAccountIdByToken(OAuth2Authentication authentication) {
        Map<String, String> sessionInfo = this.getSessionInfo(authentication.getToken().getToken());
        String accountId = sessionInfo.get("accountId");
        if (StringUtils.isBlank((CharSequence)accountId)) {
            return new ApiCommonResult().fail("Session not found", TokenErrorCode.UNAUTHORIZED_ACCESS.getCode());
        }
        return new ApiCommonResult().success((Object)accountId);
    }

    private Map<String, String> getSessionInfo(String token) {
        SessionDAO sessionDAO = SessionDAOFactory.getSessionDAO((String)token);
        return sessionDAO.getAttributesAsMap(new String[]{"tenantId", "sandboxId", "language", "userId", "userName", "userOpenId", "orgId", "userType", "yzjAppId", "yzjAppTicket", "accountId", "uid", "loginOrg", "client", "expiredTime"});
    }

    private long getExpiredTime(SessionDAO sessionDAO, Map<String, String> sessionInfo) {
        String expiredTime;
        if (sessionInfo == null) {
            sessionInfo = sessionDAO.getAttributesAsMap(new String[]{"expiredTime"});
        }
        if (StringUtils.isBlank((CharSequence)(expiredTime = sessionInfo.get("expiredTime")))) {
            return 0L;
        }
        return Long.parseLong(expiredTime);
    }

    private long getExpiredTime(String tenantId) {
        LocalDateTime now = LocalDateTime.now();
        now = now.plusSeconds(ThirdAPIAPPUtils.getTokenTimeout(tenantId));
        return now.toInstant(ZoneOffset.of("+8")).toEpochMilli();
    }
}

