/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.sso;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.sso.LMBCSUtil;
import org.apache.commons.codec.binary.Base64;

public class LtpaToken {
    private static final String UTF_8 = "UTF-8";
    private static Log logger = LogFactory.getLog(LtpaToken.class);
    private byte[] creation;
    private Date creationDate;
    private byte[] digest;
    private byte[] expires;
    private Date expiresDate;
    private byte[] hash;
    private byte[] header;
    private String tokenStr;
    private byte[] rawToken;
    private byte[] user;

    public LtpaToken() {
        this.init();
    }

    public LtpaToken(String token) {
        int i;
        this.init();
        this.tokenStr = token;
        this.rawToken = Base64.decodeBase64((String)token);
        this.user = new byte[this.rawToken.length - 40];
        for (i = 0; i < 4; ++i) {
            this.header[i] = this.rawToken[i];
        }
        for (i = 4; i < 12; ++i) {
            this.creation[i - 4] = this.rawToken[i];
        }
        for (i = 12; i < 20; ++i) {
            this.expires[i - 12] = this.rawToken[i];
        }
        for (i = 20; i < this.rawToken.length - 20; ++i) {
            this.user[i - 20] = this.rawToken[i];
        }
        for (i = this.rawToken.length - 20; i < this.rawToken.length; ++i) {
            this.digest[i - (this.rawToken.length - 20)] = this.rawToken[i];
        }
        this.creationDate = new Date(Long.parseLong(new String(this.creation), 16) * 1000L);
        this.expiresDate = new Date(Long.parseLong(new String(this.expires), 16) * 1000L);
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public MessageDigest getMessageDigest() {
        try {
            return MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException nsae) {
            logger.error((Throwable)nsae);
            return null;
        }
    }

    public Date getExpiresDate() {
        return this.expiresDate;
    }

    public String getUsername() {
        String userName = null;
        try {
            userName = new String(this.user, UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            userName = new String(this.user);
        }
        return userName;
    }

    public String getUsername(String code) {
        String userName = null;
        try {
            userName = new String(this.user, code);
        }
        catch (UnsupportedEncodingException e) {
            userName = new String(this.user);
        }
        return userName;
    }

    private void init() {
        this.creation = new byte[8];
        this.digest = new byte[20];
        this.expires = new byte[8];
        this.hash = new byte[20];
        this.header = new byte[4];
    }

    public boolean isValid(String secretKey) {
        boolean validDigest = false;
        boolean validDateRange = false;
        byte[] bytes = null;
        Date now = new Date();
        MessageDigest md = this.getMessageDigest();
        bytes = LMBCSUtil.concatenate(bytes, this.header);
        bytes = LMBCSUtil.concatenate(bytes, this.creation);
        bytes = LMBCSUtil.concatenate(bytes, this.expires);
        bytes = LMBCSUtil.concatenate(bytes, this.user);
        bytes = LMBCSUtil.concatenate(bytes, Base64.decodeBase64((String)secretKey));
        byte[] newDigest = md.digest(bytes);
        validDigest = MessageDigest.isEqual(this.digest, newDigest);
        validDateRange = now.before(this.expiresDate);
        boolean result = validDigest && validDateRange;
        logger.info(String.format("creationDate[%s]<now[%s]<expiresDate[%s],validDateRange:%s,verify result:%s.", this.creationDate, now, this.expiresDate, validDateRange, result));
        return result;
    }

    public String toString() {
        return LtpaToken.encodeToken(this.tokenStr);
    }

    public byte[] getCreation() {
        return this.creation;
    }

    public void setCreation(byte[] creation) {
        this.creation = creation;
    }

    public byte[] getExpires() {
        return this.expires;
    }

    public void setExpires(byte[] expires) {
        this.expires = expires;
    }

    public byte[] getHeader() {
        return this.header;
    }

    public void setHeader(byte[] header) {
        this.header = header;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public void setDigest(byte[] digest) {
        this.digest = digest;
    }

    public void setExpiresDate(Date expiresDate) {
        this.expiresDate = expiresDate;
    }

    public void setUser(byte[] user) {
        this.user = user;
    }

    public byte[] getUser() {
        return this.user;
    }

    public String getTokenStr() {
        return LtpaToken.encodeToken(this.tokenStr);
    }

    public static String encodeToken(String token) {
        try {
            return URLEncoder.encode(URLEncoder.encode(URLEncoder.encode(token, UTF_8), UTF_8), UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            logger.error("Token encode error[UnsupportedEncodingException]!");
            return token;
        }
    }

    public static String decodeToken(String token) {
        if (token.indexOf(43) == -1) {
            try {
                String decodeToken1 = URLDecoder.decode(token, UTF_8);
                if (decodeToken1.indexOf(43) == -1) {
                    String decodeToken2 = URLDecoder.decode(decodeToken1, UTF_8);
                    if (decodeToken2.indexOf(43) == -1) {
                        return URLDecoder.decode(decodeToken2, UTF_8);
                    }
                    return decodeToken2;
                }
                return decodeToken1;
            }
            catch (UnsupportedEncodingException e) {
                logger.error("Token decode error[UnsupportedEncodingException]!");
            }
        }
        return token;
    }
}

