/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.sso;

import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.lang.Lang;
import kd.bos.login.lang.LoginLangUtils;
import kd.bos.login.thirdauth.ThirdSSOAuthHandler;
import kd.bos.login.thirdauth.UserAuthResult;
import kd.bos.login.utils.BeanUtils;
import kd.bos.login.utils.SystemPropertyUtils;
import kd.bos.login.utils.account.LoginAccountFactory;
import kd.bos.util.RevProxyUtil;
import org.apache.commons.lang3.StringUtils;

public class SSOAnalysis {
    public static Lang getLangForSSO(HttpServletRequest request, UserAuthResult uar) {
        return uar.getLangugage() != null ? uar.getLangugage() : LoginLangUtils.getLoginLanguage(request);
    }

    public static Account getAccountForSSO(HttpServletRequest request) {
        String accountIdForSSO = SSOAnalysis.getAccountIdForSSO(request);
        if (StringUtils.isNotBlank((CharSequence)accountIdForSSO)) {
            return AccountUtils.getAccountById((String)accountIdForSSO);
        }
        return LoginAccountFactory.createInstanceByHttpRequest(request, Optional.of(SSOAnalysis.getTenantNoForSSO(request))).getAccount();
    }

    public static String getAccountIdForSSO(HttpServletRequest request) {
        String ssoPluginName = SystemPropertyUtils.getProptyByTenant("svc_login_session_sso_plugin", RevProxyUtil.getTenantId((HttpServletRequest)request));
        if (StringUtils.isNotBlank((CharSequence)ssoPluginName)) {
            ThirdSSOAuthHandler ssoAuthHandler = (ThirdSSOAuthHandler)BeanUtils.getBean(ssoPluginName);
            return ssoAuthHandler.getSSOAccount(request);
        }
        return null;
    }

    public static String getTenantNoForSSO(HttpServletRequest request) {
        String tenantNo = request.getParameter("tenantNo");
        if (kd.bos.login.utils.StringUtils.isEmpty(tenantNo)) {
            tenantNo = RevProxyUtil.getTenantCode((HttpServletRequest)request);
        }
        if (kd.bos.login.utils.StringUtils.isEmpty(tenantNo)) {
            tenantNo = System.getProperty("login.sso.tenantno");
        }
        return tenantNo;
    }
}

