/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.sso;

import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dc.api.model.Account;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.LoginClientEnum;
import kd.bos.login.model.SSOAuthConfig;
import kd.bos.login.service.ThirdAppService;
import kd.bos.login.sso.ISSOAuth;
import kd.bos.login.sso.ISSOLogin;
import kd.bos.login.sso.MultiTenantSSOAuth;
import kd.bos.login.sso.SSOAnalysis;
import kd.bos.login.sso.SSOAuthResult;
import kd.bos.login.sso.SSOAuthValidator;
import kd.bos.login.thirdauth.AllSSOHandler;
import kd.bos.login.thirdauth.ThirdSSOAuthHandler;
import kd.bos.login.thirdauth.UserAuthResult;
import kd.bos.login.utils.AgentUtil;
import kd.bos.login.utils.BeanUtils;
import kd.bos.login.utils.Constants;
import kd.bos.login.utils.LoginUtils;
import kd.bos.login.utils.SessionUtils;
import kd.bos.login.utils.account.LoginAccountFactory;
import kd.bos.login.yunzhijia.YZJSpecialUtils;
import kd.bos.session.SessionDAO;
import kd.bos.session.SessionDAOFactory;
import kd.bos.util.JSONUtils;
import kd.bos.util.NetAddressUtils;
import org.apache.commons.lang3.StringUtils;

public class SSOAuth
implements ISSOAuth,
ISSOLogin {
    private static Log logger = LogFactory.getLog(SSOAuth.class);
    private static final String BOS_LOGIN = "bos-login";
    private static final String ACCOUNT_ID = "accountId";
    private HttpServletRequest request;
    private HttpServletResponse response;
    private String tenantNo;
    private Account currentCenter;
    private ThirdSSOAuthHandler ssoAuthHandler;
    private SSOAuthConfig ssoAuthConfig;
    private SSOAuthValidator validator = new SSOAuthValidator();

    public SSOAuth(HttpServletRequest request, HttpServletResponse response) {
        this.init(request, response);
    }

    private void init(HttpServletRequest request, HttpServletResponse response) {
        this.ssoAuthConfig = ThirdAppService.getThirdSSOAuthConfig(request.getParameter("app_client_id"), request.getParameter("thirdAccountId"), "1");
        this.validator.checkParam(request);
        if (StringUtils.isBlank((CharSequence)this.ssoAuthConfig.getIntegMode())) {
            this.validator.checkOpenSSOByMC(request);
        }
        this.request = request;
        this.response = response;
        this.tenantNo = SSOAnalysis.getTenantNoForSSO(request);
        this.currentCenter = SSOAnalysis.getAccountForSSO(request);
        if ("0".equals(this.ssoAuthConfig.getIntegMode())) {
            this.ssoAuthHandler = new MultiTenantSSOAuth();
        } else {
            String ssoPlugin = this.currentCenter.getSsoPlugin();
            if (StringUtils.isNotBlank((CharSequence)this.ssoAuthConfig.getSsoPlugin())) {
                ssoPlugin = this.ssoAuthConfig.getSsoPlugin();
            }
            try {
                this.ssoAuthHandler = (ThirdSSOAuthHandler)BeanUtils.getBean(ssoPlugin);
            }
            catch (Exception e) {
                this.ssoAuthHandler = new MultiTenantSSOAuth();
            }
        }
    }

    @Override
    public SSOAuthResult retryAuth(String sessionId) {
        UserAuthResult uar;
        Map<String, String> userInfo;
        SessionDAO sessionDAO = SessionDAOFactory.getSessionDAO((String)sessionId);
        Map sessionInfo = sessionDAO.getAttributesAsMap(new String[]{"tenantId", "sandboxId", "language", "userId", "userName", "userOpenId", "orgId", "userType", "yzjAppId", "yzjAppTicket", ACCOUNT_ID, "uid", "loginOrg", "client"});
        String accountId = this.request.getParameter(ACCOUNT_ID);
        if (StringUtils.isNotBlank((CharSequence)accountId) && !accountId.equals(sessionInfo.get(ACCOUNT_ID))) {
            return SSOAuthResult.reset();
        }
        String oldUserId = LoginUtils.getUserIdFromSession(sessionDAO, sessionId);
        boolean needSSOAuth4UserChange = this.ssoAuthHandler.isNeedSSOAuth4UserChange(this.request);
        if (StringUtils.isNotBlank((CharSequence)oldUserId) && needSSOAuth4UserChange && (userInfo = this.matchUserInfo(uar = this.getUserAuthResult())) != null && !oldUserId.equals(userInfo.get("fid"))) {
            return SSOAuthResult.reset();
        }
        return SSOAuthResult.donothing();
    }

    @Override
    public SSOAuthResult auth() {
        UserAuthResult uar = this.getUserAuthResult();
        Map<String, String> userInfo = this.matchUserInfo(uar);
        String session = this.createSession(userInfo, uar);
        this.processForYZJSpecialVer(uar, userInfo);
        return SSOAuthResult.set(session);
    }

    @Override
    public void callSSOLogin(String redirectUrl) {
        String site = this.ssoAuthHandler.getERPCallback(this.request, this.tenantNo, this.currentCenter.getAccountId());
        if (StringUtils.isNotBlank((CharSequence)redirectUrl)) {
            site = redirectUrl;
        }
        this.ssoAuthHandler.callTrdSSOLogin(this.request, this.response, site);
    }

    private UserAuthResult getUserAuthResult() {
        UserAuthResult uar = this.ssoAuthHandler.getTrdSSOAuth(this.request, this.response);
        this.currentCenter = this.tryChangeAccount(uar);
        this.validator.checkAuth(uar);
        return uar;
    }

    private Account tryChangeAccount(UserAuthResult uar) {
        if (uar == null || !uar.isSucess()) {
            return this.currentCenter;
        }
        if (StringUtils.isNotBlank((CharSequence)uar.getAccountId())) {
            this.currentCenter = LoginAccountFactory.createInstanceByCustom(uar.getAccountId(), this.tenantNo).getAccount();
        }
        return this.currentCenter;
    }

    private Map<String, String> matchUserInfo(UserAuthResult uar) {
        Map<String, String> userInfo = LoginUtils.getUserInfoByUserResultByType(SSOAnalysis.getLangForSSO(this.request, uar), this.currentCenter, uar, String.valueOf(uar.getUser()), !AgentUtil.isMobile(this.request));
        if (uar.getHeaderParmas() != null) {
            userInfo.put("ssoParmas", "");
            try {
                String ssoHeaderParmasStr = JSONUtils.toString(uar.getHeaderParmas());
                userInfo.put("ssoParmas", ssoHeaderParmasStr);
            }
            catch (IOException ex) {
                logger.warn((Throwable)ex);
            }
        }
        return userInfo;
    }

    private String createSession(Map<String, String> userInfo, UserAuthResult uar) {
        LoginClientEnum loginClient = !AgentUtil.isMobile(this.request) ? LoginClientEnum.WEB : LoginClientEnum.MOBILE;
        String sessionId = SessionUtils.createNewSession(this.request, this.response, this.currentCenter, SSOAnalysis.getLangForSSO(this.request, uar), NetAddressUtils.getRemoteHost((HttpServletRequest)this.request), userInfo, loginClient);
        AllSSOHandler.putHander(this.currentCenter.getSsoPlugin(), this.ssoAuthHandler);
        this.ssoAuthHandler.processSucceedLogin(this.request, sessionId);
        return sessionId;
    }

    private void processForYZJSpecialVer(UserAuthResult uar, Map<String, String> userInfo) {
        if ("administrator".equals(String.valueOf(uar.getUser())) || !LoginUtils.isYZJSpecialVersion(this.currentCenter)) {
            return;
        }
        String openId = userInfo.get("fopenid");
        if (StringUtils.isBlank((CharSequence)openId)) {
            throw new KDException(Constants.KD_WEB_EXCEPTION, new Object[]{ResManager.loadKDString((String)"\u4eba\u5458\u6ca1\u6709openid\uff0c\u9700\u8981\u540c\u6b65\u4e91\u4e4b\u5bb6\u6570\u636e\u3002", (String)"LoginFilter_22", (String)BOS_LOGIN, (Object[])new Object[0])});
        }
        String eid = YZJSpecialUtils.getYZJEid(this.currentCenter);
        String lkToken = YZJSpecialUtils.getWebLoginToken(this.currentCenter, eid, userInfo.get("fopenid"));
        LoginUtils.setYZJLKCache(userInfo.get("fid"), lkToken, 60);
    }
}

