/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.sso;

import javax.servlet.http.HttpServletRequest;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.mc.tenant.AccountType;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.login.sso.SSOAnalysis;
import kd.bos.login.sso.SSOErrorCode;
import kd.bos.login.thirdauth.UserAuthResult;
import kd.bos.login.utils.LoginUtils;
import kd.bos.login.utils.StringUtils;

public class SSOAuthValidator {
    public void checkParam(HttpServletRequest request) {
        if (StringUtils.isEmpty(SSOAnalysis.getTenantNoForSSO(request))) {
            throw new KDException(new ErrorCode(SSOErrorCode.PARAM_ERROR.getCode(), SSOErrorCode.PARAM_ERROR.getDesc()), new Object[0]);
        }
    }

    public void checkOpenSSOByMC(HttpServletRequest request) {
        Account currentCenter = SSOAnalysis.getAccountForSSO(request);
        if (StringUtils.isEmpty(currentCenter.getSsoPlugin()) || !LoginUtils.hasPrevilige(AccountType.ThridParty.toString(), currentCenter.getAllSourceTypes())) {
            throw new KDException(new ErrorCode(SSOErrorCode.PARAM_ERROR.getCode(), SSOErrorCode.PARAM_ERROR.getDesc()), new Object[0]);
        }
    }

    public void checkAuth(UserAuthResult uar) {
        if (uar == null || !uar.isSucess()) {
            throw new KDException(new ErrorCode(SSOErrorCode.AUTH_ERROR.getCode(), SSOErrorCode.AUTH_ERROR.getDesc()), new Object[0]);
        }
    }
}

