/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.thirdauth;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.login.CacheLoginData;
import kd.bos.login.thirdauth.SingleSignOutHandler;
import kd.bos.login.thirdauth.UserAuthResult;
import kd.bos.session.SessionManager;
import kd.bos.util.RevProxyUtil;
import kd.bos.util.StringUtils;

public interface ThirdSSOAuthHandler {
    public static final String KEY_CALLBACK_ACTION = "auth/callbackTrdSSO.do";
    public static final String KEY_CALLBACK_TENANT = "tenantNo";
    public static final String KEY_CALLBACK_SANDBOX = "sandboxNo";

    default public String getERPCallback(HttpServletRequest servletRequest, String tenantNo, String sandboxNo) {
        String site = RevProxyUtil.getURLContextPath((HttpServletRequest)servletRequest);
        return String.format("%s%s?%s=%s&%s=%s", site, KEY_CALLBACK_ACTION, KEY_CALLBACK_TENANT, tenantNo, KEY_CALLBACK_SANDBOX, sandboxNo);
    }

    default public boolean processLogoutLogic(HttpServletRequest servletRequest) {
        boolean logoutSuccessed = false;
        SingleSignOutHandler ssoHandler = SingleSignOutHandler.getSingleSignOutHandler();
        if (ssoHandler.isLogoutRequest(servletRequest)) {
            String oldTicket = ssoHandler.getLogoutTicket(servletRequest);
            String globalSessionId = CacheLoginData.getAttribute((String)CacheLoginData.getCASCachePreFix(), (String)oldTicket);
            if (StringUtils.isNotEmpty((String)globalSessionId)) {
                SessionManager.removeSession((String)globalSessionId);
                logoutSuccessed = true;
            }
        }
        return logoutSuccessed;
    }

    default public void processSucceedLogin(HttpServletRequest request, String globalSessionId) {
        SingleSignOutHandler sso = SingleSignOutHandler.getSingleSignOutHandler();
        String ticket = sso.safeGetParameter(request, "ticket");
        if (StringUtils.isNotEmpty((String)ticket)) {
            CacheLoginData.setAttribute((String)CacheLoginData.getCASCachePreFix(), (String)ticket, (String)globalSessionId);
        }
    }

    public void callTrdSSOLogin(HttpServletRequest var1, HttpServletResponse var2, String var3);

    public UserAuthResult getTrdSSOAuth(HttpServletRequest var1, HttpServletResponse var2);

    default public boolean isNeedSSOAuth4UserChange(HttpServletRequest request) {
        return false;
    }

    default public String getSSOAccount(HttpServletRequest servletRequest) {
        return null;
    }
}

