/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.thirdauth.app.dingding;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dc.api.model.Account;
import kd.bos.exception.KDException;
import kd.bos.exception.LoginErrorCode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.model.AuthSignatureResult;
import kd.bos.login.model.ThirdAuthApp;
import kd.bos.login.thirdauth.app.ThirdAppAuthStrategy;
import kd.bos.login.thirdauth.app.dingding.DDAppInfo;
import kd.bos.login.thirdauth.app.dingding.DDConfigSign;
import kd.bos.login.thirdauth.app.dingding.DDUtils;
import org.apache.commons.lang3.StringUtils;

public class DDAuthStrategy
implements ThirdAppAuthStrategy {
    private static Log logger = LogFactory.getLog(DDAuthStrategy.class);

    @Override
    public List<AuthSignatureResult> getJsSignatureList(Account currentCenter, ThirdAuthApp thirdAuthAppInfo) {
        ArrayList<AuthSignatureResult> authSignatureResultList = new ArrayList<AuthSignatureResult>(2);
        try {
            DDAppInfo appInfo;
            AuthSignatureResult authSignatureResult = new AuthSignatureResult();
            String appSecret = thirdAuthAppInfo.getSecret();
            if (StringUtils.isEmpty((CharSequence)appSecret)) {
                appSecret = kd.bos.login.utils.StringUtils.getTrimedBlank(DDUtils.getAppSecret(thirdAuthAppInfo.getLightAppId(), currentCenter));
            }
            if (StringUtils.isBlank((CharSequence)appSecret) && (appInfo = DDUtils.getAppInfo(currentCenter)) != null) {
                thirdAuthAppInfo.setLightAppId(appInfo.getAppkey());
                appSecret = appInfo.getAppsecret();
            }
            if (StringUtils.isBlank((CharSequence)thirdAuthAppInfo.getLightAppId())) {
                throw new KDException(LoginErrorCode.loginBizException, new Object[]{"appkey is null."});
            }
            if (StringUtils.isBlank((CharSequence)appSecret)) {
                throw new KDException(LoginErrorCode.loginBizException, new Object[]{"appSecret  is null"});
            }
            String accessToken = DDUtils.getAccess_token(thirdAuthAppInfo.getLightAppId(), appSecret, currentCenter);
            if (StringUtils.isBlank((CharSequence)appSecret)) {
                throw new KDException(LoginErrorCode.loginBizException, new Object[]{"accessToken is null,please check the configuration."});
            }
            String jsticket = DDUtils.getJsapiTicket(thirdAuthAppInfo.getLightAppId(), accessToken, currentCenter);
            String noncestr = kd.bos.login.utils.StringUtils.randomWord(16);
            long timestamp = new Date().getTime();
            String sign = DDConfigSign.sign(jsticket, noncestr, timestamp, thirdAuthAppInfo.getAccessUrl());
            authSignatureResult.setSignature(sign);
            authSignatureResult.setNonce(noncestr);
            authSignatureResult.setTimestamp(timestamp);
            authSignatureResult.setEid(thirdAuthAppInfo.getCorpId());
            authSignatureResult.setAppId(thirdAuthAppInfo.getLightAppId());
            authSignatureResult.setAgentId(thirdAuthAppInfo.getAgentId());
            authSignatureResult.setConfigType("config");
            authSignatureResultList.add(authSignatureResult);
        }
        catch (KDException e) {
            throw new KDException(LoginErrorCode.loginBizException, new Object[]{e.getMessage()});
        }
        catch (Exception e) {
            logger.info("getAuthSignatureList#error", (Object)e);
        }
        return authSignatureResultList;
    }
}

