/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.thirdauth.app.feishu;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.dc.api.model.Account;
import kd.bos.exception.KDException;
import kd.bos.exception.LoginErrorCode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.model.AuthSignatureResult;
import kd.bos.login.model.ThirdAuthApp;
import kd.bos.login.thirdauth.app.ThirdAppAuthStrategy;
import kd.bos.login.thirdauth.app.dingding.DDConfigSign;
import kd.bos.login.thirdauth.app.feishu.FeiShuUtils;
import org.apache.commons.lang3.StringUtils;

public class FeiShuAuthStrategy
implements ThirdAppAuthStrategy {
    private static Log logger = LogFactory.getLog(FeiShuAuthStrategy.class);

    @Override
    public List<AuthSignatureResult> getJsSignatureList(Account currentCenter, ThirdAuthApp thirdAuthAppInfo) {
        ArrayList<AuthSignatureResult> authSignatureResultList = new ArrayList<AuthSignatureResult>(2);
        try {
            AuthSignatureResult authSignatureResult = new AuthSignatureResult();
            HashMap<String, Object> parameters = new HashMap<String, Object>(8);
            parameters.put("feishu_app_id", thirdAuthAppInfo.getLightAppId());
            parameters.put("flyBookAppId", thirdAuthAppInfo.getLightAppId());
            parameters.put("feishu_api_url", FeiShuUtils.getFlyUrl(currentCenter));
            if (StringUtils.isBlank((CharSequence)thirdAuthAppInfo.getLightAppId())) {
                throw new KDException(LoginErrorCode.loginBizException, new Object[]{"lightAppId is null."});
            }
            String appAccessToken = FeiShuUtils.getAppAccessToken(parameters, currentCenter);
            if (StringUtils.isBlank((CharSequence)thirdAuthAppInfo.getLightAppId())) {
                throw new KDException(LoginErrorCode.loginBizException, new Object[]{"appAccessToken is null,please check the configuration."});
            }
            String jsapiTicket = FeiShuUtils.getJsapiTicket(currentCenter, appAccessToken);
            String noncestr = kd.bos.login.utils.StringUtils.randomWord(16);
            long timestamp = new Date().getTime();
            String sign = DDConfigSign.shaSign(jsapiTicket, noncestr, timestamp, thirdAuthAppInfo.getAccessUrl());
            authSignatureResult.setSignature(sign);
            authSignatureResult.setNonce(noncestr);
            authSignatureResult.setSignature(sign);
            authSignatureResult.setTimestamp(timestamp);
            authSignatureResult.setEid(thirdAuthAppInfo.getCorpId());
            authSignatureResult.setAppId(thirdAuthAppInfo.getLightAppId());
            authSignatureResult.setConfigType("config");
            authSignatureResultList.add(authSignatureResult);
        }
        catch (KDException e) {
            throw new KDException(LoginErrorCode.loginBizException, new Object[]{e.getMessage()});
        }
        catch (Exception e) {
            logger.info("getAuthSignatureList error", (Object)e);
        }
        return authSignatureResultList;
    }
}

