/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.thirdauth.app.feishu;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import kd.bos.dc.api.model.Account;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.thirdauth.app.AppAuthResult;
import kd.bos.login.thirdauth.app.ThirdAppAuthtication;
import kd.bos.login.thirdauth.app.UserType;
import kd.bos.login.thirdauth.app.feishu.FeiShuErrorMsg;
import kd.bos.login.thirdauth.app.feishu.FeiShuUtils;
import kd.bos.login.utils.JSONUtils;
import kd.bos.login.utils.ParametersUtils;
import kd.bos.login.utils.log.ThirdAppLogInfo;
import kd.bos.login.utils.log.ThirdAppLogUtils;
import kd.bos.util.StringUtils;

public class FeiShuAuthtication
extends ThirdAppAuthtication {
    private static Log logger = LogFactory.getLog(FeiShuAuthtication.class);

    @Override
    public boolean isNeedHandle(HttpServletRequest request, Account currentCenter) {
        String app_type = request.getParameter("apptype");
        String code = request.getParameter("code");
        return "feishu".equalsIgnoreCase(app_type);
    }

    @Override
    public AppAuthResult appAuthtication(HttpServletRequest request, Account currentCenter) {
        AppAuthResult result = new AppAuthResult();
        result.setSucceed(false);
        String appId = "";
        try {
            String appAccessToken;
            String code = request.getParameter("code");
            if (StringUtils.isEmpty((String)code)) {
                throw new KDException(new ErrorCode("FeiShuErrorMsg_2", FeiShuErrorMsg.getCodeMsg("FeiShuErrorMsg_2")), new Object[0]);
            }
            Map<String, Object> parameters = ParametersUtils.getCommonParameters(currentCenter);
            if (null == parameters) {
                logger.info("getCommonParameters is null");
                parameters = new HashMap<String, Object>();
            }
            if (null == parameters.get("feishu_api_url") || "".equals(parameters.get("feishu_api_url"))) {
                parameters.put("feishu_api_url", FeiShuUtils.getFlyUrl(currentCenter));
            }
            if (StringUtils.isNotEmpty((String)(appId = request.getParameter("flyBookAppId")))) {
                parameters.put("flyBookAppId", appId);
            }
            if (StringUtils.isEmpty((String)(appAccessToken = FeiShuUtils.getAppAccessTokenWithException(parameters, currentCenter)))) {
                throw new KDException(new ErrorCode("FeiShuErrorMsg_7", FeiShuErrorMsg.getCodeMsg("FeiShuErrorMsg_7")), new Object[0]);
            }
            Map<String, Object> authUserInfo = FeiShuUtils.getAuthUserInfoWithException(parameters, appAccessToken, code);
            if (authUserInfo == null || authUserInfo.size() <= 0) {
                throw new KDException(new ErrorCode("FeiShuErrorMsg_6", FeiShuErrorMsg.getCodeMsg("FeiShuErrorMsg_6")), new Object[0]);
            }
            if ("0".equals(authUserInfo.get("code").toString())) {
                Map data = JSONUtils.cast(authUserInfo.get("data").toString(), HashMap.class);
                Object mobile = data.get("mobile");
                if (null != mobile && !"".equals(mobile)) {
                    result.setUserType(UserType.MOBILE_PHONE);
                    result.setSucceed(true);
                    result.setUserFlag(FeiShuUtils.getMobile(mobile.toString()));
                } else {
                    throw new KDException(new ErrorCode("FeiShuErrorMsg_8", FeiShuErrorMsg.getCodeMsg("FeiShuErrorMsg_8")), new Object[0]);
                }
            }
            result.setAppType(request.getParameter("apptype"));
        }
        catch (KDException kde) {
            ErrorCode errorCode = kde.getErrorCode();
            String resourceId = errorCode != null ? errorCode.getCode() : "";
            boolean codeExist = StringUtils.isNotEmpty((String)FeiShuErrorMsg.getCodeMsg(resourceId));
            String kdeMessage = kde.getMessage();
            result.setErrorMessage(kdeMessage);
            if (kdeMessage != null && kdeMessage.contains("code=20003")) {
                return result;
            }
            ThirdAppLogInfo thirdAppLogInfo = ThirdAppLogUtils.wrapThirdAppLogInfo(kde, request, codeExist);
            thirdAppLogInfo.setThirdType(6L);
            thirdAppLogInfo.setCorpid("");
            thirdAppLogInfo.setAgentid(appId);
            ThirdAppLogUtils.addLog(thirdAppLogInfo);
        }
        catch (Exception e) {
            logger.info("appAuthtication error", (Object)e);
            result.setErrorMessage(e.getMessage());
        }
        return result;
    }
}

