/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.thirdauth.app.qrcode;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URLEncoder;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.dc.utils.MCDBUtil;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.login.CacheLoginData;
import kd.bos.login.LoginClientEnum;
import kd.bos.login.lang.LoginLangUtils;
import kd.bos.login.thirdauth.app.qrcode.QRCodeAuthResult;
import kd.bos.login.user.LoginUserService;
import kd.bos.login.utils.SessionUtils;
import kd.bos.login.utils.StringUtils;
import kd.bos.util.NetAddressUtils;
import kd.bos.util.RevProxyUtil;

public interface ScanStrategy {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void deleteUserBinding(Long userId, String openId, Account currentAccount) throws SQLException {
        Connection conn = null;
        Statement stmt = null;
        try {
            Properties dataBaseProperties = AccountUtils.getTenantDBInfoByRoutekey((Account)currentAccount, (String)"sys");
            conn = MCDBUtil.getConnection((Account)currentAccount, (Properties)dataBaseProperties);
            String deleteSql = "delete from t_bas_immapping where fopenid=? and fuserid=? and fimtypeid=3";
            stmt = conn.prepareStatement(deleteSql);
            stmt.setString(1, openId);
            stmt.setLong(2, userId);
            stmt.execute();
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
    }

    default public Account init(HttpServletRequest request) {
        try {
            Lang lang = LoginLangUtils.getLoginLanguage(request);
            LoginLangUtils.setLang(lang);
            String tenantAlias = RevProxyUtil.getTenantCode((HttpServletRequest)request);
            if (StringUtils.isEmpty(tenantAlias)) {
                return null;
            }
            String accountIdParameter = request.getParameter("accountid");
            Account account = AccountUtils.getCorrectAccount((String)accountIdParameter, (String)tenantAlias);
            return account;
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public Tuple<Boolean, Long> isUserBinding(String userId, Account currentAccount) throws Exception {
        Connection conn = null;
        Statement stmt = null;
        ResultSet resultSet = null;
        try {
            Properties dataBaseProperties = AccountUtils.getTenantDBInfoByRoutekey((Account)currentAccount, (String)"sys");
            conn = MCDBUtil.getConnection((Account)currentAccount, (Properties)dataBaseProperties);
            String selectSql = "select fid,fuserid from t_bas_immapping where fopenid=? and fimtypeid=3";
            stmt = conn.prepareStatement(selectSql);
            stmt.setString(1, userId);
            resultSet = stmt.executeQuery();
            boolean alreadyBinding = resultSet.next();
            Long kingdeeUserId = null;
            if (alreadyBinding) {
                kingdeeUserId = resultSet.getLong(2);
            }
            Tuple tuple = new Tuple((Object)alreadyBinding, (Object)kingdeeUserId);
            return tuple;
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (stmt != null) {
                stmt.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
    }

    default public void handleCallback(HttpServletRequest request, HttpServletResponse response) {
        Account currentAccount = AccountUtils.getCorrectAccount((String)RequestContext.get().getAccountId(), (String)RequestContext.get().getTenantId());
        QRCodeAuthResult result = this.getAuthResult(request, response, currentAccount);
        if (result == null) {
            return;
        }
        String redirectUrl = null;
        boolean success = result.isSucceed();
        if (success) {
            Map<String, String> kingdeeUser = result.getMpUser();
            SessionUtils.createNewSession(request, response, currentAccount, LoginLangUtils.getLoginLanguage(request), NetAddressUtils.getRemoteHost((HttpServletRequest)request), kingdeeUser, LoginClientEnum.WEB);
            String token = request.getParameter("token");
            redirectUrl = CacheLoginData.getAttribute((String)"QR_redirect_url", (String)token);
            this.getLogger().info("QR_redirect_url:" + redirectUrl);
            if (StringUtils.isEmpty(redirectUrl)) {
                redirectUrl = String.format("%sindex.html?&accountid=%s", RevProxyUtil.getURLContextPath((HttpServletRequest)request), currentAccount.getAccountId());
            }
            CacheLoginData.remove((String)"QR_redirect_url", (String)token);
        } else {
            redirectUrl = result.getRedirectUrl();
            if (StringUtils.isEmpty(redirectUrl)) {
                return;
            }
        }
        try {
            response.sendRedirect(this.handelRedirectUrl(redirectUrl));
        }
        catch (IOException e) {
            this.getLogger().error((Throwable)e);
        }
    }

    default public QRCodeAuthResult getAuthResult(HttpServletRequest request, HttpServletResponse response, Account currentAccount) {
        String lang = request.getParameter("language");
        Map<String, Object> authUser = this.getAuthUserInfo(request, currentAccount);
        String code = String.valueOf(authUser.get("code"));
        ObjectMapper mapper = new ObjectMapper();
        String redirectUrl = null;
        boolean shouldBind = false;
        String accountId = request.getParameter("accountid");
        QRCodeAuthResult result = new QRCodeAuthResult();
        boolean authResult = false;
        if ("0".equals(code)) {
            String userId = String.valueOf(authUser.get("userId"));
            try {
                DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("qrcode_scan_login", new DistributeCacheHAPolicy(true, true));
                Tuple<Boolean, Long> isBinding = this.isUserBinding(userId, currentAccount);
                if (!((Boolean)isBinding.item1).booleanValue()) {
                    shouldBind = true;
                } else {
                    Map<String, String> kingdeeUser = LoginUserService.getErpUserInfoByUserId(currentAccount, String.valueOf(isBinding.item2), lang);
                    if (kingdeeUser != null && kingdeeUser.size() > 0 && kingdeeUser.containsKey("fenable") && "1".equals(String.valueOf(kingdeeUser.get("fenable"))) && kingdeeUser.containsKey("fisforbidden") && "0".equals(String.valueOf(kingdeeUser.get("fisforbidden")))) {
                        authResult = true;
                        result.setMpUser(kingdeeUser);
                    } else if (kingdeeUser == null || kingdeeUser.size() <= 0 || "0".equals(String.valueOf(kingdeeUser.get("success")))) {
                        this.deleteUserBinding((Long)isBinding.item2, userId, currentAccount);
                        shouldBind = true;
                    } else {
                        String errorMsg = ResManager.loadKDString((String)"\u7528\u6237\u5df2\u7981\u7528\u3002", (String)"ThirdScanLogin_1", (String)"bos-login", (Object[])new Object[0]);
                        redirectUrl = String.format("%slogin.html?", RevProxyUtil.getURLContextPath((HttpServletRequest)request)) + URLEncoder.encode(String.format("type=2&errormsg=%s&accountid=%s", errorMsg, accountId)).replaceAll("\\+", "%20");
                    }
                }
                if (shouldBind) {
                    String token = request.getParameter("token");
                    String scanType = request.getParameter("scantype");
                    String cacheKey = scanType + "_qrcodescan_login_" + token + "_" + accountId + "_" + userId;
                    HashMap<String, String> cacheValue = new HashMap<String, String>(16);
                    cacheValue.put("token", token);
                    cacheValue.put("userId", userId);
                    cacheValue.put("accountId", accountId);
                    cacheValue.put("language", lang);
                    cacheValue.put("scanType", scanType);
                    cache.put(cacheKey, (Object)mapper.writeValueAsString(cacheValue), 300, TimeUnit.SECONDS);
                    redirectUrl = String.format("%slogin.html?", RevProxyUtil.getURLContextPath((HttpServletRequest)request)) + URLEncoder.encode(String.format("type=1&token=%s&openid=%s&accountid=%s&language=%s&scantype=%s", token, userId, accountId, lang, scanType)).replaceAll("\\+", "%20");
                }
            }
            catch (Exception e) {
                this.getLogger().error((Throwable)e);
                String errorMsg = ResManager.loadKDString((String)"\u7b2c\u4e09\u65b9\u626b\u7801\u767b\u5f55\u56de\u8c03\u63a5\u53e3\u6821\u9a8c\u6388\u6743\u7528\u6237\u662f\u5426\u5728\u7cfb\u7edf\u6709\u7ed1\u5b9a\u5173\u7cfb\u5f02\u5e38", (String)"ThirdScanLogin_0", (String)"bos-login", (Object[])new Object[0]);
                redirectUrl = String.format("%slogin.html?", RevProxyUtil.getURLContextPath((HttpServletRequest)request)) + URLEncoder.encode(String.format("type=2&errormsg=%s&accountid=%s", errorMsg, accountId)).replaceAll("\\+", "%20");
            }
        } else {
            String errorMsg = String.valueOf(authUser.get("error"));
            redirectUrl = String.format("%slogin.html?", RevProxyUtil.getURLContextPath((HttpServletRequest)request)) + URLEncoder.encode(String.format("type=2&errormsg=%s&accountid=%s", errorMsg, accountId)).replaceAll("\\+", "%20");
        }
        result.setSucceed(authResult);
        result.setRedirectUrl(redirectUrl);
        return result;
    }

    default public String handelRedirectUrl(String redirectUrl) {
        return redirectUrl + "#prompt";
    }

    public Log getLogger();

    default public String getToken(String appId, String secretKey) {
        return null;
    }

    default public String getToken(String appId, String secretKey, Account currentAccount) {
        return null;
    }

    default public Map<String, Object> getAuthUserInfo(HttpServletRequest request, Account currentAccount) {
        return null;
    }
}

