/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.thirdauth.app.qrcode;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.actiondispatcher.ActionUtil;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.exception.KDException;
import kd.bos.exception.LoginErrorCode;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.emun.AccountType;
import kd.bos.login.lang.LoginLangUtils;
import kd.bos.login.thirdauth.app.qrcode.QRCodeAuthResult;
import kd.bos.login.thirdauth.app.qrcode.ScanStrategy;
import kd.bos.login.user.LoginUserService;
import kd.bos.login.utils.LoginUtils;
import kd.bos.login.utils.StringUtils;
import kd.bos.login.yunzhijia.YunzhijiaAppContext;
import kd.bos.login.yunzhijia.lightapp.YunzhijiaTicketService;
import kd.bos.tenant.TenantInfo;
import kd.bos.util.RevProxyUtil;

public class YzjScanStrategy
implements ScanStrategy {
    private static final Log logger = LogFactory.getLog(YzjScanStrategy.class);
    private static final String TICKET = "ticket";
    private static final String HCODE_TOKEN = "token";
    private static final String ACCOUNT_ID = "accountId";
    private static final String SUCCESS = "success";
    private static final String BOS_LOGIN = "bos-login";

    @Override
    public Log getLogger() {
        return logger;
    }

    @Override
    public QRCodeAuthResult getAuthResult(HttpServletRequest request, HttpServletResponse response, Account currentAccount) {
        logger.info(String.format("currentCenter.getAllSourceTypes()=%s", currentAccount.getUserSourceTypeOutput()));
        try {
            if (LoginUtils.hasPrevilige(AccountType.YzjPrivateCloud.toString(), currentAccount.getAllSourceTypes())) {
                return this.updateYZJLoginStatus(request, response, false);
            }
            if (LoginUtils.hasPrevilige(AccountType.YzjPublicCloud.toString(), currentAccount.getAllSourceTypes())) {
                return this.updateYZJLoginStatus(request, response, true);
            }
        }
        catch (IOException e) {
            logger.error((Throwable)e);
        }
        return null;
    }

    private QRCodeAuthResult updateYZJLoginStatus(HttpServletRequest request, HttpServletResponse response, boolean isYzjPublicCloud) throws IOException {
        String sToken = request.getParameter(HCODE_TOKEN);
        if (StringUtils.isEmpty(sToken)) {
            return null;
        }
        String sTicket = request.getParameter(TICKET);
        if (StringUtils.isEmpty(sTicket)) {
            return null;
        }
        String sMsg = "";
        QRCodeAuthResult result = new QRCodeAuthResult();
        boolean authResult = false;
        try {
            Lang lang = LoginLangUtils.getLoginLanguage(request);
            YunzhijiaAppContext qrCtx = YunzhijiaTicketService.getContextByTicket(sTicket, isYzjPublicCloud);
            if (qrCtx != null) {
                List tenantList = AccountUtils.getTenantInfoByEid((String)qrCtx.getEid());
                TenantInfo lstTenant = this.getTenantIfExist(tenantList, request);
                if (lstTenant != null) {
                    String tenantId = lstTenant.getId();
                    String accountIdParameter = request.getParameter(ACCOUNT_ID);
                    Account currentCenter = AccountUtils.getCorrectAccount((String)accountIdParameter, (String)tenantId);
                    Map<String, String> mpUser = LoginUserService.getErpUserInfo(currentCenter, qrCtx.getOpenid(), lang.name());
                    if ("1".equalsIgnoreCase(mpUser.get(SUCCESS))) {
                        authResult = true;
                        result.setMpUser(mpUser);
                        logger.info("\u4e8c\u7ef4\u7801\u626b\u63cf\u767b\u9646\u4e0a\u4e0b\u6587\u751f\u6210\u6210\u529f\u3002");
                    } else {
                        sMsg = ResManager.loadKDString((String)"\u8d26\u53f7\u672a\u540c\u6b65\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u8d26\u53f7\u540c\u6b65\u3002", (String)"LoginAction_17", (String)BOS_LOGIN, (Object[])new Object[0]);
                        logger.info("\u4e8c\u7ef4\u7801\u626b\u63cf\u767b\u9646\u4e0a\u4e0b\u6587\u751f\u6210\u6210\u529f\uff0c\u4f46\u662f\u7528\u6237\u6ca1\u6709\u88ab\u540c\u6b65\u3002");
                    }
                } else {
                    sMsg = ResManager.loadKDString((String)"\u60a8\u6240\u5728\u5de5\u4f5c\u5708\u5c1a\u672a\u5f00\u901a\uff0c\u65e0\u6cd5\u767b\u5f55\u3002", (String)"LoginAction_55", (String)BOS_LOGIN, (Object[])new Object[0]);
                }
            }
            if (StringUtils.isNotEmpty(sMsg)) {
                throw new KDException(LoginErrorCode.loginBizException, new Object[]{sMsg});
            }
        }
        catch (KDException ex) {
            logger.error((Throwable)ex);
            String resp = ex.getMessage();
            ActionUtil.writeResponseResult((ServletResponse)response, (CharSequence)resp);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            KDException kd = new KDException(LoginErrorCode.loginBizException, new Object[]{ResManager.loadKDString((String)"\u4e8c\u7ef4\u7801\u626b\u63cf\u767b\u5f55\u5931\u8d25\uff0c\u539f\u56e0:", (String)"LoginAction_19", (String)BOS_LOGIN, (Object[])new Object[0])});
            String resp = kd.getMessage();
            ActionUtil.writeResponseResult((ServletResponse)response, (CharSequence)resp);
        }
        result.setSucceed(authResult);
        return result;
    }

    private TenantInfo getTenantIfExist(List<TenantInfo> tenantList, HttpServletRequest request) {
        TenantInfo returnValue = null;
        if (tenantList != null) {
            String tenantCode = RevProxyUtil.getTenantCode((HttpServletRequest)request);
            for (TenantInfo tenantInfo : tenantList) {
                if (!tenantInfo.getId().equals(tenantCode)) continue;
                returnValue = tenantInfo;
                break;
            }
        }
        return returnValue;
    }

    @Override
    public String handelRedirectUrl(String redirectUrl) {
        return redirectUrl;
    }
}

