/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.thirdauth.app.sky;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dc.api.model.Account;
import kd.bos.exception.KDException;
import kd.bos.exception.LoginErrorCode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.model.AuthSignatureResult;
import kd.bos.login.model.ThirdAuthApp;
import kd.bos.login.thirdauth.app.ThirdAppAuthStrategy;
import kd.bos.login.thirdauth.app.sky.SkyUtils;
import org.apache.commons.lang3.StringUtils;

public class SkyAuthStrategy
implements ThirdAppAuthStrategy {
    private static Log logger = LogFactory.getLog(SkyAuthStrategy.class);

    @Override
    public List<AuthSignatureResult> getJsSignatureList(Account currentCenter, ThirdAuthApp thirdAuthAppInfo) {
        List<AuthSignatureResult> authSignatureResultList = new ArrayList<AuthSignatureResult>(2);
        try {
            AuthSignatureResult authSignatureResult = new AuthSignatureResult();
            String accessToken = SkyUtils.getSkyAccessToken(currentCenter, thirdAuthAppInfo);
            if (StringUtils.isBlank((CharSequence)accessToken)) {
                throw new KDException(LoginErrorCode.loginBizException, new Object[]{"accessToken is null,please check the configuration."});
            }
            authSignatureResultList = SkyUtils.getAuthSignatureResultList(currentCenter, accessToken, thirdAuthAppInfo);
        }
        catch (KDException e) {
            throw new KDException(LoginErrorCode.loginBizException, new Object[]{e.getMessage()});
        }
        catch (Exception e) {
            logger.info("getAuthSignatureList error", (Object)e);
        }
        return authSignatureResultList;
    }
}

