/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.thirdauth.app.tencent;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Optional;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import kd.bos.db.DB;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.dc.utils.MCDBUtil;
import kd.bos.dc.utils.SQLUtils;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.CacheLoginData;
import kd.bos.login.after.LoginAfterBase;
import kd.bos.login.utils.ErrorCodeUtils;
import kd.bos.login.utils.StringUtils;
import kd.bos.login.utils.account.LoginAccountFactory;
import kd.bos.session.SessionInfo;
import kd.bos.util.RevProxyUtil;

public class WxgzhLoginAfter
extends LoginAfterBase {
    private static Log logger = LogFactory.getLog(WxgzhLoginAfter.class);
    public static final String SPLIT = "_split_";
    private static final String WXGZHLOGIN = "wxgzhlogin";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void handling(HttpServletRequest request, SessionInfo sessionInfo) {
        block20: {
            String redirect = request.getParameter("redirect");
            if (StringUtils.isEmpty(redirect)) {
                return;
            }
            if (!redirect.contains("state=")) {
                return;
            }
            String state = redirect.substring(redirect.indexOf("state="));
            if (state.indexOf("&") >= 1) {
                state = state.substring(0, state.indexOf("&"));
            }
            if (StringUtils.isEmpty(state = state.substring(state.indexOf("=") + 1))) {
                return;
            }
            if (!redirect.contains("code=")) {
                return;
            }
            String code = redirect.substring(redirect.indexOf("code="));
            if (code.indexOf("&") >= 1) {
                code = code.substring(0, code.indexOf("&"));
            }
            if (StringUtils.isEmpty(code = code.substring(code.indexOf("=") + 1))) {
                return;
            }
            String openid = CacheLoginData.getAttribute((String)WXGZHLOGIN, (String)code);
            logger.info("wxgzh loginAfter: openid ");
            if (StringUtils.isEmpty(openid)) {
                return;
            }
            String tenantNo = RevProxyUtil.getTenantCode((HttpServletRequest)request);
            Account currentAccount = LoginAccountFactory.createInstanceBySession(sessionInfo, Optional.of(tenantNo)).getAccount();
            Connection conn = null;
            PreparedStatement stmt = null;
            ResultSet rs = null;
            try {
                logger.info("@\u5f00\u59cb\u7528\u6237\u4e0e\u79df\u6237\u7684\u5bf9\u5e94\u5173\u7cfb\u9a8c\u8bc1\u3002");
                Properties dataBaseProperties = AccountUtils.getTenantDBInfo((Account)currentAccount);
                if (dataBaseProperties == null) {
                    throw new KDException(BosErrorCode.configNotFound, new Object[]{ErrorCodeUtils.getDBGetError()});
                }
                String userId = sessionInfo.getUserId();
                conn = MCDBUtil.getConnection((Account)currentAccount, (Properties)dataBaseProperties);
                String sql = "SELECT fid from t_bas_immapping WHERE fuserid = ?  and FIMTypeID = 1 ";
                stmt = conn.prepareStatement(sql);
                stmt.setLong(1, Long.parseLong(userId));
                rs = stmt.executeQuery();
                String mappingId = "";
                if (rs.next()) {
                    mappingId = rs.getString(1);
                }
                String fid = "";
                if (mappingId == null || mappingId.trim().length() == 0) {
                    logger.info("wxgzh loginAfter: insert immapping !");
                    fid = String.valueOf(DB.genLongId((String)"t_bas_immapping"));
                    sql = "INSERT INTO t_bas_immapping (FIMTypeID, FOpenID ,frefuserid, FUserID,FID) VALUES (?, ?,?,?,?)";
                    stmt = conn.prepareStatement(sql);
                } else {
                    fid = mappingId;
                    sql = "UPDATE t_bas_immapping set FIMTypeID = ?,FOpenID=?,frefuserid=? where FUserID = ? AND FID = ?";
                    stmt = conn.prepareStatement(sql);
                }
                stmt.setLong(1, 1L);
                stmt.setString(2, openid);
                stmt.setLong(3, Long.parseLong(userId));
                stmt.setLong(4, Long.parseLong(userId));
                stmt.setLong(5, Long.parseLong(fid));
                int update = stmt.executeUpdate();
                if (update > 0) {
                    logger.info("wxgzh loginAfter: update immapping success!");
                }
                SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
            }
            catch (SQLException e) {
                logger.info("SQLException", (Object)e);
            }
            catch (Exception e2) {
                logger.info("Exception", (Object)e2);
                break block20;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                SQLUtils.cleanup(rs, stmt, conn);
            }
        }
    }
}

