/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.thirdauth.app.tencent;

import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.LoginUtils;
import kd.bos.util.HttpClientUtils;
import kd.bos.util.StringUtils;

public class WxgzhUtils {
    private static Log logger = LogFactory.getLog(WxgzhUtils.class);
    public static final String TOKEN_OPENID_SPLIT = "token_openid_split";
    public static String wxgzhUrl = "https://api.weixin.qq.com/sns/";

    public static String getAccess_token(String appid, String secret, String code) {
        if (null == appid || appid.trim().isEmpty()) {
            return null;
        }
        if (null == secret || secret.trim().isEmpty()) {
            return null;
        }
        if (null == code || code.trim().isEmpty()) {
            return null;
        }
        logger.info("get access_token from Wxgzh ");
        String url = System.getProperty("wxgzh_url");
        if (StringUtils.isNotEmpty((String)url)) {
            wxgzhUrl = LoginUtils.getPathString(url);
        }
        StringBuilder access_token_url = new StringBuilder(wxgzhUrl).append("/oauth2/access_token?appid=");
        access_token_url.append(appid).append("&secret=").append(secret).append("&code=").append(code).append("&grant_type=authorization_code");
        HashMap map = null;
        try {
            String data = HttpClientUtils.get((String)access_token_url.toString());
            map = (HashMap)JSON.parseObject((String)data, HashMap.class);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        if (map == null) {
            return null;
        }
        if (map.get("errcode") == null) {
            return (String)map.get("access_token") + TOKEN_OPENID_SPLIT + (String)map.get("openid");
        }
        logger.error((String)map.get("errmsg"));
        return null;
    }

    public static HashMap<String, String> getUserInfo(String access_token, String openid) {
        if (null == openid || openid.trim().isEmpty()) {
            return null;
        }
        if (null == access_token || access_token.trim().isEmpty()) {
            return null;
        }
        StringBuilder getUserInfo_url = new StringBuilder(wxgzhUrl).append("/userinfo?access_token=");
        getUserInfo_url.append(access_token).append("&openid=").append(openid).append("&lang=zh_CN");
        HashMap map = null;
        try {
            String data = HttpClientUtils.get((String)getUserInfo_url.toString());
            map = (HashMap)JSON.parseObject((String)data, HashMap.class);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        if (map == null) {
            return null;
        }
        if (map.get("errcode") == null) {
            return map;
        }
        logger.error((String)map.get("errmsg"));
        return null;
    }
}

