/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.thirdauth.app.tencent;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dc.api.model.Account;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.CacheLoginData;
import kd.bos.login.thirdauth.app.AppAuthResult;
import kd.bos.login.thirdauth.app.ThirdAppAuthtication;
import kd.bos.login.thirdauth.app.UserType;
import kd.bos.login.thirdauth.app.tencent.WxqyErrorMsg;
import kd.bos.login.thirdauth.app.tencent.WxqyhUtils;
import kd.bos.login.utils.JSONUtils;
import kd.bos.login.utils.StringUtils;
import kd.bos.login.utils.log.ThirdAppLogInfo;
import kd.bos.login.utils.log.ThirdAppLogUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class WxqyhAuthtication
extends ThirdAppAuthtication {
    private static Log logger = LogFactory.getLog(WxqyhAuthtication.class);
    private static final Integer QYWX_TIME_OUT = 120;

    @Override
    public boolean isNeedHandle(HttpServletRequest request, Account currentCenter) {
        String app_type = request.getParameter("apptype");
        if (StringUtils.isEmpty(app_type)) {
            return false;
        }
        String entryRole = request.getParameter("entryRole");
        return "wxqyh".equalsIgnoreCase(app_type) || "wxqyhxcx".equalsIgnoreCase(app_type) || "kingdee_sky".equals(app_type) && "1".equals(entryRole);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public AppAuthResult appAuthtication(HttpServletRequest request, Account currentCenter) {
        AppAuthResult result = new AppAuthResult();
        result.setSucceed(false);
        String app_type = request.getParameter("apptype");
        if (StringUtils.isEmpty(app_type)) {
            return result;
        }
        String code = request.getParameter("code");
        if (StringUtils.isEmpty(code)) {
            return result;
        }
        String corpId = request.getParameter("corpid");
        String agentId = request.getParameter("agentid");
        try {
            HashMap<String, Object> userMap;
            if (StringUtils.isEmpty(agentId)) {
                throw new KDException(new ErrorCode("WxqyErrorMsg_4", WxqyErrorMsg.getCodeMsg("WxqyErrorMsg_4")), new Object[0]);
            }
            String entryRole = request.getParameter("entryRole");
            if ("kingdee_sky".equals(app_type) && "1".equals(entryRole)) {
                return WxqyhUtils.appAuthtication(request, currentCenter, code, corpId);
            }
            String corpSecret = StringUtils.getTrimedBlank(this.getCorpSecret(corpId, agentId));
            if (StringUtils.isEmpty(corpSecret)) {
                throw new KDException(new ErrorCode("WxqyErrorMsg_2", WxqyErrorMsg.getCodeMsg("WxqyErrorMsg_2")), new Object[0]);
            }
            String accessToken = WxqyhUtils.getAccessTokenWithException(corpId, corpSecret = corpSecret.trim(), currentCenter);
            if (StringUtils.isEmpty(accessToken)) {
                throw new KDException(new ErrorCode("WxqyErrorMsg_5", WxqyErrorMsg.getCodeMsg("WxqyErrorMsg_5")), new Object[0]);
            }
            logger.info("wxqyh: code is : " + code);
            String userId = null;
            Map<String, Object> wxUserByCode = null;
            if ("wxqyh".equalsIgnoreCase(app_type)) {
                wxUserByCode = WxqyhUtils.getUserByCodeWithException(accessToken, code, currentCenter);
                userId = WxqyhUtils.getUserIdWithException(wxUserByCode);
            } else if ("wxqyhxcx".equalsIgnoreCase(app_type)) {
                userId = WxqyhUtils.getUserIdByMicroWxWithException(accessToken, code, currentCenter);
            }
            if (StringUtils.isEmpty(userId)) {
                logger.info("wxqyh\uff1auserId is null !");
                result.setErrorMessage("userId is null !");
                return result;
            }
            String userTicket = null;
            if (wxUserByCode != null && wxUserByCode.size() > 0) {
                userTicket = WxqyhUtils.getUserTicketWithException(wxUserByCode);
            }
            if (null == (userMap = StringUtils.isNotEmpty(userTicket) ? WxqyhUtils.getUserInfoByTicketWithException(accessToken, userTicket) : WxqyhUtils.getUserInfoWithException(accessToken, userId, currentCenter))) {
                throw new KDException(new ErrorCode("WxqyErrorMsg_7", WxqyErrorMsg.getCodeMsg("WxqyErrorMsg_7")), new Object[0]);
            }
            if (userMap.get("errcode") != null && !"0".equals(userMap.get("errcode").toString())) {
                throw new KDException(new ErrorCode("WxqyErrorMsg_20", WxqyErrorMsg.getCodeMsg("WxqyErrorMsg_20")), new Object[]{JSONUtils.toString(userMap)});
            }
            String userFlag = "";
            Object mobile = userMap.get("mobile");
            Object qywxhUserid = userMap.get("userid");
            String wxqyhMode = request.getParameter("wxqyhMode");
            if (ObjectUtils.isEmpty((Object)mobile) && !ObjectUtils.isEmpty((Object)qywxhUserid)) {
                logger.info("mobile is null");
                Object[] imMapping = "thirdPartyMode".equals(wxqyhMode) ? BusinessDataServiceHelper.load((String)"bas_immapping", (String)"id,userid,encryopenid,openid", (QFilter[])new QFilter[]{new QFilter("encryopenid", "in", qywxhUserid), new QFilter("imtype", "=", (Object)3)}) : BusinessDataServiceHelper.load((String)"bas_immapping", (String)"id,userid,encryopenid,openid", (QFilter[])new QFilter[]{new QFilter("openid", "in", qywxhUserid), new QFilter("imtype", "=", (Object)3)});
                if (ObjectUtils.isEmpty((Object[])imMapping)) {
                    if (ObjectUtils.isEmpty((Object)qywxhUserid)) throw new KDException(new ErrorCode("WxqyErrorMsg_8", WxqyErrorMsg.getCodeMsg("WxqyErrorMsg_8")), new Object[0]);
                    CacheLoginData.setAttribute((String)"kingdee_sky", (String)code, (String)qywxhUserid.toString(), (int)QYWX_TIME_OUT);
                    throw new KDException(new ErrorCode("WxqyErrorMsg_8", WxqyErrorMsg.getCodeMsg("WxqyErrorMsg_8")), new Object[0]);
                }
                Object id = imMapping[0].get("userid");
                if (!ObjectUtils.isEmpty((Object)id)) {
                    userFlag = id.toString();
                    result.setUserType(UserType.USER_ID);
                }
            } else {
                Pattern pattern = Pattern.compile("^[0-9]");
                userFlag = mobile.toString();
                result.setUserType(UserType.MOBILE_PHONE);
                Matcher matcher = pattern.matcher(userFlag);
                if (!matcher.find()) {
                    userFlag = this.getEmailByUserInfo(userMap);
                    result.setUserType(UserType.EMAIL);
                }
            }
            if (StringUtils.isEmpty(userFlag)) {
                throw new KDException(new ErrorCode("WxqyErrorMsg_9", WxqyErrorMsg.getCodeMsg("WxqyErrorMsg_9")), new Object[0]);
            }
            if (!ObjectUtils.isEmpty((Object)qywxhUserid)) {
                CacheLoginData.setAttribute((String)"kingdee_sky", (String)code, (String)qywxhUserid.toString(), (int)QYWX_TIME_OUT);
            }
            result.setSucceed(true);
            result.setAppType(request.getParameter("apptype"));
            result.setUserFlag(userFlag);
            return result;
        }
        catch (KDException kde) {
            ErrorCode errorCode = kde.getErrorCode();
            String resourceId = errorCode != null ? errorCode.getCode() : "";
            String thirdLogCode = "";
            if ("WxqyErrorMsg_17".equals(resourceId)) {
                thirdLogCode = "60020";
            }
            boolean codeExist = StringUtils.isNotEmpty(WxqyErrorMsg.getCodeMsg(resourceId));
            ThirdAppLogInfo thirdAppLogInfo = ThirdAppLogUtils.wrapThirdAppLogInfo(kde, request, codeExist);
            thirdAppLogInfo.setErrorcode(thirdLogCode);
            thirdAppLogInfo.setThirdType(3L);
            thirdAppLogInfo.setCorpid(corpId);
            thirdAppLogInfo.setAgentid(agentId);
            if (codeExist) {
                thirdAppLogInfo.setResourceId(resourceId);
            }
            ThirdAppLogUtils.addLog(thirdAppLogInfo);
            result.setErrorMessage(kde.getMessage());
            return result;
        }
        catch (Exception e) {
            logger.info("appAuthtication error", (Object)e);
            result.setErrorMessage(e.getMessage());
        }
        return result;
    }

    private String getEmailByUserInfo(HashMap<String, Object> userMap) {
        if (null != userMap.get("email")) {
            return userMap.get("email").toString();
        }
        if (null != userMap.get("biz_mail")) {
            return userMap.get("biz_mail").toString();
        }
        return null;
    }

    private String getCorpSecret(String corpId, String agentId) {
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"bos_wxqy_config", (String)"corpsecret, enable", (QFilter[])new QFilter[]{new QFilter("corpid", "=", (Object)corpId), new QFilter("agentid", "=", (Object)agentId)});
        if (null != load && load.length > 0) {
            DynamicObject dynamicObject = load[0];
            boolean enable = dynamicObject.getBoolean("enable");
            if (!enable) {
                throw new KDException(new ErrorCode("WxqyErrorMsg_22", WxqyErrorMsg.getCodeMsg("WxqyErrorMsg_22")), new Object[0]);
            }
            return dynamicObject.getString("corpsecret");
        }
        throw new KDException(new ErrorCode("WxqyErrorMsg_21", WxqyErrorMsg.getCodeMsg("WxqyErrorMsg_21")), new Object[0]);
    }
}

