/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.thirdauth.app.welink;

import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dc.api.model.Account;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.ksql.util.StringUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.thirdauth.app.welink.TicketResp;
import kd.bos.login.thirdauth.app.welink.UserResp;
import kd.bos.login.thirdauth.app.welink.WeLinkErrorMsg;
import kd.bos.login.thirdauth.app.welink.WeLinkUserInfo;
import kd.bos.login.utils.LoginUtils;
import kd.bos.login.utils.ParametersUtils;
import kd.bos.login.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.HttpClientUtils;

public class WeLinkUtils {
    private static final String LOGIN_WELINKHOST = "login_welinkhost";
    private static final String WELINKHOST = "welinkhost";
    private static Log logger = LogFactory.getLog(WeLinkUtils.class);
    private static ConcurrentHashMap<String, TicketResp> TicketRespMap = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, Long> accessTokenExpiresMap = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, Long> accessTokenTimeMap = new ConcurrentHashMap();

    @Deprecated
    public static TicketResp getAccessToken(String clientId, String clientSecret) {
        long currentTime = System.currentTimeMillis();
        TicketResp ticketResp = null;
        String key = clientId + clientSecret;
        ticketResp = TicketRespMap.get(key);
        Long accessTokenExpires = accessTokenExpiresMap.get(key);
        Long accessTokenTime = accessTokenTimeMap.get(key);
        if (Objects.isNull(accessTokenExpires)) {
            accessTokenExpires = 0L;
        }
        if (Objects.isNull(accessTokenTime)) {
            accessTokenTime = 0L;
        }
        if (Objects.nonNull(ticketResp) && currentTime - accessTokenTime < accessTokenExpires) {
            return TicketRespMap.get(key);
        }
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-type", "application/json");
        HashMap<String, String> ticketBodyParams = new HashMap<String, String>();
        ticketBodyParams.put("client_id", clientId);
        ticketBodyParams.put("client_secret", clientSecret);
        String weLinkhost = LoginUtils.getPathString(System.getProperty(LOGIN_WELINKHOST));
        String accessTokenUrl = "api/auth/v2/tickets";
        StringBuilder sb = new StringBuilder(weLinkhost);
        sb.append(accessTokenUrl);
        try {
            String ticketResult = HttpClientUtils.postjson((String)sb.toString(), header, (String)JSON.toJSONString(ticketBodyParams));
            logger.info(String.format("WeLinkUtils.getAccessToken.callBack.ticketResult", new Object[0]));
            if (StringUtil.isEmpty((String)ticketResult)) {
                return null;
            }
            ticketResp = (TicketResp)JSON.parseObject((String)ticketResult, TicketResp.class);
        }
        catch (Exception e) {
            logger.error("weLinkUtil.getAccessToken", (Throwable)e);
        }
        TicketRespMap.put(key, ticketResp);
        if (Objects.nonNull(ticketResp.getAccess_token()) && Objects.nonNull(ticketResp.getExpires_in())) {
            accessTokenExpiresMap.put(key, ticketResp.getExpires_in().longValue());
            accessTokenTimeMap.put(key, System.currentTimeMillis());
        }
        return ticketResp;
    }

    public static TicketResp getAccessToken(String clientId, String clientSecret, Account account) {
        try {
            return WeLinkUtils.getAccessTokenWithException(clientId, clientSecret, account);
        }
        catch (Exception e) {
            logger.info("getAccessToken error", (Object)e);
            return null;
        }
    }

    public static TicketResp getAccessTokenWithException(String clientId, String clientSecret, Account account) throws Exception {
        long currentTime = System.currentTimeMillis();
        String key = clientId + clientSecret;
        TicketResp ticketResp = TicketRespMap.get(key);
        Long accessTokenExpires = accessTokenExpiresMap.get(key);
        Long accessTokenTime = accessTokenTimeMap.get(key);
        if (Objects.isNull(accessTokenExpires)) {
            accessTokenExpires = 0L;
        }
        if (Objects.isNull(accessTokenTime)) {
            accessTokenTime = 0L;
        }
        if (Objects.nonNull(ticketResp) && currentTime - accessTokenTime < accessTokenExpires) {
            return TicketRespMap.get(key);
        }
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-type", "application/json");
        HashMap<String, String> ticketBodyParams = new HashMap<String, String>();
        ticketBodyParams.put("client_id", clientId);
        ticketBodyParams.put("client_secret", clientSecret);
        String weLinkhost = WeLinkUtils.getWeLinkHost(account);
        String accessTokenUrl = "api/auth/v2/tickets";
        StringBuilder sb = new StringBuilder(weLinkhost);
        sb.append(accessTokenUrl);
        try {
            String ticketResult = HttpClientUtils.postjson((String)sb.toString(), header, (String)JSON.toJSONString(ticketBodyParams));
            logger.info(String.format("WeLinkUtils.getAccessToken.callBack.ticketResult", new Object[0]));
            if (StringUtil.isEmpty((String)ticketResult)) {
                return null;
            }
            ticketResp = (TicketResp)JSON.parseObject((String)ticketResult, TicketResp.class);
        }
        catch (Exception e) {
            if (e.getMessage().contains("timed out")) {
                throw new KDException(new ErrorCode("WeLinkErrorMsg_10", WeLinkErrorMsg.getCodeMsg("WeLinkErrorMsg_10")), new Object[0]);
            }
            throw e;
        }
        TicketRespMap.put(key, ticketResp);
        if (Objects.nonNull(ticketResp.getAccess_token()) && Objects.nonNull(ticketResp.getExpires_in())) {
            accessTokenExpiresMap.put(key, ticketResp.getExpires_in().longValue());
            accessTokenTimeMap.put(key, System.currentTimeMillis());
        }
        return ticketResp;
    }

    private static String getWeLinkHost(Account currentCenter) {
        Map<String, Object> parameters = null;
        if (null != currentCenter) {
            parameters = ParametersUtils.getCommonParameters(currentCenter);
        }
        String host = "https://open.welink.huaweicloud.com";
        if (parameters != null && null != parameters.get(WELINKHOST) && !"".equals(parameters.get(WELINKHOST))) {
            return LoginUtils.getPathString(String.valueOf(parameters.get(WELINKHOST)));
        }
        String pathString = System.getProperty(LOGIN_WELINKHOST);
        if (kd.bos.util.StringUtils.isNotEmpty((String)pathString)) {
            return LoginUtils.getPathString(pathString);
        }
        return LoginUtils.getPathString(host);
    }

    @Deprecated
    public static UserResp getUserResp(String code, String accessToken) {
        UserResp userResp = null;
        if (kd.bos.util.StringUtils.isEmpty((String)code) || kd.bos.util.StringUtils.isEmpty((String)accessToken)) {
            return null;
        }
        HashMap<String, String> userHeaderParams = new HashMap<String, String>();
        userHeaderParams.put("x-wlk-Authorization", accessToken);
        String weLinkhost = LoginUtils.getPathString(System.getProperty(LOGIN_WELINKHOST));
        String userRespUrl = "api/auth/v2/userid";
        StringBuilder sb = new StringBuilder(weLinkhost);
        sb.append(userRespUrl);
        sb.append("?code=").append(code);
        try {
            String userResult = HttpClientUtils.get((String)sb.toString(), userHeaderParams, null);
            if (StringUtil.isEmpty((String)userResult)) {
                return null;
            }
            userResp = (UserResp)JSON.parseObject((String)userResult, UserResp.class);
        }
        catch (Exception e) {
            logger.error("weLinkUtil.getUserResp", (Throwable)e);
        }
        return userResp;
    }

    public static UserResp getUserResp(String code, String accessToken, Account account) {
        try {
            return WeLinkUtils.getUserRespWithException(code, accessToken, account);
        }
        catch (Exception e) {
            logger.info("weLinkUtil.getUserResp", (Object)e);
            return null;
        }
    }

    public static UserResp getUserRespWithException(String code, String accessToken, Account account) throws Exception {
        if (kd.bos.util.StringUtils.isEmpty((String)code) || kd.bos.util.StringUtils.isEmpty((String)accessToken)) {
            return null;
        }
        HashMap<String, String> userHeaderParams = new HashMap<String, String>();
        userHeaderParams.put("x-wlk-Authorization", accessToken);
        String weLinkhost = WeLinkUtils.getWeLinkHost(account);
        String userRespUrl = "api/auth/v2/userid";
        StringBuilder sb = new StringBuilder(weLinkhost);
        sb.append(userRespUrl);
        sb.append("?code=").append(code);
        try {
            String userResult = HttpClientUtils.get((String)sb.toString(), userHeaderParams, null);
            if (StringUtil.isEmpty((String)userResult)) {
                return null;
            }
            return (UserResp)JSON.parseObject((String)userResult, UserResp.class);
        }
        catch (Exception e) {
            if (e.getMessage().contains("timed out")) {
                throw new KDException(new ErrorCode("WeLinkErrorMsg_12", WeLinkErrorMsg.getCodeMsg("WeLinkErrorMsg_12")), new Object[0]);
            }
            throw e;
        }
    }

    @Deprecated
    public static WeLinkUserInfo getUserInfo(String userId, String accessToken) {
        WeLinkUserInfo weLinkUserInfo = null;
        if (kd.bos.util.StringUtils.isEmpty((String)userId) || kd.bos.util.StringUtils.isEmpty((String)accessToken)) {
            return null;
        }
        HashMap<String, String> userHeaderParams = new HashMap<String, String>();
        userHeaderParams.put("x-wlk-Authorization", accessToken);
        String weLinkhost = LoginUtils.getPathString(System.getProperty(LOGIN_WELINKHOST));
        String userInfoPath = "api/contact/v1/users";
        StringBuilder sb = new StringBuilder(weLinkhost);
        sb.append(userInfoPath).append("?userId=").append(userId);
        try {
            String weLinkUserInfoResult = HttpClientUtils.get((String)sb.toString(), userHeaderParams, null);
            if (StringUtil.isEmpty((String)weLinkUserInfoResult)) {
                return null;
            }
            logger.info(String.format("WeLinkUtils.getUserInfo.callBack:weLinkUserInfoResult", new Object[0]));
            weLinkUserInfo = (WeLinkUserInfo)JSON.parseObject((String)weLinkUserInfoResult, WeLinkUserInfo.class);
        }
        catch (Exception e) {
            logger.error("weLinkUtil.getUserResp", (Throwable)e);
        }
        return weLinkUserInfo;
    }

    public static WeLinkUserInfo getUserInfo(String userId, String accessToken, Account account) {
        try {
            return WeLinkUtils.getUserInfoWithException(userId, accessToken, account);
        }
        catch (Exception e) {
            logger.info("weLinkUtil.getUserResp", (Object)e);
            return null;
        }
    }

    public static WeLinkUserInfo getUserInfoWithException(String userId, String accessToken, Account account) throws Exception {
        if (kd.bos.util.StringUtils.isEmpty((String)userId) || kd.bos.util.StringUtils.isEmpty((String)accessToken)) {
            return null;
        }
        HashMap<String, String> userHeaderParams = new HashMap<String, String>();
        userHeaderParams.put("x-wlk-Authorization", accessToken);
        String weLinkhost = WeLinkUtils.getWeLinkHost(account);
        String userInfoPath = "api/contact/v1/users";
        StringBuilder sb = new StringBuilder(weLinkhost);
        sb.append(userInfoPath).append("?userId=").append(userId);
        try {
            String weLinkUserInfoResult = HttpClientUtils.get((String)sb.toString(), userHeaderParams, null);
            if (StringUtil.isEmpty((String)weLinkUserInfoResult)) {
                return null;
            }
            return (WeLinkUserInfo)JSON.parseObject((String)weLinkUserInfoResult, WeLinkUserInfo.class);
        }
        catch (Exception e) {
            if (e.getMessage().contains("timed out")) {
                throw new KDException(new ErrorCode("WeLinkErrorMsg_14", WeLinkErrorMsg.getCodeMsg("WeLinkErrorMsg_14")), new Object[0]);
            }
            throw e;
        }
    }

    public static String getMobile(String mobileNumber) {
        String mobil = "";
        if (kd.bos.util.StringUtils.isEmpty((String)mobileNumber)) {
            return mobil;
        }
        if (mobileNumber.startsWith("+86-")) {
            return mobileNumber.substring(4);
        }
        return mobileNumber;
    }

    public static String getClientSecret(String clientId) {
        QFilter enableFilter = new QFilter("enable", "=", (Object)true);
        QFilter appidFilter = new QFilter("appid", "=", (Object)clientId);
        Map objectMap = BusinessDataServiceHelper.loadFromCache((String)"bos_welink_config", (String)"app_secret", (QFilter[])new QFilter[]{appidFilter, enableFilter});
        String appSecret = null;
        if (objectMap != null && objectMap.size() > 0) {
            DynamicObject dynamicObject = (DynamicObject)objectMap.keySet().stream().map(v -> (DynamicObject)objectMap.get(v)).collect(Collectors.toList()).get(0);
            appSecret = dynamicObject.getString("app_secret");
        }
        if (kd.bos.util.StringUtils.isEmpty(appSecret)) {
            appSecret = StringUtils.getTrimedBlank(System.getProperty("login_welink_clientSecret"));
        }
        return appSecret;
    }
}

