/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.thirdauth.app.yzj;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import kd.bos.dc.api.model.Account;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.CacheLoginData;
import kd.bos.login.thirdauth.app.AppAuthResult;
import kd.bos.login.thirdauth.app.ThirdAppAuthtication;
import kd.bos.login.thirdauth.app.UserType;
import kd.bos.login.utils.AgentUtil;
import kd.bos.login.utils.BeanUtils;
import kd.bos.login.utils.HttpUtils;
import kd.bos.login.utils.LoginUtils;
import kd.bos.login.utils.SignEncrypter;
import kd.bos.login.utils.StringUtils;
import kd.bos.login.yunzhijia.YunzhijiaAppContext;
import kd.bos.login.yunzhijia.lightapp.YunzhijiaTicketService;
import kd.bos.util.JSONUtils;
import org.jetbrains.annotations.NotNull;

public class YZJAppAuthtication
extends ThirdAppAuthtication {
    private static Log logger = LogFactory.getLog(YZJAppAuthtication.class);

    @Override
    public boolean isNeedHandle(HttpServletRequest request, Account currentCenter) {
        return this.checkNeedAuth(request, currentCenter);
    }

    @Override
    public AppAuthResult appAuthtication(HttpServletRequest request, Account currentCenter) {
        AppAuthResult result = new AppAuthResult();
        result.setSucceed(false);
        try {
            result = this.getAppAuthResultBySign(request, currentCenter);
            if (!result.isSucceed()) {
                result = this.getAppAuthResultByTicket(request, currentCenter);
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        String loginType = request.getParameter("logintype");
        if ("web".equalsIgnoreCase(loginType)) {
            result.setWeb(true);
        } else if ("mobile".equalsIgnoreCase(loginType)) {
            result.setWeb(false);
        }
        if (StringUtils.isEmpty(result.getAppType())) {
            result.setAppType("yzj");
        }
        return result;
    }

    private AppAuthResult getAppAuthResultByTicket(HttpServletRequest request, Account currentCenter) {
        String appId;
        AppAuthResult result = new AppAuthResult();
        String ticket = request.getParameter("ticket");
        YunzhijiaAppContext appCtx = YunzhijiaTicketService.getContextByTicket(ticket, appId = StringUtils.getTrimedBlank(LoginUtils.getAPPId(request)));
        if (appCtx != null && StringUtils.isNotEmpty(appCtx.getOpenid())) {
            result.setSucceed(true);
            result.setUserFlag(appCtx.getOpenid());
            result.setUserType(UserType.OPEN_ID);
            CacheLoginData.setAttribute((String)currentCenter.getAccountId(), (String)ticket, (String)appCtx.getOpenid(), (int)3600);
        }
        if (!AgentUtil.isMobile(request)) {
            result.setWeb(true);
        }
        return result;
    }

    private AppAuthResult getAppAuthResultBySign(HttpServletRequest request, Account currentCenter) throws IOException {
        String newSign;
        AppAuthResult result = new AppAuthResult();
        result.setSucceed(false);
        YZJResult yzjResult = this.getYZJResult(request);
        if (yzjResult != null && StringUtils.isNotEmpty(newSign = this.generatSingkey(yzjResult, currentCenter.getTenantId())) && newSign.equals(yzjResult.getSign())) {
            result.setSucceed(true);
            result.setUserFlag(yzjResult.getOpenId());
            result.setUserType(UserType.OPEN_ID);
            result.setAppType("YZJAPI");
        }
        return result;
    }

    private boolean checkNeedAuth(HttpServletRequest request, Account currentCenter) {
        boolean isNeed = false;
        String ticket = request.getParameter("ticket");
        String path = request.getRequestURI();
        String appId = LoginUtils.getAPPId(request);
        String ticketCache = CacheLoginData.getAttribute((String)currentCenter.getAccountId(), (String)ticket);
        if (StringUtils.isNotEmpty(ticketCache)) {
            return isNeed;
        }
        if ((path.toLowerCase(Locale.ENGLISH).contains("/mobile.html") || path.contains("/qing/lappEntrance.do") || StringUtils.isNotEmpty(appId)) && !StringUtils.isEmpty(ticket)) {
            isNeed = true;
        }
        if (!isNeed && "post".equalsIgnoreCase(request.getMethod())) {
            List<String> pathList = this.getConfiguredPaths();
            for (String newPath : pathList) {
                if (!path.contains(newPath)) continue;
                isNeed = true;
                break;
            }
        }
        return isNeed;
    }

    private YZJResult getYZJResult(HttpServletRequest request) throws IOException {
        Map bodyMap;
        YZJResult result = null;
        if (!"post".equalsIgnoreCase(request.getMethod())) {
            return null;
        }
        String body = HttpUtils.getBody(request);
        if (StringUtils.isNotEmpty(body) && (bodyMap = (Map)JSONUtils.cast((String)body, HashMap.class, (boolean)true)) != null) {
            logger.info("body=" + body);
            result = this.wrapYzjResult(bodyMap);
        }
        return result;
    }

    @NotNull
    private YZJResult wrapYzjResult(Map<String, Object> bodyMap) {
        YZJResult result = new YZJResult();
        result.setSign(StringUtils.getStringValue(bodyMap.get("sign")));
        if (bodyMap.get("param") != null) {
            Map paramMap = (Map)bodyMap.get("param");
            result.setOpenId(StringUtils.getStringValue(paramMap.get("openId")));
            if (paramMap.get("sourceIds") != null && StringUtils.isNotEmpty(paramMap.get("sourceIds").toString())) {
                List idList = (List)paramMap.get("sourceIds");
                result.setIdList(idList);
                result.setSourceType(StringUtils.getStringValue(paramMap.get("sourceType")));
            } else if (paramMap.get("bizIds") != null && StringUtils.isNotEmpty(paramMap.get("bizIds").toString())) {
                List idList = (List)paramMap.get("bizIds");
                result.setIdList(idList);
                result.setSourceType(StringUtils.getStringValue(paramMap.get("appId")));
            }
        }
        return result;
    }

    private List<String> getConfiguredPaths() {
        ArrayList<String> list = null;
        String cString = System.getProperty("yzj_sign_urls");
        if (StringUtils.isNotEmpty(cString)) {
            String[] cArray = cString.split(",");
            list = new ArrayList(cArray.length);
            for (String url : cArray) {
                list.add(url.trim());
            }
        }
        if (list == null) {
            list = new ArrayList<String>(8);
            list.add(this.getDefaultUrl());
        }
        return list;
    }

    private String getDefaultUrl() {
        return "/wf/batchAgreeTask";
    }

    private String generatSingkey(YZJResult yzjResult, String tenantId) {
        String newKey = null;
        if (yzjResult != null) {
            String signKey = this.getSignKey(tenantId);
            if (StringUtils.isNotEmpty(signKey)) {
                try {
                    SignEncrypter signEncrypter = (SignEncrypter)BeanUtils.getBean("kd.bos.login.utils.SignEncrypterImpl");
                    newKey = signEncrypter.genSign(signKey, yzjResult.getOpenId(), yzjResult.getSourceType(), yzjResult.getIdList());
                }
                catch (Exception e) {
                    logger.error((Throwable)e);
                }
            } else {
                logger.error("\u4e0d\u80fd\u83b7\u5f97app sign key value ");
            }
        }
        return newKey;
    }

    private String getSignKey(String tenantId) {
        String signKey = System.getProperty(tenantId + "_yzj_app_sign_key");
        if (StringUtils.isEmpty(signKey)) {
            signKey = System.getProperty("yzj_app_sign_key");
        }
        return signKey;
    }

    static class YZJResult {
        String sign;
        String openId;
        String sourceType;
        String appId;
        List<String> idList;

        YZJResult() {
        }

        public String getSourceType() {
            return this.sourceType;
        }

        public void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        public String getSign() {
            return this.sign;
        }

        public void setSign(String sign) {
            this.sign = sign;
        }

        public String getOpenId() {
            return this.openId;
        }

        public void setOpenId(String openId) {
            this.openId = openId;
        }

        public List<String> getIdList() {
            return this.idList;
        }

        public void setIdList(List<String> idList) {
            this.idList = idList;
        }

        public String getAppId() {
            return this.appId;
        }

        public void setAppId(String appId) {
            this.appId = appId;
        }
    }
}

