/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.thirdauth.impl;

import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dc.api.model.Account;
import kd.bos.login.thirdauth.LoginUserAuth;
import kd.bos.login.thirdauth.UserAccount;
import kd.bos.login.thirdauth.UserAuthResult;
import kd.bos.login.thirdauth.UserProperType;
import kd.bos.login.user.MCLoginUserService;
import kd.bos.login.utils.StringUtils;

public class MCLoginAuth
implements LoginUserAuth {
    private static final String BOS_LOGIN = "bos-login";
    private static final String LOGIN_ACTION_10 = "LoginAction_10";
    private static final String SPECIAL_USER = "administrator";

    @Override
    public UserAuthResult userAuthrize(UserAccount user, Account dataCenter) {
        return MCLoginAuth.loginByUserAndPassword(user, dataCenter);
    }

    public static UserAuthResult loginByUserAndPassword(UserAccount user, Account dataCenter) {
        UserAuthResult uar = new UserAuthResult();
        uar.setSucess(false);
        String userNo = user.getAccount();
        String password = user.getPassword();
        Map<String, String> proveMap = MCLoginAuth.getLoginResult(dataCenter, userNo, password);
        if ("0".equalsIgnoreCase(proveMap.get("success"))) {
            uar.setErrDesc(String.format(ResManager.loadKDString((String)"\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef\u3002", (String)LOGIN_ACTION_10, (String)BOS_LOGIN, (Object[])new Object[0]), ""));
            return uar;
        }
        UserProperType userType = UserProperType.getUserProperTypeByString(proveMap.get("UserPropertyKey"));
        uar.setUserType(userType);
        uar.setUser(userNo);
        uar.setJoinedEids(null);
        uar.setSucess(true);
        return uar;
    }

    private static Map<String, String> getLoginResult(Account dataCenter, String userNo, String password) {
        Map<String, String> proveMap = null;
        UserProperType userType = UserProperType.Mobile;
        if (StringUtils.isNotEmpty(userNo)) {
            proveMap = MCLoginUserService.proveErpUserPassword(dataCenter, userNo, password);
        }
        if (proveMap != null) {
            proveMap.put("UserPropertyKey", userType.toString());
        }
        return proveMap;
    }

    public static UserAuthResult loginByUserAndPassword(String userNo, String password, Account dataCenter) {
        UserAuthResult uar = new UserAuthResult();
        uar.setSucess(false);
        if (StringUtils.isEmpty(password)) {
            uar.setErrDesc(String.format(ResManager.loadKDString((String)"\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef\u3002", (String)LOGIN_ACTION_10, (String)BOS_LOGIN, (Object[])new Object[0]), ""));
            return uar;
        }
        Map<String, String> proveMap = MCLoginAuth.getLoginResult(dataCenter, userNo, password);
        if ("0".equalsIgnoreCase(proveMap.get("success"))) {
            uar.setErrDesc(String.format(ResManager.loadKDString((String)"\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef\u3002", (String)LOGIN_ACTION_10, (String)BOS_LOGIN, (Object[])new Object[0]), ""));
            return uar;
        }
        uar.setUserType(UserProperType.Mobile);
        uar.setUser(userNo);
        uar.setJoinedEids(null);
        uar.setSucess(true);
        return uar;
    }
}

