/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.thirdauth.impl;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dc.api.model.Account;
import kd.bos.login.thirdauth.LoginUserAuth;
import kd.bos.login.thirdauth.UserAccount;
import kd.bos.login.thirdauth.UserAuthResult;
import kd.bos.login.thirdauth.UserProperType;
import kd.bos.login.user.LoginUserService;
import kd.bos.login.user.PswStrategyService;
import kd.bos.login.utils.StringUtils;
import kd.bos.login.utils.ValidationUtils;

public class SelfCreateAuth
implements LoginUserAuth {
    private static final String BOS_LOGIN = "bos-login";
    private static final String LOGIN_ACTION_10 = "LoginAction_10";
    private static final String SPECIAL_USER = "administrator";

    @Override
    public UserAuthResult userAuthrize(UserAccount user, Account dataCenter) {
        return SelfCreateAuth.loginByUserAndPassword(user, dataCenter);
    }

    public static UserAuthResult loginByUserAndPassword(UserAccount user, Account dataCenter) {
        UserAuthResult uar = new UserAuthResult();
        uar.setSucess(false);
        String userNo = user.getAccount();
        Map<String, String> proveMap = SelfCreateAuth.getLoginResult(dataCenter, user);
        if ("0".equalsIgnoreCase(proveMap.get("success"))) {
            uar.setErrDesc(String.format(ResManager.loadKDString((String)"\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef\u3002", (String)LOGIN_ACTION_10, (String)BOS_LOGIN, (Object[])new Object[0]), ""));
            return uar;
        }
        UserProperType userType = UserProperType.getUserProperTypeByString(proveMap.get("UserPropertyKey"));
        uar.setUserType(userType);
        uar.setUser(userNo);
        uar.setJoinedEids(null);
        uar.setSucess(true);
        return uar;
    }

    private static boolean isMapEmpty(Map<String, String> proveMap) {
        boolean isEmpty = false;
        if (proveMap == null || proveMap.size() < 1 || "0".equalsIgnoreCase(proveMap.get("success"))) {
            isEmpty = true;
        }
        return isEmpty;
    }

    private static Map<String, String> getLoginResult(Account dataCenter, UserAccount user) {
        String userNo = user.getAccount();
        String password = user.getPassword();
        String loginType = user.getLoginType();
        Map<Object, Object> proveMap = new HashMap();
        UserProperType userType = UserProperType.Mobile;
        boolean isMobile = "1".equalsIgnoreCase(loginType);
        if (isMobile || ValidationUtils.isPhone(userNo) || SPECIAL_USER.equalsIgnoreCase(userNo)) {
            proveMap = LoginUserService.proveErpUserPassword(dataCenter, userNo, password);
        }
        if (!isMobile) {
            if (SelfCreateAuth.isMapEmpty(proveMap) && ValidationUtils.isEmail(userNo)) {
                proveMap = LoginUserService.proveErpUserPasswordByEmail(dataCenter, userNo, password);
                userType = UserProperType.Email;
            }
            if (SelfCreateAuth.isMapEmpty(proveMap) && StringUtils.isNotEmpty(userNo)) {
                proveMap = LoginUserService.proveErpUserPasswordByUserName(dataCenter, userNo, password);
                userType = UserProperType.UserName;
            }
        }
        proveMap.put("UserPropertyKey", userType.toString());
        return proveMap;
    }

    private static Map<String, String> getLoginResult(Account dataCenter, String userNo, String password) {
        UserAccount user = new UserAccount(userNo, password);
        return SelfCreateAuth.getLoginResult(dataCenter, user);
    }

    public static UserAuthResult loginByUserAndPassword(String userNo, String password, Account dataCenter, Map<String, String> userInfo) throws NumberFormatException {
        UserAuthResult uar = new UserAuthResult();
        uar.setSucess(false);
        if (StringUtils.isEmpty(password)) {
            uar.setErrDesc(String.format(ResManager.loadKDString((String)"\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef\u3002", (String)LOGIN_ACTION_10, (String)BOS_LOGIN, (Object[])new Object[0]), ""));
            return uar;
        }
        Map<String, Object> passwordStrategy = PswStrategyService.getPasswordStrategyByUserId(dataCenter, userInfo);
        Map<String, Object> lockedMap = PswStrategyService.isLocked(dataCenter, passwordStrategy, Long.parseLong(userInfo.get("userid")));
        boolean isLocked = (Boolean)lockedMap.get("isLocked");
        String msg = (String)lockedMap.get("message");
        if (isLocked) {
            uar.setErrDesc(msg);
            return uar;
        }
        Map<String, String> proveMap = SelfCreateAuth.getLoginResult(dataCenter, userNo, password);
        if ("0".equalsIgnoreCase(proveMap.get("success"))) {
            uar.setErrDesc(String.format(ResManager.loadKDString((String)"\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef\u3002", (String)LOGIN_ACTION_10, (String)BOS_LOGIN, (Object[])new Object[0]), ""));
            return uar;
        }
        uar.setUserType(UserProperType.Mobile);
        uar.setUser(userNo);
        uar.setJoinedEids(null);
        uar.setSucess(true);
        return uar;
    }

    public static String getSpecialUser() {
        return SPECIAL_USER;
    }
}

